﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HospitalCode table.
    /// </summary>
    public class HospitalCodeDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all the hospital codes for a given hospital.
        /// </summary>
        /// <returns></returns>
        public List<HospitalCode> GetAll(int? hospitalId)
        {
            List<HospitalCode> results = new List<HospitalCode>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HospitalCodeGet"))
                {
                    if (hospitalId != null)
                    {
                        command.Parameters.Add(new SqlParameter("@HospitalId", hospitalId));
                    }
                    results = GetPopulatedBusinessList<HospitalCode>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorHospitalCodeGetAll, ex, User, LogMessage.HIPS_MESSAGE_008);
            }
            return results;
        }

        #endregion Methods
    }
}