﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the State as part of an address (hospital address, patient address)
    /// </summary>
    [KnownType(typeof(State))]
    [Serializable]
    [DataContract]
    public class State : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the State id.
        /// </summary>
        /// <value>
        /// The State id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? StateId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}