﻿using System;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.PCEHR;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for individual document metadata items from DocumentList and ChangeHistoryView
    /// </summary>

    [KnownType(typeof(DocumentMetaDataItem))]
    [Serializable]
    [DataContract]
    public class DocumentMetaDataItem
    {
        #region Private Members

        private String authorInstitution;
        private String authorInstitutionName;
        private String authorPerson;
        private String authorPersonFamilyName;
        private String authorPersonGivenName;
        private String authorPersonNamePrefix;
        private DateTime creationTime;
        private String documentClassCode;
        private String documentClassName;
        private string documentEntryUuid;
        private int documentSize;
        private DocumentStatus documentStatusCode;
        private String documentUniqueId;
        private String formatCode;
        private String formatName;
        private String hash;
        private String healthCareFacilityTypeCode;
        private String healthCareFacilityTypeName;
        private String practiceSettingTypesCode;
        private String practiceSettingTypesName;
        private String repositoryUniqueId;
        private DateTime serviceStartTime;
        private DateTime serviceStopTime;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the AuthorInstitution.
        /// The HPI-O of the organisation that authored the document.
        /// </summary>
        /// <value>
        /// The authorInstitution
        /// </value>
        [DataMember]
        public String AuthorInstitution
        {
            get { return authorInstitution; }
            set { authorInstitution = value; }
        }

        /// <summary>
        /// Gets or sets the AuthorInstitutionName.
        /// The HPI-O of the organisation that authored the document.
        /// </summary>
        /// <value>
        /// The authorInstitutionName
        /// </value>
        [DataMember]
        public String AuthorInstitutionName
        {
            get { return authorInstitutionName; }
            set { authorInstitutionName = value; }
        }

        /// <summary>
        /// Gets or sets the AuthorPerson.
        /// The identifier of the individual that authored the document.
        /// </summary>
        /// <value>
        /// The authorPerson
        /// </value>
        [DataMember]
        public String AuthorPerson
        {
            get { return authorPerson; }
            set { authorPerson = value; }
        }

        /// <summary>
        /// Gets or sets the AuthorPersonFamilyName.
        /// The family name of the author.
        /// </summary>
        /// <value>
        /// The authorPersonFamilyName
        /// </value>
        [DataMember]
        public String AuthorPersonFamilyName
        {
            get { return authorPersonFamilyName; }
            set { authorPersonFamilyName = value; }
        }

        /// <summary>
        /// Gets or sets the AuthorPersonGivenName.
        /// The given name of the author.
        /// </summary>
        /// <value>
        /// The authorPersonGivenName
        /// </value>
        [DataMember]
        public String AuthorPersonGivenName
        {
            get { return authorPersonGivenName; }
            set { authorPersonGivenName = value; }
        }

        /// <summary>
        /// Gets or sets the AuthorPersonNamePrefix.
        /// The name prefix of the author.
        /// </summary>
        /// <value>
        /// The authorPersonNamePrefix
        /// </value>
        [DataMember]
        public String AuthorPersonNamePrefix
        {
            get { return authorPersonNamePrefix; }
            set { authorPersonNamePrefix = value; }
        }

        /// <summary>
        /// Gets or sets the CreationTime.
        /// The time the document was created.
        /// </summary>
        /// <value>
        /// The creationTime
        /// </value>
        [DataMember]
        public DateTime CreationTime
        {
            get { return creationTime; }
            set { creationTime = value; }
        }

        /// <summary>
        /// Gets or sets the DocumentClassCode.
        /// Class code (also called Document Type Code) for the type of document.
        /// </summary>
        /// <value>
        /// The documentClassCode
        /// </value>
        [DataMember]
        public String DocumentClassCode
        {
            get { return documentClassCode; }
            set { documentClassCode = value; }
        }

        /// <summary>
        /// Gets or sets the DocumentClassName.
        /// Class name (also called Document Type Code) for the type of document.
        /// </summary>
        /// <value>
        /// The documentClassName
        /// </value>
        [DataMember]
        public String DocumentClassName
        {
            get { return documentClassName; }
            set { documentClassName = value; }
        }

        /// <summary>
        /// Gets or sets the Document Entry UUID.
        /// This is the internal identifier of the document within the XDS repository.
        /// </summary>
        /// <value>
        /// The Document Entry UUID.
        /// </value>
        [DataMember]
        public string DocumentEntryUuid
        {
            get { return documentEntryUuid; }
            set { documentEntryUuid = value; }
        }

        /// <summary>
        /// Gets or sets the DocumentSize.
        /// The size of the CDA document.
        /// </summary>
        /// <value>
        /// The documentSize
        /// </value>
        [DataMember]
        public int DocumentSize
        {
            get { return documentSize; }
            set { documentSize = value; }
        }

        /// <summary>
        /// Gets or sets the DocumentStatus.
        /// The Status of the individual Document
        /// </summary>
        /// <value>
        /// The documentStatusCode
        /// </value>
        [DataMember]
        public DocumentStatus DocumentStatusCode
        {
            get { return documentStatusCode; }
            set { documentStatusCode = value; }
        }

        /// <summary>
        /// Gets or sets the DocumentUniqueId.
        /// Unique ID of the document .
        /// </summary>
        /// <value>
        /// The documentUniqueId
        /// </value>
        [DataMember]
        public String DocumentUniqueId
        {
            get { return documentUniqueId; }
            set { documentUniqueId = value; }
        }

        /// <summary>
        /// Gets or sets the FormatCode.
        /// Format codes for document conformance.
        /// </summary>
        /// <value>
        /// The formatCode
        /// </value>
        [DataMember]
        public String FormatCode
        {
            get { return formatCode; }
            set { formatCode = value; }
        }

        /// <summary>
        /// Gets or sets the FormatName.
        /// Format name for document conformance.
        /// </summary>
        /// <value>
        /// The formatName
        /// </value>
        [DataMember]
        public String FormatName
        {
            get { return formatName; }
            set { formatName = value; }
        }

        /// <summary>
        /// Gets or sets the Hash.
        /// A SHA-1 hash representation of the document.
        /// </summary>
        /// <value>
        /// The hash
        /// </value>
        [DataMember]
        public String Hash
        {
            get { return hash; }
            set { hash = value; }
        }

        /// <summary>
        /// Gets or sets the HealthCareFacilityTypeCode.
        /// Health Care Facility Type Code for the document.
        /// </summary>
        /// <value>
        /// The healthCareFacilityTypeCode
        /// </value>
        [DataMember]
        public String HealthCareFacilityTypeCode
        {
            get { return healthCareFacilityTypeCode; }
            set { healthCareFacilityTypeCode = value; }
        }

        /// <summary>
        /// Gets or sets the HealthCareFacilityTypeName.
        /// Health Care Facility Type Description for the document.
        /// </summary>
        /// <value>
        /// The healthCareFacilityTypeName
        /// </value>
        [DataMember]
        public String HealthCareFacilityTypeName
        {
            get { return healthCareFacilityTypeName; }
            set { healthCareFacilityTypeName = value; }
        }

        /// <summary>
        /// Gets or sets the PracticeSettingTypesCode.
        /// Practice Setting Code (also called Clinical Speciality Codes) of the document.
        /// </summary>
        /// <value>
        /// The practiceSettingTypesCode
        /// </value>
        [DataMember]
        public String PracticeSettingTypesCode
        {
            get { return practiceSettingTypesCode; }
            set { practiceSettingTypesCode = value; }
        }

        /// <summary>
        /// Gets or sets the PracticeSettingTypesName.
        /// Practice Setting Description (also called Clinical Speciality Codes) of the document.
        /// </summary>
        /// <value>
        /// The practiceSettingTypesName
        /// </value>
        [DataMember]
        public String PracticeSettingTypesName
        {
            get { return practiceSettingTypesName; }
            set { practiceSettingTypesName = value; }
        }

        /// <summary>
        /// Gets or sets the RepositoryUniqueId.
        /// This is the identifier of the XDS Repository containing the document.
        /// </summary>
        /// <value>
        /// The repositoryUniqueId
        /// </value>
        [DataMember]
        public String RepositoryUniqueId
        {
            get { return repositoryUniqueId; }
            set { repositoryUniqueId = value; }
        }

        /// <summary>
        /// Gets or sets the ServiceStartTime.
        /// The datetime the service being performed which caused the document to be created started.
        /// </summary>
        /// <value>
        /// The serviceStartTime
        /// </value>
        [DataMember]
        public DateTime ServiceStartTime
        {
            get { return serviceStartTime; }
            set { serviceStartTime = value; }
        }

        /// <summary>
        /// Gets or sets the ServiceStopTime.
        /// The datetime the service being performed which caused the document to be created stopped.
        /// </summary>
        /// <value>
        /// The serviceStopTime
        /// </value>
        [DataMember]
        public DateTime ServiceStopTime
        {
            get { return serviceStopTime; }
            set { serviceStopTime = value; }
        }

        #endregion Properties

        /// <summary>
        /// Generates a string representation of the item for logging or debugging purposes.
        /// </summary>
        /// <returns>A string representation of the item.</returns>
        public override string ToString()
        {
            return string.Format("Document({0})", documentUniqueId);
        }
    }
}