﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.Message;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Cda.Message
{
    /// <summary>
    /// Web service request message for the Create Discharge Summary Level 1A operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.CDA_V1)]
    public class CreateDischargeSummaryLevel1ARequest : RequestBase
    {
        /// <summary>
        /// Gets or sets the attached files (GIF, JPEG, PNG, TIFF or PDF) that
        /// will be referenced by the CDA document. Note that it is not necessary
        /// to include organisation logo file in the array because HIPS can
        /// automatically add the logo that is configured in the Hospital table
        /// of the PCEHR Data Store.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        [EntLibVal.Validators.ObjectCollectionValidator]
        public List<CdaAttachment> Attachments { get; set; }

        /// <summary>
        /// Gets or sets the data that is required to be added to finalise the CDA document.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.ObjectValidator]
        [EntLibVal.Validators.NotNullValidator]
        public CdaHeaderMetadata CdaHeaderMetadata { get; set; }

        /// <summary>
        /// Gets or sets an identifier of the patient
        /// (<see cref="Mrn">hospital MRN</see>,
        /// <see cref="StatePatientId">enterprise identifier</see>,
        /// <see cref="PatientMasterId">HIPS PatientMasterId</see> or
        /// <see cref="ValidatedIhi">Validated IHI</see>).
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public PatientIdentifierBase PatientIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the PDF discharge summary document.
        /// </summary>
        [MessageBodyMember(Order = 1)]
        [EntLibVal.Validators.NotNullValidator]
        public byte[] PdfDocument { get; set; }
    }
}