﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.PatientIdentifier
{
    /// <summary>
    /// Patient Master ID assigned by this instance of HIPS.
    /// </summary>
    [KnownType(typeof(PatientIdentifierBase))]
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class PatientMasterId : PatientIdentifierBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the value of the Hospital ID. If supplied, this overrides the HospitalCode.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.RangeValidator(
            0,
            EntLibVal.Validators.RangeBoundaryType.Inclusive,
            int.MaxValue,
            EntLibVal.Validators.RangeBoundaryType.Inclusive)]
        [EntLibVal.Validators.IgnoreNulls]
        public int? HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the value of the Patient Master ID.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.RangeValidator(
            0,
            EntLibVal.Validators.RangeBoundaryType.Inclusive,
            int.MaxValue,
            EntLibVal.Validators.RangeBoundaryType.Inclusive)]
        public int Value { get; set; }

        #endregion Properties
    }
}