﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{
    /// <summary>
    /// Represents a failure within the conditions defined to validate the request to the service operation.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class InvalidRequestFault : FaultBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="InvalidRequestFault" /> class.
        /// </summary>
        public InvalidRequestFault()
        {
            this.Messages = new List<Common.DTO.Message>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the set of messages associated with the fault.
        /// </summary>
        [DataMember]
        public virtual List<Common.DTO.Message> Messages { get; set; }

        #endregion Properties
    }
}