﻿using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// HPI-I Identifier Query DTO. This object represents an identifier search query.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    [EntLibVal.Validators.HasSelfValidation]
    public class IdentifierQuery : Query
    {
        #region Properties

        /// <summary>
        /// Gets or sets the HPI-I number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.StringLengthValidator(16, 16)]
        public string HpiiNumber { get; set; }

        /// <summary>
        /// Gets or sets the registration ID.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string RegistrationId { get; set; }

        /// <summary>
        /// Gets or sets the Australian postcode.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 4)]
        [EntLibVal.Validators.IgnoreNulls]
        public string AustralianPostcode { get; set; }

        /// <summary>
        /// Gets or sets the Australian state.
        /// </summary>
        [DataMember(IsRequired = false)]
        public AustralianState AustralianState { get; set; }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Validate the instance is valid.
        /// </summary>
        /// <param name="results">Validation results to add results of validation to.</param>
        [EntLibVal.Validators.SelfValidation]
        protected new void Validate(EntLibVal.ValidationResults results)
        {
            if (string.IsNullOrEmpty(this.HpiiNumber))
            {
                if (string.IsNullOrEmpty(this.RegistrationId))
                {
                    results.AddResult(new EntLibVal.ValidationResult("Query must contain either HpiiNumber or RegistrationId.", this, "IdentifierQuery", string.Empty, null));
                }
            }
            else
            {
                if (!string.IsNullOrEmpty(this.RegistrationId))
                {
                    results.AddResult(new EntLibVal.ValidationResult("Query must not contain both HpiiNumber and RegistrationId.", this, "IdentifierQuery", string.Empty, null));
                }
            }
        }

        #endregion Methods
    }
}