﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Pcehr.Message;

namespace HIPS.ServiceContracts.Pcehr
{
    /// <summary>
    /// Web service interface for the PCEHR service version 2.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PCEHR_V2)]
    public interface IPcehrServiceV2
    {
        /// <summary>
        /// This operation looks up a patient record in the current facility (for advertised status) and disclosure facility (for disclosed status),
        /// gets a validated IHI for the patient, and optionally refreshes the advertised status from the PCEHR system.
        /// </summary>
        /// <param name="request">RefreshPatientParticipationStatusRequest request parameters</param>
        /// <returns>Response indicating the participation status of the patient.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(PcehrServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        RefreshPatientParticipationStatusResponse RefreshPatientParticipationStatus(RefreshPatientParticipationStatusRequest request);

        /// <summary>
        /// Uploads a PDF discharge summary to the PCEHR National Repository, optionally superseding a previously-uploaded document.
        /// This takes in the PDF document, required metadata, and any attachments and creates a CDA document before packaging it.
        /// </summary>
        /// <param name="request">Request containing a PDF and required metadata for creating the CDA package.</param>
        /// <returns>Response indicating that the request was queued or the reason why not.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(PcehrServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        UploadDischargeSummaryLevel1AResponse UploadOrSupersedeDischargeSummaryLevel1A(UploadDischargeSummaryLevel1ARequest request);

        /// <summary>
        /// Determines whether a PCEHR is advertised looking at local data only.
        /// </summary>
        /// <param name="request">IsPcehrAdvertisedLocalRequest request.</param>
        /// <returns>Response inditicating if the patients PCEHR is advertised and the current access code</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(PcehrServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        IsPcehrAdvertisedLocalResponse IsPcehrAdvertisedLocal(IsPcehrAdvertisedLocalRequest request);
    }
}