﻿using System.ServiceModel;
using HIPS.PcehrSchemas;

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// MSMQ service interface for the PCEHR Message Queue.
    /// </summary>
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IPcehrQueueInterface")]
    public interface IPcehrQueueInterface
    {
        /// <summary>
        /// Interface for a queued Remove operation, to remove a clinical document from the PCEHR system.
        /// </summary>
        /// <param name="message">The operation object</param>
        [OperationContract(IsOneWay = true)]
        void SendRemoveRequest(QueuedRemoveOperation message);

        /// <summary>
        /// Interface for a queued UploadOrSupersede operation, to upload a clinical document to the PCEHR system.
        /// </summary>
        /// <param name="message">The operation object</param>
        [OperationContract(IsOneWay = true)]
        void SendUploadRequest(QueuedUploadOperation message);
    }
}