﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.IhiSchemas.Schemas;

#endregion Using Directives

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the PUMA Interface service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IPumaInterfaceService")]
    public interface IPumaInterfaceService
    {
        /// <summary>
        /// Search for an IHI by number, but do not check to see if the PCEHR exists.
        /// </summary>
        /// <param name="hospitalId">The hospital ID.</param>
        /// <param name="searchDetails">The search details.</param>
        /// <param name="user">The user.</param>
        /// <returns>HIPS IHI Response.</returns>
        [OperationContract]
        HipsIhiResponse IHISearchByNumber(int hospitalId, IhiSearchCriteria searchDetails, UserDetails user);

        /// <summary>
        /// Search for an IHI by number, and check to see if the PCEHR exists.
        /// </summary>
        /// <param name="hospitalId">The hospital ID.</param>
        /// <param name="searchDetails">The search details.</param>
        /// <param name="user">The user.</param>
        /// <returns>HIPS IHI Response.</returns>
        [OperationContract]
        HipsIhiResponse IHISearchByNumberAndPCEHRCheck(int hospitalId, IhiSearchCriteria searchDetails, UserDetails user);
    }
}