﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.Text;
using System.Text.RegularExpressions;
using System.Xml;

namespace Test.CommonCcaNoc.Helpers
{


    /// <summary>
    /// Implementation of a behaviour that instantiates a MessageInspector.
    /// </summary>
    public class InspectorBehavior : IEndpointBehavior
    {
        private XmlAction action;
        private string xmlMatch;
        private string xmlText;

        public InspectorBehavior(XmlAction action, string xmlMatch = null, string xmlText = null)
        {
            this.action = action;
            this.xmlMatch = xmlMatch;
            this.xmlText = xmlText;
        }

        public void AddBindingParameters(ServiceEndpoint endpoint, System.ServiceModel.Channels.BindingParameterCollection bindingParameters)
        {
        }

        public void ApplyClientBehavior(ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(new MessageInspector(action, xmlMatch, xmlText));
        }

        public void ApplyDispatchBehavior(ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.EndpointDispatcher endpointDispatcher)
        {
        }

        public void Validate(ServiceEndpoint endpoint)
        {
        }
    }

    public enum XmlAction
    {
        Remove = 1,
        Replace = 2,
        Add = 3
    }

    public class MessageInspector : IClientMessageInspector
    {
        private XmlAction action;
        private string xmlMatch;
        private string xmlText;

        public MessageInspector(XmlAction action, string xmlMatch = null, string xmlText = null)
        {
            this.action = action;
            this.xmlMatch = xmlMatch;
            this.xmlText = xmlText;
        }

        public object BeforeSendRequest(ref System.ServiceModel.Channels.Message request, System.ServiceModel.IClientChannel channel)
        {
            string bigXml = ConvertMessageToString(request);

            switch (action)
            {
                case XmlAction.Add:
                    //not yet implemented - use XPATH here
                    break;
                case XmlAction.Remove:
                    //remove the xml item 
                    bigXml = Regex.Replace(bigXml, xmlMatch, "");
                    break;
                case XmlAction.Replace:
                    //remove the xml item and replace
                    bigXml = Regex.Replace(bigXml, xmlMatch, xmlText);
                    break;
                default:
                    break;
            }


            byte[] xmlArray = Encoding.UTF8.GetBytes(bigXml);
           System.Xml.XmlDictionaryReaderQuotas xdq = new XmlDictionaryReaderQuotas();

            var reader = XmlDictionaryReader.CreateTextReader(xmlArray, xdq);
            request = Message.CreateMessage(reader, int.MaxValue, request.Version);

            //msgBuffer.Close();

            return null;
        }
        public void AfterReceiveReply(ref System.ServiceModel.Channels.Message reply, object correlationState)
        {

        }

        /// <summary>
        /// Convert the message to a string.
        /// </summary>
        /// <param name="msg">Message to convert.</param>
        /// <returns>Message as a string.</returns>
        private static string ConvertMessageToString(System.ServiceModel.Channels.Message msg)
        {
            var ms = new MemoryStream();
            var xw = XmlTextWriter.Create(ms, new XmlWriterSettings()
            {
                Indent = false,
                OmitXmlDeclaration = true
            });
            msg.WriteMessage(xw);
            xw.Close();
            ms.Position = 0;

            var sr = new StreamReader(ms);
            var convertedString = sr.ReadToEnd();

            sr.Close();
            ms.Close();

            return convertedString;
        }
    }
}
