﻿using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using Test.CommonCcaNoc.Helpers;
using Test.Helpers;

namespace Test.HiCcaNoc.CCA.UC_325
{
    /// <summary>
    /// The software shall be capable of validating HPI-Is described in the HI Service system interface specification TECH.SIS.HI. 15, 17, 31 or 33.
    /// </summary>
    [TestClass]
    public class HI_CCA_325_010041 : CcaTest
    {
        /// <summary>
        /// When searching for an individual healthcare provider directory entry the software is capable of validating the HPI-Is.
        /// 
        /// a. Verify that the system validates the HPI-Is described in the HI Service system interface specification TECH.SIS.HI.15, 17, 31 or 33.
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_325")]
        public void HI_CCA_325_010041_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();
            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiValidation(query, user);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(provider.TestProviderHpiiNumber, hpiiResponse.HpiiNumber, DialogueResource.HpiiNumber);

            var audit = provider.GetLastHpiiLookupAudit();
            LogAssert.IsTrue(string.IsNullOrEmpty(audit.Message), "Message is empty.", "Message is not empty.");
        }    
    }
}
