﻿using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using System.Xml;
using System.Xml.Schema;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.NpdrCcaNoc.NoticeOfConnection
{
    /// <summary>
    /// Conformance Test Specification: NPDR Notice of Connection Test Plan
    ///                                 Version 1.1 — 15 July 2013
    /// Operation:  NPDR Schematron validation
    /// </summary>
    [TestClass]
    public class NOC_SchematronValidation : CcaTest
    {
        /// <summary>
        /// Test No:         NOC_DC_017
        /// 
        /// Objective/Input:
        /// Perform a Provide and Register Document set - b operation where the
        /// HPIO value is empty
        ///
        /// Expected Result:
        /// Document should fail validation at the client end before submission
        /// to the NPDR due to validation failure in the client side system.
        /// Document should not be processed and sent to NPDR.
        /// </summary>
        [TestMethod]
        [TestCategory("NPDR_NOC")]
        public void NPDR_NOC_17()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "NOC ID 17");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            CdaDocument document = patient.CreateNewDocument(SampleDocumentType.PcehrDispenseRecord);
            document.SetHpiO(string.Empty);
            HipsResponse hipsResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(document.GetBytes(), identifier, user, null, patient.TargetEpisode.AdmissionDate, document.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, hipsResponse, DialogueResource.HipsServiceUploadDocument);
        }

        /// <summary>
        /// Test No:         NOC_DC_018
        /// 
        /// Objective/Input:
        /// Perform a Provide and Register Document set - b operation where the
        /// HPII value is empty
        ///
        /// Expected Result:
        /// Document should fail validation at the client end before submission
        /// to the NPDR due to validation failure in the client side system.
        /// Document should not be processed and sent to NPDR.
        /// </summary>
        [TestMethod]
        [TestCategory("NPDR_NOC")]
        public void NPDR_NOC_18()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "NOC ID 17");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            CdaDocument document = patient.CreateNewDocument(SampleDocumentType.PcehrDispenseRecord);
            document.SetHpiI(string.Empty);
            HipsResponse hipsResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(document.GetBytes(), identifier, user, null, patient.TargetEpisode.AdmissionDate, document.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, hipsResponse, DialogueResource.HipsServiceUploadDocument);
        }

        /// <summary>
        /// Test No:         NOC_DC_019
        /// 
        /// Objective/Input:
        /// Perform a Provide and Register Document set - b operation where the
        /// IHI value is empty
        ///
        /// Expected Result:
        /// Document should fail validation at the client end before submission
        /// to the NPDR due to validation failure in the client side system.
        /// Document should not be processed and sent to NPDR.
        /// </summary>
        [TestMethod]
        [TestCategory("NPDR_NOC")]
        public void NPDR_NOC_19()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "NOC ID 17");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            CdaDocument document = patient.CreateNewDocument(SampleDocumentType.PcehrDispenseRecord);
            document.SetIhi(string.Empty);
            HipsResponse hipsResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(document.GetBytes(), identifier, user, null, patient.TargetEpisode.AdmissionDate, document.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, hipsResponse, DialogueResource.HipsServiceUploadDocument);
        }

        /// <summary>
        /// Test No:         NOC_DC_020
        /// 
        /// Objective/Input:
        /// Perform a Provide and Register Document set - b operation where the
        /// DOB value is empty
        ///
        /// Expected Result:
        /// Document should fail validation at the client end before submission
        /// to the NPDR due to validation failure in the client side system.
        /// Document should not be processed and sent to NPDR.
        /// </summary>
        [TestMethod]
        [TestCategory("NPDR_NOC")]
        public void NPDR_NOC_20()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "NOC ID 17");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            CdaDocument document = patient.CreateNewDocument(SampleDocumentType.PcehrDispenseRecord);
            document.SetDateOfBirth(null);
            HipsResponse hipsResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(document.GetBytes(), identifier, user, null, patient.TargetEpisode.AdmissionDate, document.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, hipsResponse, DialogueResource.HipsServiceUploadDocument);
        }

        /// <summary>
        /// Test No:         NOC_DC_021
        /// 
        /// Objective/Input:
        /// Perform a Provide and Register Document set - b operation where the
        /// time format is incorrect
        ///
        /// Expected Result:
        /// Document should fail validation at the client end before submission
        /// to the NPDR due to validation failure in the client side system.
        /// Document should not be processed and sent to NPDR.
        /// </summary>
        [TestMethod]
        [TestCategory("NPDR_NOC")]
        public void NPDR_NOC_21()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "NOC ID 17");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            CdaDocument document = patient.CreateNewDocument(SampleDocumentType.PcehrDispenseRecord);
            document.SetCreationTime("9/01/2014 3:47PM");
            HipsResponse hipsResponse = ProxyHelper.PcehrProxy.UploadOrSupersedeDocument(document.GetBytes(), identifier, user, null, patient.TargetEpisode.AdmissionDate, document.GetFormatCode());
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, hipsResponse, DialogueResource.HipsServiceUploadDocument);
        }
    }
}