﻿using HIPS.CommonSchemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_002_3
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.002.3
    /// Use Case Name:	Gain access to PCEHR (Emergency Access)
    /// Test Case ID:   PCEHR_CIS_019116
    /// Objective:
    /// To check that the conditions of emergency access are displayed before asserting emergency access to a PCEHR.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019116 : CcaTest
    {
        /// <summary>
        /// If the Clinical Information System supports gaining an emergency
        /// access to a healthcare recipient’s PCEHR:
        /// a. Request emergency access for a healthcare recipient whose record
        ///    is protected by a PACC code and whose record has not been
        ///    accessed before.
        /// b. Verify that the software displays the conditions of emergency
        ///    access before access is asserted.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_002_3")]
        public void CIS_0023_019116_AB()
        {
            string title = DialogueResource.CIS_0023_019116_AB_Title;

            // Removed these to minimise the number of dialog boxes displayed during a test run.
            //DialogResult result = MessageBox.Show(DialogueResource.CIS_0023_019116_AB_Q1, title, MessageBoxButtons.YesNo);
            //LogAssert.AreEqual(DialogResult.Yes, result, DialogueResource.CIS_0023_019116_AB_Q1);
            //result = MessageBox.Show(DialogueResource.CIS_0023_019116_AB_Q2, title, MessageBoxButtons.YesNo);
            //LogAssert.AreEqual(DialogResult.Yes, result, DialogueResource.CIS_0023_019116_AB_Q2);

            // Changing 115 to 87 because 115 does not have a PACC (RAC)
            Log(DialogueResource.ChangedTestData115To87);
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_87");
            GainPcehrAccessResponse response = ProxyHelper.PcehrProxy.GainAccessEmergency(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response.HipsResponse, DialogueResource.HipsServiceGainAccessEmergency);
        }
    }
}