﻿using System.ServiceModel;
using HIPS.PcehrDataStore.Schemas;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Pcehr.Message;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_201
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.201
    /// Use Case Name:	Upload a Clinical Document
    /// Test Case ID:   PCEHR_CIS_017841b
    /// Objective:
    /// To check that the clinical information either retains any clinical
    /// document uploaded to the PCEHR System, or retains the original
    /// clinical information used to generate the clinical document uploaded
    /// to the PCEHR.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_017841b_1A : CcaTest
    {
        /// <summary>
        /// Create a clinical document for a healthcare recipient using the
        /// software, and upload the clinical document to the PCEHR System:
        /// Verify that the software system fulfils either criteria a or b:
        /// a. Retains the clinical information used to create the clinical
        ///    documents locally.
        /// b. Retains a copy of the clinical document that was uploaded.
        ///
        /// In this implementation, we demonstrate that HIPS retains a copy
        /// of the document.
        /// If that gets changed then this conformance requirement will need
        /// to be handled in another part of the CIS.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_201_1A")]
        public void CIS_201_017841b_1A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            Episode episode = patient.TargetEpisode;


            UploadDischargeSummaryLevel1ARequest request = patient.CreateDocument1ARequest();
            UploadDischargeSummaryLevel1AResponse response = new UploadDischargeSummaryLevel1AResponse();
            try
            {
                response = ProxyHelper.PcehrServiceV2Proxy.UploadOrSupersedeDischargeSummaryLevel1A(request);
            }
            catch (FaultException<ServiceOperationFault>)
            {
                LogAssert.ExpectResponseStatus(ResponseStatus.OK, response.Status, DialogueResource.HipsServiceUploadDocument);
            }

            LogAssert.ExpectResponseStatus(ResponseStatus.OK, response.Status, DialogueResource.HipsServiceUploadDocument);

            QueueHelper.WaitForQueuedOperation(patient, this.LogAssert, DialogueResource.UploadWaitTimeout);

            // Demonstrate criteria B, that the document is retained in the hips.ClinicalDocumentVersion table.
            ClinicalDocumentVersion version = patient.GetLastClinicalDocumentVersion();
            LogAssert.AreEqual(response.Data.DocumentId, version.SourceSystemDocumentId, DialogueResource.UploadedDocumentDocumentId);

        }
    }
}