﻿using System.Collections.Generic;
using System.Linq;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_204
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.204
    /// Use Case Name:	Download a Clinical Document
    /// Test Case ID:   PCEHR_CIS_019041
    /// Objective:
    /// To check that the Clinical Information System provides a capability to
    /// save or print a clinical document downloaded from the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019041 : CcaTest
    {
        /// <summary>
        /// Perform an operation to download a clinical document for a
        /// healthcare recipient from the PCEHR System.
        /// Verify that the software fulfils either criteria a or b:
        /// a. The software allows the user to save the downloaded clinical
        ///    document to the clinical information system.
        /// b. The software allows the user to print the downloaded clinical
        ///    document.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_204")]
        public void CIS_204_019041_A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_87");

            GainPcehrAccessResponse accessResponse = ProxyHelper.PcehrProxy.GainAccessEmergency(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, accessResponse.HipsResponse, DialogueResource.HipsServiceGainAccessEmergency);

            DocumentListResponse<PatientIdentifierBase> listResponse = ProxyHelper.PcehrProxy.GetDocumentListActive(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, listResponse.HipsResponse, DialogueResource.HipsServiceGetDocumentListActive);
            DocumentMetaDataItem item = listResponse.DocumentList.First(a => a.DocumentUniqueId == "2.25.143748757191086415251266790814966594096");

            DocumentRequest request = new DocumentRequest();
            request.DocumentUniqueId = item.DocumentUniqueId;
            request.RepositoryUniqueId = item.RepositoryUniqueId;
            request.SaveDocument = true;
            DocumentResponse response = ProxyHelper.PcehrProxy.RetrieveDocument(patient.TargetPatientIdentifier, patient.GetTestUser(), request);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response.HipsResponse, DialogueResource.HipsServiceRetrieveDocument);

            // Demonstrate that HIPS has saved the downloaded clinical document
            List<DownloadedDocument> list = patient.GetAllDownloadedDocuments();
            LogAssert.AreEqual(1, list.Count, DialogueResource.DownloadedDocumentsCount);
            LogAssert.AreEqual(item.DocumentUniqueId, list[0].SourceSystemDocumentId, DialogueResource.DownloadedDocumentDocumentId);
            LogAssert.AreEqualBinary(response.Document,
                CdaPackage.ExtractDocument(list[0].Package),
                DialogueResource.DownloadedDocumentCdaXmlMatch,
                DialogueResource.DownloadedDocumentCdaXmlMismatch);
        }
    }
}