﻿using System;
using System.Linq;
using System.Windows.Forms;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_301
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.301
    /// Use Case Name:	Access a View Service
    /// Test Case ID:   PCEHR_CIS_018634
    /// Objective:
    /// To check that the clinical information system validates the hash tags
    /// of a clinical document downloaded from the PCEHR System and indicates
    /// if the downloaded clinical document has been modified.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_018634 : CcaTest
    {
        /// <summary>
        /// If the clinical information systems downloads a view that is a CDA
        /// package the perform an operation to retrieve a view where the
        /// clinical document within the package has been changed to ensure
        /// that its hash value will not match the hash value in the package
        /// signature:
        /// a. Verify that the software indicates to the user that the CDA 
        ///    package hash value comparison has found the CDA package value is
        ///    invalid.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_301")]
        public void CIS_301_018634_A()
        {
            // We need to download the document from the appropriate IHI
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");

            // Ask the user to enable the workaround in GetView to replace the downloaded view with the invalid one.
            MessageBox.Show(DialogueResource.CIS_301_018634_A_Q1, DialogueResource.CIS_301_018634_A_Title, MessageBoxButtons.OK);

            GainPcehrAccessResponse accessResponse = ProxyHelper.PcehrProxy.GainAccessEmergency(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, accessResponse.HipsResponse, DialogueResource.HipsServiceGainAccessEmergency);

            PrescriptionAndDispenseViewRequest padvRequest = new PrescriptionAndDispenseViewRequest
            {
                FromDate = DateTime.Parse("1/1/2000"),
                ToDate = DateTime.Now
            };
            ViewResponse viewResponse = ProxyHelper.PcehrProxy.GetView(patient.TargetPatientIdentifier, patient.GetTestUser(), padvRequest);
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, viewResponse.HipsResponse, DialogueResource.HipsServiceGetView);
            LogAssert.AreEqual("Error verifying document - Manifest digest value mismatch", viewResponse.HipsResponse.HipsErrorMessage, DialogueResource.HipsErrorMessage);

            MessageBox.Show(DialogueResource.CIS_301_018634_A_Q2, DialogueResource.CIS_301_018634_A_Title, MessageBoxButtons.OK);
        }
    }
}