﻿/*
 * Copyright 2012 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Nehta.VendorLibrary.PCEHR
{
    /// <summary>
    /// Class codes.
    /// </summary>
    public enum ClassCodes
    {
        /// <summary>
        /// Shared health summary class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "LOINC", CodingSystemOID = "2.16.840.1.113883.6.1", ConceptCode = "60591-5", 
            ConceptName = "Patient Summary", AlternateName = "Shared Health Summary")]
        SharedHealthSummary,

        /// <summary>
        /// Ereferral class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "LOINC", CodingSystemOID = "2.16.840.1.113883.6.1", ConceptCode = "57133-1", 
            ConceptName = "Referral Note", AlternateName = "e-Referral")]
        eReferral,

        /// <summary>
        /// Specialist letter class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "LOINC", CodingSystemOID = "2.16.840.1.113883.6.1", ConceptCode = "51852-2",
            ConceptName = "Letter", AlternateName = "Specialist Letter")]
        SpecialistLetter,

        /// <summary>
        /// Discharge summary class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "LOINC", CodingSystemOID = "2.16.840.1.113883.6.1", ConceptCode = "18842-5",
            ConceptName = "Discharge Summarization Note", AlternateName = "Discharge Summary")]
        DischargeSummary,

        /// <summary>
        /// Event summary class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "LOINC", CodingSystemOID = "2.16.840.1.113883.6.1", ConceptCode = "34133-9",
            ConceptName = "Summarization of episode note", AlternateName = "Event Summary")]
        EventSummary,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16650",
            ConceptName = "Pharmaceutical Benefits Report", AlternateName = "Pharmaceutical Benefits Report")]
        PharmaceuticalBenefitsReport,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16671",
            ConceptName = "Australian Organ Donor Register", AlternateName = "Australian Organ Donor Register")]
        AustralianOrganDonorRegister,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16659",
            ConceptName = "Australian Childhood Immunisation Register", AlternateName = "Australian Childhood Immunisation Register")]
        AustralianChildhoodImmunisationRegister,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16644",
            ConceptName = "Medicare/DVA Benefits Report", AlternateName = "Medicare/DVA Benefits Report")]
        MedicareDvaBenefitsReport,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16681",
            ConceptName = "Consumer Entered Notes", AlternateName = "Consumer Entered Notes")]
        ConsumerEnteredNotes,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16685",
            ConceptName = "Consumer Entered Health Summary", AlternateName = "Consumer Entered Health Summary")]
        ConsumerEnteredHealthSummary,

        /// <summary>
        /// Dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16696",
            ConceptName = "Advanced Care Directive Custodian Record", AlternateName = "Advanced Care Directive Custodian Record")]
        AdvancedCareDirectiveCustodianRecord,

        /// <summary>
        /// PCEHR prescription record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16764",
            ConceptName = "PCEHR Prescription Record", AlternateName = "PCEHR Prescription Record")]
        PcehrPrescriptionRecord,

        /// <summary>
        /// PCEHR dispense record class code.
        /// </summary>
        [CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16765",
            ConceptName = "PCEHR Dispense Record", AlternateName = "PCEHR Dispense Record")]
        PcehrDispenseRecord

        // DONT YET EXIST
        ///// <summary>
        ///// Eprescription class code.
        ///// </summary>
        //[CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16100",
        //    ConceptName = "e-Prescription", AlternateName = "e-Prescription")]
        //ePrescription,

        ///// <summary>
        ///// Dispense record class code.
        ///// </summary>
        //[CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16112",
        //    ConceptName = "Dispense Record", AlternateName = "Dispense Record")]
        //DispenseRecord,

        ///// <summary>
        ///// Prescription request class code.
        ///// </summary>
        //[CodedValueAttribute(CodingSystem = "NCTIS Data Components", CodingSystemOID = "1.2.36.1.2001.1001.101", ConceptCode = "100.16285",
        //    ConceptName = "Prescription Request", AlternateName = "Prescription Request")]
        //PrescriptionRequest,

    }
}
