/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.xsp.CertificateValidationException;
import au.gov.nehta.xsp.CertificateValidator;
import au.gov.nehta.xsp.XspException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;

public class SimpleCertificateValidator
implements CertificateValidator {
    private final KeyStore truststore;

    public SimpleCertificateValidator(KeyStore keyStore) {
        this.truststore = keyStore;
    }

    public void validate(X509Certificate x509Certificate) throws CertificateValidationException, XspException {
        try {
            x509Certificate.checkValidity();
            this.isTrustedCertificate(x509Certificate);
        }
        catch (Exception exception) {
            throw new XspException(exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean isTrustedCertificate(X509Certificate x509Certificate) throws KeyStoreException {
        String string;
        if (this.truststore == null) {
            return true;
        }
        boolean bl = false;
        if (x509Certificate != null && (string = this.truststore.getCertificateAlias(x509Certificate)) != null) {
            bl = true;
        }
        return bl;
    }
}

