/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.ws.handler;

import com.sun.xml.ws.api.handler.MessageHandler;
import com.sun.xml.ws.api.handler.MessageHandlerContext;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.handler.MessageContext;

public final class LoggingHandler
implements MessageHandler<MessageHandlerContext> {
    public static final String EMPTY = "";
    public static final String ENCODING = "utf-8";
    private static final Logger LOG = Logger.getLogger(LoggingHandler.class.getName());
    private String lastSoapRequest;
    private String lastSoapResponse;
    private boolean dump;

    public LoggingHandler(boolean bl) {
        this.dump = bl;
    }

    public String getLastSoapResponse() {
        return this.lastSoapResponse;
    }

    public String getLastSoapRequest() {
        return this.lastSoapRequest;
    }

    public boolean handleMessage(MessageHandlerContext messageHandlerContext) {
        this.logSOAPMessage(messageHandlerContext);
        return true;
    }

    public boolean handleFault(MessageHandlerContext messageHandlerContext) {
        this.logSOAPMessage(messageHandlerContext);
        return true;
    }

    private void logSOAPMessage(MessageHandlerContext messageHandlerContext) {
        boolean bl = (Boolean)messageHandlerContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (bl) {
            this.lastSoapRequest = this.getSoapAsString(messageHandlerContext);
            if (this.dump) {
                LOG.info("Outgoing" + this.lastSoapRequest);
            }
        } else {
            this.lastSoapResponse = this.getSoapAsString(messageHandlerContext);
            if (this.dump) {
                LOG.info("Incoming" + this.lastSoapResponse);
            }
        }
    }

    private String getSoapAsString(MessageHandlerContext messageHandlerContext) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Message message = messageHandlerContext.getMessage().copy();
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create((OutputStream)byteArrayOutputStream);
        String string = EMPTY;
        try {
            message.writeTo(xMLStreamWriter);
            string = byteArrayOutputStream.toString();
        }
        catch (XMLStreamException xMLStreamException) {
            LOG.severe("Error logging soap message: " + xMLStreamException.getMessage());
        }
        return string;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }
}

