/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

class MappedNamespaceContext
implements NamespaceContext {
    private final Map<String, String> nsMap;

    MappedNamespaceContext(Map<String, String> nsMap) {
        this.nsMap = nsMap;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.nsMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String prefix = null;
        for (String currPrefix : this.nsMap.keySet()) {
            String currNsUri = this.nsMap.get(currPrefix);
            if (!currNsUri.equals(namespaceURI)) continue;
            prefix = currPrefix;
            break;
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> prefixList = new ArrayList<String>();
        String prefix = this.getPrefix(namespaceURI);
        if (prefix != null) {
            prefixList.add(prefix);
        }
        return prefixList.iterator();
    }
}

