/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.view;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentQueryParams;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentStatus;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSMapper;
import au.gov.nehta.xsp.CertificateValidator;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRegistryPortType;
import ihe.iti.xds_b._2007.DocumentRegistryService;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import org.apache.commons.lang.Validate;

public final class GetDocumentListClient
extends Client<DocumentRegistryPortType> {
    public GetDocumentListClient(SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String string, boolean bl) {
        super(DocumentRegistryService.class, DocumentRegistryPortType.class, sSLSocketFactory, x509Certificate, privateKey, string, bl);
    }

    public GetDocumentListClient(SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, CertificateValidator certificateValidator, PrivateKey privateKey, String string, boolean bl) {
        super(DocumentRegistryService.class, DocumentRegistryPortType.class, sSLSocketFactory, x509Certificate, certificateValidator, privateKey, string, bl);
    }

    public AdhocQueryResponse getDocumentList(PCEHRHeader pCEHRHeader) {
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' must be specified.");
        CommonHeaderValidator.validate(pCEHRHeader, true);
        DocumentQueryParams documentQueryParams = new DocumentQueryParams();
        documentQueryParams.getStatuses().add(DocumentStatus.APPROVED);
        AdhocQueryRequest adhocQueryRequest = XDSMapper.toAdhocQueryRequest(pCEHRHeader, "urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d", documentQueryParams);
        Holder holder = null;
        return ((DocumentRegistryPortType)this.getPort()).documentRegistryRegistryStoredQuery(DateUtils.generateTimestamp(), holder, pCEHRHeader, adhocQueryRequest);
    }

    public AdhocQueryResponse getDocumentList(PCEHRHeader pCEHRHeader, DocumentQueryParams documentQueryParams) {
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)documentQueryParams, (String)"'queryParams' must be specified");
        CommonHeaderValidator.validate(pCEHRHeader, true);
        AdhocQueryRequest adhocQueryRequest = XDSMapper.toAdhocQueryRequest(pCEHRHeader, "urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d", documentQueryParams);
        Holder holder = null;
        return ((DocumentRegistryPortType)this.getPort()).documentRegistryRegistryStoredQuery(DateUtils.generateTimestamp(), holder, pCEHRHeader, adhocQueryRequest);
    }
}

