/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.ara;

import com.sun.enterprise.web.ara.RulesExecutor;
import com.sun.enterprise.web.ara.TaskWrapper;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedTask
extends TaskWrapper
implements TaskListener {
    public static final int ISOLATED_TASK = 4;
    protected StreamAlgorithm algorithm;
    protected RulesExecutor rulesExecutor;
    protected ArrayList<TaskListener> listeners = new ArrayList();
    protected int initialBytePosition;
    protected int initialByteLimit;
    protected TaskEvent<IsolatedTask> taskEvent = new TaskEvent();
    protected Pipeline pipeline;
    private static ConcurrentHashMap<SelectionKey, Pipeline> cacheKey = new ConcurrentHashMap();

    public IsolatedTask() {
        this.taskEvent.attach(this);
        this.taskEvent.setStatus(2);
    }

    @Override
    public void doTask() throws IOException {
        try {
            ReadTask readTask = (ReadTask)this.wrappedTask;
            ByteBuffer byteBuffer = readTask.getByteBuffer();
            SocketChannel socketChannel = (SocketChannel)readTask.getSelectionKey().channel();
            Socket socket = socketChannel.socket();
            socketChannel.read(byteBuffer);
            int position = byteBuffer.position();
            int limit = byteBuffer.limit();
            boolean execute = false;
            if (this.algorithm.parse(byteBuffer)) {
                execute = this.rulesExecutor.execute(this);
                if (execute) {
                    readTask.setBytesAvailable(true);
                    byteBuffer.limit(limit);
                    byteBuffer.position(position);
                    readTask.addTaskListener(this);
                    readTask.execute();
                } else {
                    this.fireTaskEvent(this.taskEvent);
                }
            } else {
                readTask.terminate(false);
                this.fireTaskEvent(this.taskEvent);
            }
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "IsolatedTask logic exception.", ex);
        }
    }

    public void setRulesExecutor(RulesExecutor rulesExecutor) {
        this.rulesExecutor = rulesExecutor;
    }

    public void setAlgorithm(StreamAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public IsolatedTask wrap(Task task) {
        this.wrappedTask = task;
        return this;
    }

    @Override
    public void execute() {
        this.run();
    }

    @Override
    public void run() {
        try {
            this.doTask();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addTaskListener(TaskListener task) {
        this.listeners.add(task);
    }

    @Override
    public void removeTaskListener(TaskListener task) {
        this.listeners.remove(task);
    }

    @Override
    public void clearTaskListeners() {
        this.listeners.clear();
    }

    protected void fireTaskEvent(TaskEvent<?> event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskEvent(event);
        }
    }

    @Override
    public void taskEvent(TaskEvent event) {
        this.wrappedTask = null;
        this.fireTaskEvent(this.taskEvent);
        ((ReadTask)event.attachement()).setPipeline(this.pipeline);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }
}

