/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class KeystoreUtil {
    private static final Logger LOG = Logger.getLogger(KeystoreUtil.class.getName());

    private KeystoreUtil() {
    }

    public static KeyStore loadKeyStore(String string, String string2, String string3) throws GeneralSecurityException {
        KeyStore keyStore = null;
        InputStream inputStream = null;
        ArgumentUtils.checkNotNullNorBlank((String)string, (String)"keystoreType");
        ArgumentUtils.checkNotNullNorBlank((String)string2, (String)"keystorePassword");
        ArgumentUtils.checkNotNullNorBlank((String)string3, (String)"keystorePathname");
        try {
            keyStore = KeyStore.getInstance(string);
            File file = new File(string3);
            inputStream = file.exists() ? new FileInputStream(string3) : null;
            keyStore.load(inputStream, string2.toCharArray());
            if (inputStream == null) {
                throw new FileNotFoundException("File not found " + string3);
            }
            inputStream.close();
            inputStream = null;
            LOG.info("Keystore " + string3 + " loaded");
        }
        catch (KeyStoreException keyStoreException) {
            throw new GeneralSecurityException("getInstance(" + string + ") error", keyStoreException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GeneralSecurityException("Couldn't find truststore " + string3, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new GeneralSecurityException(iOException.getMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new GeneralSecurityException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new GeneralSecurityException("Certificate error", certificateException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new GeneralSecurityException(iOException.getMessage(), iOException);
            }
        }
        return keyStore;
    }

    public static X509Certificate getSigningCertificate(String string, String string2, String string3, String string4) throws GeneralSecurityException {
        KeyStore keyStore = KeystoreUtil.loadKeyStore(string, string2, string3);
        return KeystoreUtil.getSigningCertificate(keyStore, string4);
    }

    public static X509Certificate getSigningCertificate(KeyStore keyStore, String string) throws GeneralSecurityException {
        ArgumentUtils.checkNotNull((Object)keyStore, (String)"keystore");
        ArgumentUtils.checkNotNullNorBlank((String)string, (String)"certificateAlias");
        try {
            Certificate certificate = keyStore.getCertificate(string);
            return certificate != null ? (X509Certificate)certificate : null;
        }
        catch (KeyStoreException keyStoreException) {
            throw new GeneralSecurityException(keyStoreException);
        }
    }

    public static PrivateKey getSigningPrivateKey(String string, String string2, String string3, String string4) throws GeneralSecurityException {
        KeyStore keyStore = KeystoreUtil.loadKeyStore(string, string2, string3);
        return KeystoreUtil.getSigningPrivateKey(keyStore, string2, string4);
    }

    public static PrivateKey getSigningPrivateKey(KeyStore keyStore, String string, String string2) throws GeneralSecurityException {
        ArgumentUtils.checkNotNull((Object)keyStore, (String)"keystore");
        ArgumentUtils.checkNotNullNorBlank((String)string2, (String)"privateKeyAlias");
        ArgumentUtils.checkNotNullNorBlank((String)string, (String)"keystorePassword");
        ArgumentUtils.checkNotNull((Object)keyStore.containsAlias(string2), (String)"keystore.containsAlias(privateKeyAlias)");
        try {
            Key key = keyStore.getKey(string2, string.toCharArray());
            return key != null ? (PrivateKey)key : null;
        }
        catch (KeyStoreException keyStoreException) {
            throw new GeneralSecurityException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new GeneralSecurityException(noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new GeneralSecurityException(unrecoverableKeyException);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeystoreUtil.loadKeyStore(string, string3, string2);
        KeyStore keyStore2 = KeystoreUtil.loadKeyStore(string6, string8, string7);
        KeystoreUtil.checkPrivateKey(keyStore, string4.toCharArray(), string5);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string4.toCharArray());
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        for (int i = 0; i < keyManagerArray.length; ++i) {
            if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
            keyManagerArray[i] = new AliasForcingX509KeyManager((X509KeyManager)keyManagerArray[i], string5);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore2);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    private static void checkPrivateKey(KeyStore keyStore, char[] cArray, String string) throws GeneralSecurityException {
        if (!keyStore.containsAlias(string)) {
            String string2 = "The SSLSocketFactory keystore doesn't have key alias '" + string + "'.";
            throw new GeneralSecurityException(string2);
        }
        if (!keyStore.isKeyEntry(string)) {
            String string3 = "The SSLSocketFactory keystore doesn't have a private key for alias '" + string + "'.";
            throw new GeneralSecurityException(string3);
        }
        try {
            keyStore.getKey(string, cArray);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new GeneralSecurityException("Couldn't recover the private key in the SSLSocketFactory keystore. The most likely reason is that the key password is wrong.", unrecoverableKeyException);
        }
    }

    private static class AliasForcingX509KeyManager
    implements X509KeyManager {
        private final X509KeyManager baseKM;
        private final String keyAlias;

        public AliasForcingX509KeyManager(X509KeyManager x509KeyManager, String string) {
            this.baseKM = x509KeyManager;
            this.keyAlias = string;
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return this.keyAlias;
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return this.baseKM.chooseServerAlias(string, principalArray, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.baseKM.getCertificateChain(string);
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return this.baseKM.getClientAliases(string, principalArray);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.baseKM.getPrivateKey(string);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return this.baseKM.getServerAliases(string, principalArray);
        }
    }
}

