/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.ws;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

public final class WebServiceClientUtil {
    private static final String REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private static final String INTERNAL_REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";

    private WebServiceClientUtil() {
    }

    public static <T> T getPort(Class<T> clazz, Class<? extends Service> clazz2, SocketFactory socketFactory, String string, List<Handler> list) {
        T t = WebServiceClientUtil.getPort(clazz, clazz2, socketFactory, string);
        WebServiceClientUtil.addHandlerChain(t, list);
        return t;
    }

    public static <T> T getPort(Class<T> clazz, Class<? extends Service> clazz2, SocketFactory socketFactory, String string) {
        WebServiceClient webServiceClient = clazz2.getAnnotation(WebServiceClient.class);
        String string2 = webServiceClient.wsdlLocation();
        Service service = WebServiceClientUtil.getService(webServiceClient, string2);
        Object object = service.getPort(clazz);
        WebServiceClientUtil.configurePortWithEndpoint(object, string);
        WebServiceClientUtil.configurePortWithSslSocketFactory(object, socketFactory);
        return (T)object;
    }

    public static <T> T getPort(Class<T> clazz, Class<? extends Service> clazz2, SocketFactory socketFactory, String string, List<Handler> list, boolean bl) {
        WebServiceClient webServiceClient = clazz2.getAnnotation(WebServiceClient.class);
        String string2 = webServiceClient.wsdlLocation();
        Service service = WebServiceClientUtil.getService(webServiceClient, string2);
        Object object = service.getPort(clazz, new WebServiceFeature[]{new AddressingFeature(bl)});
        WebServiceClientUtil.configurePortWithEndpoint(object, string);
        WebServiceClientUtil.configurePortWithSslSocketFactory(object, socketFactory);
        WebServiceClientUtil.addHandlerChain(object, list);
        return (T)object;
    }

    public static <T> T getPort(Class<T> clazz, Class<? extends Service> clazz2, SocketFactory socketFactory, List<Handler> list) {
        T t = WebServiceClientUtil.getPort(clazz, clazz2, socketFactory);
        WebServiceClientUtil.addHandlerChain(t, list);
        return t;
    }

    public static <T> T getPort(Class<T> clazz, Class<? extends Service> clazz2, SocketFactory socketFactory) {
        WebServiceClient webServiceClient = clazz2.getAnnotation(WebServiceClient.class);
        String string = webServiceClient.wsdlLocation();
        Service service = WebServiceClientUtil.getService(webServiceClient, string);
        Object object = service.getPort(clazz);
        WebServiceClientUtil.configurePortWithSslSocketFactory(object, socketFactory);
        return (T)object;
    }

    private static Service getService(WebServiceClient webServiceClient, String string) {
        URL uRL = WebServiceClientUtil.retrieveWsdlUrl(string);
        QName qName = new QName(webServiceClient.targetNamespace(), webServiceClient.name());
        return Service.create((URL)uRL, (QName)qName);
    }

    private static URL retrieveWsdlUrl(String string) {
        URL uRL = null;
        if (string != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRL = classLoader.getResource(string);
        }
        return uRL;
    }

    private static void configurePortWithSslSocketFactory(Object object, SocketFactory socketFactory) {
        BindingProvider bindingProvider = (BindingProvider)object;
        Map map = bindingProvider.getRequestContext();
        map.put(REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME, socketFactory);
        map.put(INTERNAL_REQUEST_CONTEXT_SSL_SOCKET_FACTORY_PROPERTY_NAME, socketFactory);
    }

    private static void configurePortWithEndpoint(Object object, String string) {
        BindingProvider bindingProvider = (BindingProvider)object;
        Map map = bindingProvider.getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string.trim());
    }

    private static void addHandlerChain(Object object, List<Handler> list) {
        BindingProvider bindingProvider = (BindingProvider)object;
        bindingProvider.getBinding().setHandlerChain(list);
    }
}

