/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp.impl.v1;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.xsp.CertificateValidationException;
import au.gov.nehta.xsp.CertificateValidator;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.impl.CertificateUtils;
import au.gov.nehta.xsp.impl.TextUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureProfileServiceImpl
implements XmlSignatureProfileService {
    private static final XMLSignatureFactory XML_SIGNATURE_FACTORY = XMLSignatureFactory.getInstance("DOM");
    private static final KeyInfoFactory KEY_INFO_FACTORY = XML_SIGNATURE_FACTORY.getKeyInfoFactory();
    private final String signedPayloadNamespace;

    public XmlSignatureProfileServiceImpl(String nsSignedPayloadV12) {
        this.signedPayloadNamespace = nsSignedPayloadV12;
    }

    @Override
    public void sign(Element elementToAddSigTo, Element elementToSign, X500PrivateCredential credential) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToSign, (String)"elementToSign");
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        this.sign(elementToAddSigTo, Arrays.asList(elementToSign), Arrays.asList(credential));
    }

    @Override
    public void sign(Element elementToAddSigTo, List<Element> elementsToSign, X500PrivateCredential credential) throws XspException {
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        this.sign(elementToAddSigTo, elementsToSign, Arrays.asList(credential));
    }

    @Override
    public void sign(Element elementToAddSigTo, Element elementToSign, List<X500PrivateCredential> credentials) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToSign, (String)"elementToSign");
        this.sign(elementToAddSigTo, Arrays.asList(elementToSign), credentials);
    }

    @Override
    public void sign(Element elementToAddSigTo, List<Element> elementsToSign, List<X500PrivateCredential> credentials) throws XspException {
        ArgumentUtils.checkNotNull((Object)elementToAddSigTo, (String)"elementToAddSigTo");
        ArgumentUtils.checkNotNullNorEmpty(elementsToSign, (String)"elementsToSign");
        ArgumentUtils.checkNotNullNorEmpty(credentials, (String)"credentials");
        Document containerDoc = elementToAddSigTo.getOwnerDocument();
        for (Element elementToSign : elementsToSign) {
            if (containerDoc == elementToSign.getOwnerDocument()) continue;
            String errMsg = "The element to sign, " + TextUtils.getDesc(elementToSign) + ", must belong to the same document as the element to add " + "the signatures to, " + TextUtils.getDesc(elementToAddSigTo) + ".";
            throw new IllegalArgumentException(errMsg);
        }
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        for (Element elementToSign : elementsToSign) {
            String referenceId = null;
            List<String> elemIdValues = XmlSignatureProfileServiceImpl.getIdValues(elementToSign);
            if (!elemIdValues.isEmpty()) {
                referenceId = elemIdValues.get(0);
            } else {
                referenceId = elementToSign.getAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:id");
                if (ArgumentUtils.isNullOrBlank((String)referenceId)) {
                    referenceId = "_" + UUID.randomUUID().toString();
                    elementToSign.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:id", referenceId);
                }
                elementToSign.setIdAttribute("xml:id", true);
            }
            Reference reference = XmlSignatureProfileServiceImpl.newReference(referenceId);
            referenceList.add(reference);
        }
        SignedInfo signedInfo = XmlSignatureProfileServiceImpl.newSignedInfo(referenceList);
        containerDoc.normalizeDocument();
        for (X500PrivateCredential credential : credentials) {
            X509Certificate signingCertificate = credential.getCertificate();
            PrivateKey signingPrivateKey = credential.getPrivateKey();
            KeyInfo keyInfo = XmlSignatureProfileServiceImpl.newKeyInfo(signingCertificate);
            XMLSignature signature = XML_SIGNATURE_FACTORY.newXMLSignature(signedInfo, keyInfo);
            DOMSignContext signContext = new DOMSignContext(signingPrivateKey, (Node)elementToAddSigTo);
            signContext.setDefaultNamespacePrefix("ds");
            try {
                signature.sign(signContext);
            }
            catch (Exception e) {
                throw new XspException("Couldn't create signature with credential, " + TextUtils.getDesc(signingCertificate) + ".", e);
            }
        }
    }

    @Override
    public void check(Element signatureElem, CertificateValidator certificateValidator) throws SignatureValidationException, CertificateValidationException, XspException {
        ArgumentUtils.checkNotNull((Object)signatureElem, (String)"signatureElem");
        ArgumentUtils.checkNotNull((Object)certificateValidator, (String)"certificateValidator");
        this.check(Arrays.asList(signatureElem), certificateValidator);
    }

    @Override
    public void check(List<Element> signatureElems, CertificateValidator certificateValidator) throws SignatureValidationException, CertificateValidationException, XspException {
        ArgumentUtils.checkNotNullNorEmpty(signatureElems, (String)"signatureElems");
        ArgumentUtils.checkNotNull((Object)certificateValidator, (String)"certificateValidator");
        this.markSignedPayloadIDs(signatureElems);
        for (Element signatureElem : signatureElems) {
            X509Certificate certificate = this.getSigningCertificate(signatureElem);
            DOMValidateContext validateContext = new DOMValidateContext(certificate.getPublicKey(), (Node)signatureElem);
            XMLSignature signature = XmlSignatureProfileServiceImpl.unmarshalSignature(signatureElem);
            boolean valid = false;
            try {
                valid = signature.validate(validateContext);
            }
            catch (XMLSignatureException e) {
                throw new XspException("Couldn't do validation on an XML Signature.", e);
            }
            if (!valid) {
                throw new SignatureValidationException("Invalid XML Signature signed by certificate: " + CertificateUtils.getSubjectName(certificate));
            }
            certificateValidator.validate(certificate);
        }
    }

    private void markSignedPayloadIDs(List<Element> signatureElems) {
        NodeList payloads = signatureElems.get(0).getOwnerDocument().getElementsByTagNameNS(this.signedPayloadNamespace, "signedPayloadData");
        for (int i = 0; i < payloads.getLength(); ++i) {
            ((Element)payloads.item(i)).setIdAttribute("id", true);
        }
    }

    @Override
    public X509Certificate getSigningCertificate(Element signatureElem) throws XspException {
        DomUtils.checkElement((Element)signatureElem, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
        XMLSignature signature = XmlSignatureProfileServiceImpl.unmarshalSignature(signatureElem);
        return XmlSignatureProfileServiceImpl.getSigningCertificate(signature);
    }

    @Override
    public Map<String, byte[]> getDigestValues(Element signatureElem) throws XspException {
        DomUtils.checkElement((Element)signatureElem, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
        XMLSignature signature = XmlSignatureProfileServiceImpl.unmarshalSignature(signatureElem);
        return XmlSignatureProfileServiceImpl.getDigestValues(signature);
    }

    private static List<String> getIdValues(Element element) {
        assert (element != null);
        ArrayList<String> elemIdValues = new ArrayList<String>();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.isId()) continue;
            elemIdValues.add(attr.getValue());
        }
        return elemIdValues;
    }

    private static Reference newReference(String referenceId) throws XspException {
        assert (referenceId != null && !referenceId.trim().isEmpty());
        try {
            DigestMethod digestMethod = XML_SIGNATURE_FACTORY.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
            Transform transform = XML_SIGNATURE_FACTORY.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
            return XML_SIGNATURE_FACTORY.newReference("#" + referenceId, digestMethod, Collections.singletonList(transform), null, null);
        }
        catch (Exception ex) {
            throw new XspException("Unable to create 'Reference'. " + ex.getMessage());
        }
    }

    private static SignedInfo newSignedInfo(List<Reference> referenceList) throws XspException {
        assert (referenceList != null);
        try {
            SignatureMethod signatureMethod = XML_SIGNATURE_FACTORY.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            CanonicalizationMethod canonicalisationMethod = XML_SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
            return XML_SIGNATURE_FACTORY.newSignedInfo(canonicalisationMethod, signatureMethod, referenceList);
        }
        catch (Exception ex) {
            throw new XspException("Unable to create 'SignedInfo'. " + ex.getMessage(), ex);
        }
    }

    private static KeyInfo newKeyInfo(X509Certificate certificate) {
        assert (certificate != null);
        X509Data x509Data = KEY_INFO_FACTORY.newX509Data(Collections.singletonList(certificate));
        return KEY_INFO_FACTORY.newKeyInfo(Collections.singletonList(x509Data));
    }

    private static X509Certificate getSigningCertificate(XMLSignature signature) throws XspException {
        assert (signature != null);
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo == null) {
            throw new XspException("A 'Signature' doesn't have a 'KeyInfo'.");
        }
        ArrayList<X509Data> x509DataObjects = new ArrayList<X509Data>();
        for (XMLStructure content : keyInfo.getContent()) {
            if (!(content instanceof X509Data)) continue;
            x509DataObjects.add((X509Data)content);
        }
        if (x509DataObjects.size() == 0) {
            throw new XspException("The 'KeyInfo' in a 'Signature' doesn't specify an 'X509Data'.");
        }
        if (x509DataObjects.size() > 1) {
            throw new XspException("The 'KeyInfo' in a 'Signature' specifies multiple 'X509Data'.");
        }
        X509Data x509Data = (X509Data)x509DataObjects.get(0);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (Object content : x509Data.getContent()) {
            if (!(content instanceof X509Certificate)) continue;
            certificates.add((X509Certificate)content);
        }
        if (certificates.size() == 0) {
            throw new XspException("The 'X509Data' in a 'Signature' doesn't specify an 'X509Certificate'.");
        }
        if (certificates.size() > 1) {
            throw new XspException("The 'X509Data' in a 'Signature' specifies multiple 'X509Certificate'.");
        }
        return (X509Certificate)certificates.get(0);
    }

    private static Map<String, byte[]> getDigestValues(XMLSignature signature) throws XspException {
        assert (signature != null);
        SignedInfo signedInfo = signature.getSignedInfo();
        if (signedInfo == null) {
            throw new XspException("A 'Signature' does not have a 'SignedInfo'.");
        }
        List<Reference> referenceList = signedInfo.getReferences();
        if (referenceList == null || referenceList.size() == 0) {
            throw new XspException("The 'SignedInfo' in a 'Signature' does not have a 'Reference'.");
        }
        HashMap<String, byte[]> resultMap = new HashMap<String, byte[]>();
        for (Reference reference : referenceList) {
            String uri = reference.getURI();
            if (ArgumentUtils.isNullOrBlank((String)uri)) {
                throw new XspException("A 'Reference' in the 'Signature/SignedInfo' does not have a 'URI'.");
            }
            byte[] digestValue = reference.getDigestValue();
            if (digestValue == null) {
                throw new XspException("A 'Reference' in the 'Signature/SignedInfo' does not have a 'DigestValue'.");
            }
            resultMap.put(uri, digestValue);
        }
        return resultMap;
    }

    private static XMLSignature unmarshalSignature(Element signatureElem) throws XspException {
        assert (signatureElem != null);
        try {
            DOMStructure domStructure = new DOMStructure(signatureElem);
            return XML_SIGNATURE_FACTORY.unmarshalXMLSignature(domStructure);
        }
        catch (MarshalException ex) {
            throw new XspException("Couldn't unmarshall signature element. " + ex.getMessage(), ex);
        }
    }
}

