/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.IMTOMHandler;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.SecurityHandler;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.gov.nehta.xsp.CertificateValidationException;
import au.gov.nehta.xsp.CertificateValidator;
import au.gov.nehta.xsp.XspException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang.Validate;

public abstract class Client<PortType> {
    private LoggingHandler loggingHandler;
    private List<Handler> handlerChain;
    private final PortType port;

    public Client(Class<? extends Service> clazz, Class<PortType> clazz2, SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, CertificateValidator certificateValidator, PrivateKey privateKey, String string, boolean bl) {
        Validate.notNull(clazz, (String)"'serviceClass' cannot be null.");
        Validate.notNull(clazz2, (String)"'portClass' cannot be null.");
        Validate.notNull((Object)sSLSocketFactory, (String)"'sslSocketFactory' cannot be null.");
        Validate.notNull((Object)x509Certificate, (String)"'x509Certificate' cannot be null.");
        Validate.notNull((Object)certificateValidator, (String)"'certificateVerifier' cannot be null.");
        Validate.notNull((Object)privateKey, (String)"'privateKey' cannot be null.");
        Validate.notEmpty((String)string, (String)"'endpointAddress' cannot be null nor empty.");
        this.loggingHandler = new LoggingHandler(bl);
        SecurityHandler securityHandler = new SecurityHandler(x509Certificate, privateKey, certificateValidator);
        this.handlerChain = new ArrayList<Handler>();
        this.handlerChain.add((Handler)securityHandler);
        this.handlerChain.add((Handler)this.loggingHandler);
        this.port = WebServiceClientUtil.getPort(clazz2, clazz, (SocketFactory)sSLSocketFactory, (String)string, this.handlerChain, (boolean)true);
    }

    public Client(Class<? extends Service> clazz, Class<PortType> clazz2, SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, CertificateValidator certificateValidator, PrivateKey privateKey, String string, boolean bl, IMTOMHandler iMTOMHandler) {
        Validate.notNull(clazz, (String)"'serviceClass' cannot be null.");
        Validate.notNull(clazz2, (String)"'portClass' cannot be null.");
        Validate.notNull((Object)sSLSocketFactory, (String)"'sslSocketFactory' cannot be null.");
        Validate.notNull((Object)x509Certificate, (String)"'x509Certificate' cannot be null.");
        Validate.notNull((Object)certificateValidator, (String)"'certificateVerifier' cannot be null.");
        Validate.notNull((Object)privateKey, (String)"'privateKey' cannot be null.");
        Validate.notEmpty((String)string, (String)"'endpointAddress' cannot be null nor empty.");
        this.loggingHandler = new LoggingHandler(bl);
        SecurityHandler securityHandler = new SecurityHandler(x509Certificate, privateKey, certificateValidator);
        IMTOMHandler iMTOMHandler2 = iMTOMHandler;
        this.handlerChain = new ArrayList<Handler>();
        this.handlerChain.add((Handler)securityHandler);
        this.handlerChain.add((Handler)iMTOMHandler2);
        this.handlerChain.add((Handler)this.loggingHandler);
        this.port = WebServiceClientUtil.getPort(clazz2, clazz, (SocketFactory)sSLSocketFactory, (String)string, this.handlerChain, (boolean)true);
        this.setMTOMEnabled();
    }

    public Client(Class<? extends Service> clazz, Class<PortType> clazz2, SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String string, boolean bl) {
        this(clazz, clazz2, sSLSocketFactory, x509Certificate, new CertificateValidator(){

            public void validate(X509Certificate x509Certificate) throws CertificateValidationException, XspException {
            }
        }, privateKey, string, bl);
    }

    public Client(Class<? extends Service> clazz, Class<PortType> clazz2, SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String string, boolean bl, IMTOMHandler iMTOMHandler) {
        this(clazz, clazz2, sSLSocketFactory, x509Certificate, new CertificateValidator(){

            public void validate(X509Certificate x509Certificate) throws CertificateValidationException, XspException {
            }
        }, privateKey, string, bl, iMTOMHandler);
    }

    public final List<Handler> getHandlerChain() {
        return this.handlerChain;
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return "";
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return "";
    }

    private BindingProvider getBindingProvider() {
        return (BindingProvider)this.port;
    }

    public final void setProperty(String string, Object object) {
        Validate.notNull((Object)string, (String)"'propertyKey' must be specified.");
        Validate.notNull((Object)object, (String)"'propertyValue' must be specified.");
        this.getBindingProvider().getRequestContext().put(string, object);
    }

    public final void setMTOMEnabled() {
        SOAPBinding sOAPBinding = (SOAPBinding)this.getBindingProvider().getBinding();
        sOAPBinding.setMTOMEnabled(true);
    }

    public final PortType getPort() {
        return this.port;
    }
}

