/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.DateParsePatterns;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateUtils {
    private static final int MIN_TIMEZONE_APPLICATION = 8;
    private static final int MIN_HALF_HOUR_APPLICATION = 10;
    private static final int MAX_PRECISION = 14;
    private static final int SMALL_TIMEZONE_PRECISION = 2;
    private static final int LARGE_TIMEZONE_PRECISION = 4;
    private static final int HALF_HOUR = 30;
    private static final int YEAR_PRECISION = 4;
    private static final int MONTH_PRECISION = 2;
    private static final int DAY_PRECISION = 2;
    private static final int HOUR_PRECISION = 2;
    private static final int MINUTE_PRECISION = 2;
    private static final int SECOND_PRECISION = 2;

    private DateUtils() {
    }

    public static Timestamp generateTimestamp() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        Timestamp timestamp = new Timestamp();
        try {
            timestamp.setCreated(DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar));
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new IllegalStateException("Unexpected exception has occurred.", datatypeConfigurationException);
        }
        return timestamp;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new IllegalStateException("Unexpected exception has occurred.", datatypeConfigurationException);
        }
    }

    public static String toUtcDate(String string) {
        String[] stringArray = string.split("[+|-]");
        if (stringArray != null && stringArray.length > 0) {
            DateParsePatterns dateParsePatterns = DateParsePatterns.findByMatchPatternLength(stringArray[0]);
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)dateParsePatterns.getPatternValue());
            LocalDateTime localDateTime = dateTimeFormatter.parseDateTime(stringArray[0]).toLocalDateTime();
            if (stringArray.length == 1) {
                return DateUtils.outputPrecision(localDateTime.toDateTime(), dateParsePatterns.getMatchPatternLength(), false);
            }
            if (stringArray.length == 2) {
                if (stringArray[0].length() <= 8) {
                    return DateUtils.outputPrecision(localDateTime.toDateTime(), dateParsePatterns.getMatchPatternLength(), false);
                }
                String string2 = null;
                string2 = string.contains("-") ? "-" : "";
                Holder holder = new Holder();
                DateTimeZone dateTimeZone = DateUtils.findTimeZonePatternByLength(string2, stringArray[1], (Holder<Boolean>)holder);
                DateTime dateTime = localDateTime.toDateTime(dateTimeZone);
                DateTime dateTime2 = dateTime.withZone(DateTimeZone.UTC);
                return DateUtils.outputPrecision(dateTime2, dateParsePatterns.getMatchPatternLength(), (Boolean)holder.value);
            }
            throw new IllegalStateException("Unexpected exception has occurred.");
        }
        throw new IllegalArgumentException("Unable to extract date/time components.");
    }

    private static DateTimeZone findTimeZonePatternByLength(String string, String string2, Holder<Boolean> holder) {
        Validate.notEmpty((String)"'operator' must be specified.");
        Validate.notEmpty((String)"'timeZone' must be specified.");
        holder.value = false;
        if (string2.length() == 2) {
            return DateTimeZone.forOffsetHours((int)Integer.parseInt(String.format("%s%s", string, string2)));
        }
        if (string2.length() == 4) {
            int n = string2.length() / 2;
            int n2 = Integer.parseInt(String.format("%s%s", string, string2.substring(0, n)));
            int n3 = Integer.parseInt(string2.substring(n, string2.length()));
            if (n3 / 30 == 1) {
                holder.value = true;
            }
            return DateTimeZone.forOffsetHoursMinutes((int)n2, (int)n3);
        }
        throw new IllegalArgumentException("'dateTime' does not match an expected pattern length.");
    }

    private static String outputPrecision(DateTime dateTime, int n, boolean bl) {
        Validate.notNull((Object)dateTime, (String)"'dateTime' must be specified.");
        Validate.notNull((Object)n, (String)"''precision' must be specified.");
        Validate.notNull((Object)n, (String)"''halfHour' must be specified.");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.leftPad((String)String.valueOf(dateTime.getYear()), (int)4, (String)"0"));
        stringBuilder.append(StringUtils.leftPad((String)String.valueOf(dateTime.getMonthOfYear()), (int)2, (String)"0"));
        stringBuilder.append(StringUtils.leftPad((String)String.valueOf(dateTime.getDayOfMonth()), (int)2, (String)"0"));
        stringBuilder.append(StringUtils.leftPad((String)String.valueOf(dateTime.getHourOfDay()), (int)2, (String)"0"));
        stringBuilder.append(StringUtils.leftPad((String)String.valueOf(dateTime.getMinuteOfHour()), (int)2, (String)"0"));
        stringBuilder.append(StringUtils.leftPad((String)String.valueOf(dateTime.getSecondOfMinute()), (int)2, (String)"0"));
        if (n > 14) {
            return stringBuilder.toString().substring(0, 14);
        }
        if (n == 10 && bl) {
            return stringBuilder.toString().substring(0, n + 2);
        }
        return stringBuilder.toString().substring(0, n);
    }
}

