/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp.impl.v1;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.xsp.CertificateValidationException;
import au.gov.nehta.xsp.CertificateValidator;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.SignedContainerProfileService;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignedContainerProfileServiceImpl
implements SignedContainerProfileService {
    private final String signedPayloadXmlns;
    private final XmlSignatureProfileService xmlSigService;

    public SignedContainerProfileServiceImpl(String signedPayloadXmlns, XmlSignatureProfileService xmlSigService) {
        ArgumentUtils.checkNotNullNorBlank((String)signedPayloadXmlns, (String)"signedPayloadXmlns");
        ArgumentUtils.checkNotNull((Object)xmlSigService, (String)"xmlSigService");
        this.signedPayloadXmlns = signedPayloadXmlns;
        this.xmlSigService = xmlSigService;
    }

    @Override
    public Document create(Document payloadDoc, X500PrivateCredential credential) throws XspException {
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        return this.create(payloadDoc, Arrays.asList(credential));
    }

    @Override
    public Document create(Document payloadDoc, List<X500PrivateCredential> credentials) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)payloadDoc, (String)"payloadDoc");
        ArgumentUtils.checkNotNullNorEmpty(credentials, (String)"credentials");
        Document containerDoc = null;
        try {
            containerDoc = DomUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XspException("Couldn't create signed payload container XML document.", e);
        }
        Element signedPayloadElem = containerDoc.createElementNS(this.signedPayloadXmlns, "sp:signedPayload");
        containerDoc.appendChild(signedPayloadElem);
        Element signaturesElem = containerDoc.createElementNS(this.signedPayloadXmlns, "sp:signatures");
        signedPayloadElem.appendChild(signaturesElem);
        Element signedPayloadDataElem = containerDoc.createElementNS(this.signedPayloadXmlns, "sp:signedPayloadData");
        Node payloadNode = containerDoc.importNode(payloadDoc.getDocumentElement(), true);
        signedPayloadDataElem.appendChild(payloadNode);
        signedPayloadElem.appendChild(signedPayloadDataElem);
        String referenceId = "_" + UUID.randomUUID().toString();
        signedPayloadDataElem.setAttribute("id", referenceId);
        signedPayloadDataElem.setIdAttribute("id", true);
        this.xmlSigService.sign(signaturesElem, signedPayloadDataElem, credentials);
        return containerDoc;
    }

    @Override
    public void check(Document containerDoc, CertificateValidator certificateValidator) throws SignatureValidationException, CertificateValidationException, XspException {
        DomUtils.checkNotNullOrEmpty((Document)containerDoc, (String)"containerDoc");
        DomUtils.checkElement((Element)containerDoc.getDocumentElement(), (String)"signedPayload", (String)this.signedPayloadXmlns);
        ArgumentUtils.checkNotNull((Object)certificateValidator, (String)"certificateValidator");
        Element signaturesElem = DomUtils.getChildElement((Element)containerDoc.getDocumentElement(), (String)this.signedPayloadXmlns, (String)"signatures");
        if (signaturesElem == null) {
            String errMsg = "No 'signatures' element was found within the 'signedPayload' element.";
            throw new XspException(errMsg);
        }
        List dsSignatureElems = DomUtils.getChildElements((Element)signaturesElem, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        if (dsSignatureElems.isEmpty()) {
            String errMsg = "No XML Signature elements were found within the 'signatures' element.";
            throw new XspException(errMsg);
        }
        this.xmlSigService.check(dsSignatureElems, certificateValidator);
    }

    @Override
    public Document getData(Document containerDoc) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)containerDoc, (String)"containerDoc");
        DomUtils.checkElement((Element)containerDoc.getDocumentElement(), (String)"signedPayload", (String)this.signedPayloadXmlns);
        Element signedPayloadDataElem = DomUtils.getChildElement((Element)containerDoc.getDocumentElement(), (String)this.signedPayloadXmlns, (String)"signedPayloadData");
        if (signedPayloadDataElem == null) {
            String errMsg = "No 'signedPayloadData' element was found within the 'signedPayload' element.";
            throw new XspException(errMsg);
        }
        Element payloadElem = DomUtils.getFirstChildElement((Node)signedPayloadDataElem);
        if (payloadElem == null) {
            String errMsg = "No payload element was found within the 'signedPayloadData' element.";
            throw new XspException(errMsg);
        }
        try {
            return DomUtils.newDocument((Node)payloadElem);
        }
        catch (ParserConfigurationException ex) {
            throw new XspException("Couldn't create a new document containing the payload.", ex);
        }
    }

    @Override
    public List<X509Certificate> getSigningCertificates(Document containerDoc) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)containerDoc, (String)"containerDoc");
        DomUtils.checkElement((Element)containerDoc.getDocumentElement(), (String)"signedPayload", (String)this.signedPayloadXmlns);
        Element signaturesElem = DomUtils.getChildElement((Element)containerDoc.getDocumentElement(), (String)this.signedPayloadXmlns, (String)"signatures");
        if (signaturesElem == null) {
            String errMsg = "No 'signatures' element was found within the 'signedPayload' element.";
            throw new XspException(errMsg);
        }
        List dsSignatureElems = DomUtils.getChildElements((Element)signaturesElem, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        if (dsSignatureElems.isEmpty()) {
            String errMsg = "No XML Signature elements were found within the 'signatures' element.";
            throw new XspException(errMsg);
        }
        ArrayList<X509Certificate> signingCertificates = new ArrayList<X509Certificate>();
        for (Element dsSignatureElem : dsSignatureElems) {
            signingCertificates.add(this.xmlSigService.getSigningCertificate(dsSignatureElem));
        }
        return signingCertificates;
    }

    @Override
    public List<byte[]> getDigestValues(Document containerDoc) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)containerDoc, (String)"containerDoc");
        DomUtils.checkElement((Element)containerDoc.getDocumentElement(), (String)"signedPayload", (String)this.signedPayloadXmlns);
        Element signaturesElem = DomUtils.getChildElement((Element)containerDoc.getDocumentElement(), (String)this.signedPayloadXmlns, (String)"signatures");
        if (signaturesElem == null) {
            String errMsg = "No 'signatures' element was found within the 'signedPayload' element.";
            throw new XspException(errMsg);
        }
        List dsSignatureElems = DomUtils.getChildElements((Element)signaturesElem, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        if (dsSignatureElems.isEmpty()) {
            String errMsg = "No XML Signature elements were found within the 'signatures' element.";
            throw new XspException(errMsg);
        }
        ArrayList<byte[]> digestValues = new ArrayList<byte[]>();
        for (Element dsSignatureElem : dsSignatureElems) {
            Map<String, byte[]> dvMap = this.xmlSigService.getDigestValues(dsSignatureElem);
            if (dvMap.size() > 1) {
                String errMsg = "There were multiple references in a signature.";
                throw new XspException(errMsg);
            }
            digestValues.add(dvMap.values().iterator().next());
        }
        return digestValues;
    }
}

