/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.constant;

public enum DateParsePatterns {
    YEAR("yyyy", "yyyy"),
    YEAR_MONTH("yyyyMM", "yyyyMM"),
    YEAR_MONTH_DAY("yyyyMMdd", "yyyyMMdd"),
    YEAR_MONTH_DAY_HOUR("yyyyMMddHH", "yyyyMMddHH"),
    YEAR_MONTH_DAY_HOUR_MINUTE("yyyyMMddHHmm", "yyyyMMddHHmm"),
    YEAR_MONTH_DAY_HOUR_MINUTE_SECOND("yyyyMMddHHmmss", "yyyyMMddHHmmss"),
    YEAR_MONTH_DAY_HOUR_MINUTE_SECOND_MILLISECOND("yyyyMMddHHmmss.SSSS", "yyyyMMddHHmmss'.'SSSS");

    private final String matchPattern;
    private final String patternValue;

    private DateParsePatterns(String string2, String string3) {
        this.matchPattern = string2;
        this.patternValue = string3;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public String getPatternValue() {
        return this.patternValue;
    }

    public int getMatchPatternLength() {
        return this.matchPattern.length();
    }

    public int getPatternValueLength() {
        return this.patternValue.length();
    }

    public static DateParsePatterns findByMatchPatternLength(String string) {
        for (DateParsePatterns dateParsePatterns : DateParsePatterns.values()) {
            if (dateParsePatterns.getMatchPatternLength() != string.length()) continue;
            return dateParsePatterns;
        }
        throw new IllegalArgumentException(String.format("'matchPattern' - %s does not match an expected match pattern length.", string.length()));
    }

    public static DateParsePatterns findByPatternValueLength(String string) {
        for (DateParsePatterns dateParsePatterns : DateParsePatterns.values()) {
            if (dateParsePatterns.getPatternValueLength() != string.length()) continue;
            return dateParsePatterns;
        }
        throw new IllegalArgumentException(String.format("'patternValue' - %s does not match an expected pattern value length.", string.length()));
    }

    public static DateParsePatterns findByMatchPattern(String string) {
        for (DateParsePatterns dateParsePatterns : DateParsePatterns.values()) {
            if (dateParsePatterns.getMatchPattern().compareTo(string) != 0) continue;
            return dateParsePatterns;
        }
        throw new IllegalArgumentException(String.format("'matchPattern' - %s does not match an expected match pattern.", string));
    }

    public static DateParsePatterns findByPatternValue(String string) {
        for (DateParsePatterns dateParsePatterns : DateParsePatterns.values()) {
            if (dateParsePatterns.getPatternValue().compareTo(string) != 0) continue;
            return dateParsePatterns;
        }
        throw new IllegalArgumentException(String.format("'patternValue' - %s does not match an expected pattern value.", string));
    }
}

