/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.util.ArrayList;
import java.util.Arrays;

public final class HD {
    private static final int HD_COMPONENT_COUNT = 3;
    private final String namespace;
    private final String identifier;
    private final String identifierType;

    private HD(Builder builder) {
        this.namespace = builder.namespace;
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public static HD parse(String string) {
        ArgumentUtils.checkNotNull((Object)string, (String)"parseValue");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split("\\&")));
        while (arrayList.size() < 3) {
            arrayList.add("");
        }
        if (arrayList.size() == 3) {
            return new Builder().namespace((String)arrayList.get(0)).identifier((String)arrayList.get(1)).identifierType((String)arrayList.get(2)).build();
        }
        throw new IllegalArgumentException("Unable to parse HD - Invalid number of value components:\n\tActual: " + arrayList.size() + "\n\tExpected: " + 3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.namespace);
        stringBuilder.append("&");
        stringBuilder.append(this.identifier);
        stringBuilder.append("&");
        stringBuilder.append(this.identifierType);
        return stringBuilder.toString().replaceAll(String.format("\\%s*$", "&"), "");
    }

    public static final class Builder {
        private String namespace = "";
        private String identifier = "";
        private String identifierType = "";

        public Builder namespace(String string) {
            this.namespace = string;
            return this;
        }

        public Builder identifier(String string) {
            this.identifier = string;
            return this;
        }

        public Builder identifierType(String string) {
            this.identifierType = string;
            return this;
        }

        public HD build() {
            return new HD(this);
        }
    }
}

