/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncReadTask;
import com.sun.enterprise.web.connector.grizzly.ConcurrentQueue;
import com.sun.enterprise.web.connector.grizzly.DefaultProcessorTask;
import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.FileCache;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.KeepAlivePipeline;
import com.sun.enterprise.web.connector.grizzly.KeepAliveStats;
import com.sun.enterprise.web.connector.grizzly.LinkedListPipeline;
import com.sun.enterprise.web.connector.grizzly.Management;
import com.sun.enterprise.web.connector.grizzly.MultiSelectorThread;
import com.sun.enterprise.web.connector.grizzly.OutputWriter;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import com.sun.enterprise.web.connector.grizzly.SelectorReadThread;
import com.sun.enterprise.web.connector.grizzly.SelectorThreadConfig;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.algorithms.NoParsingAlgorithm;
import com.sun.enterprise.web.connector.grizzly.async.DefaultAsyncHandler;
import com.sun.enterprise.web.connector.grizzly.comet.CometAsyncFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.RequestGroupInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThread
extends Thread
implements MBeanRegistration {
    public static final String SERVER_NAME = System.getProperty("product.name") != null ? System.getProperty("product.name") : "grizzly";
    private final Object[] lock = new Object[0];
    protected int serverTimeout = 0;
    protected InetAddress inet;
    protected int port;
    protected ServerSocket serverSocket;
    protected ServerSocketChannel serverSocketChannel;
    protected boolean initialized = false;
    protected volatile boolean running = false;
    protected String domain;
    protected ObjectName oname;
    protected ObjectName globalRequestProcessorName;
    private ObjectName keepAliveMbeanName;
    private ObjectName pwcConnectionQueueMbeanName;
    private ObjectName pwcFileCacheMbeanName;
    protected MBeanServer mserver;
    protected ObjectName processorWorkerThreadName;
    protected boolean tcpNoDelay = false;
    protected int linger = -1;
    protected int socketTimeout = -1;
    protected boolean socketKeepAlive;
    protected int maxKeepAliveRequests = 256;
    protected boolean oOBInline = false;
    protected int socketReceiveBufferSize = -1;
    protected int socketSendBufferSize = -1;
    protected String compression = "off";
    protected String noCompressionUserAgents = null;
    protected String restrictedUserAgents = null;
    protected String compressableMimeTypes = "text/html,text/xml,text/plain";
    private volatile String[] parsedCompressableMimeTypes = null;
    private volatile int parsedComressableMimeTypesHash = -1;
    protected int compressionMinSize = 2048;
    private boolean reuseAddress = true;
    protected boolean bufferResponse = false;
    protected int maxHttpHeaderSize = 8192;
    protected int minReadQueueLength = 10;
    protected int minProcessorQueueLength = 10;
    protected int maxPostSize = 0x200000;
    private int transactionTimeout = 300000;
    protected Selector selector;
    protected Adapter adapter = null;
    protected Pipeline readPipeline;
    protected Pipeline processorPipeline;
    protected PipelineStatistic pipelineStat;
    protected String pipelineClassName = LinkedListPipeline.class.getName();
    protected int maxProcessorWorkerThreads = 5;
    protected int maxReadWorkerThreads = -1;
    protected int minWorkerThreads = 5;
    protected int maxSelectors = -1;
    protected int minSpareThreads = 2;
    protected int threadsIncrement = 1;
    protected int threadsTimeout = 30;
    protected boolean useDirectByteBuffer = false;
    protected RequestGroupInfo globalRequestProcessor = new RequestGroupInfo();
    private KeepAliveStats keepAliveStats = new KeepAliveStats();
    protected boolean displayConfiguration = false;
    protected boolean isMonitoringEnabled = false;
    protected int currentConnectionNumber;
    protected volatile boolean isWaiting = false;
    protected int requestBufferSize = 8192;
    protected boolean useByteBufferView = false;
    protected int keepAliveTimeoutInSeconds = 30;
    private int kaTimeout = 30000;
    protected boolean recycleTasks = true;
    protected static int selectorTimeout = 1000;
    protected int maxQueueSizeInBytes = 4096;
    protected Class algorithmClass;
    protected String algorithmClassName = DEFAULT_ALGORITHM;
    public static final String DEFAULT_ALGORITHM = NoParsingAlgorithm.class.getName();
    protected int ssBackLog = 4096;
    private long nextKeysExpiration = 0L;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected static String rootFolder = "";
    private static final String VERSION_FILE = "/com/sun/enterprise/web/connector/grizzly/version.properties";
    private Queue<SelectionKey> keysToEnable = new ConcurrentQueue<SelectionKey>("SelectorThread.keysToEnable");
    protected Queue<ProcessorTask> processorTasks = new ConcurrentQueue<ProcessorTask>("SelectorThread.processorTasks");
    protected Queue<ReadTask> readTasks = new ConcurrentQueue<ReadTask>("SelectorThread.readTasks");
    protected Queue<ProcessorTask> activeProcessorTasks = new ConcurrentQueue<ProcessorTask>("SelectorThread.activeProcessorTasks");
    protected int multiSelectorsCount = 0;
    protected MultiSelectorThread[] readThreads;
    int curReadThread;
    protected static Logger logger = Logger.getLogger("GRIZZLY");
    protected boolean disableUploadTimeout = true;
    protected int uploadTimeout = 30000;
    protected KeepAlivePipeline keepAlivePipeline;
    protected FileCacheFactory fileCacheFactory;
    protected int secondsMaxAge = -1;
    protected int maxCacheEntries = 1024;
    protected long minEntrySize = 2048L;
    protected long maxEntrySize = 537600L;
    protected long maxLargeFileCacheSize = 0xA00000L;
    protected long maxSmallFileCacheSize = 0x100000L;
    protected boolean isFileCacheEnabled = true;
    protected boolean isLargeFileCacheEnabled = true;
    protected boolean asyncExecution = false;
    protected AsyncHandler asyncHandler;
    protected static boolean defaultAlgorithmInstalled = true;
    private Management jmxManagement = null;
    private ClassLoader classLoader;
    protected boolean enableNioLogging = false;
    private static final ConcurrentHashMap<Integer, SelectorThread> selectorThreads = new ConcurrentHashMap();
    protected Queue<SelectionKey> bannedKeys = new ConcurrentQueue<SelectionKey>("SelectorThread.bannedKeys");
    private long lastSpinTimestamp;
    private int emptySpinCounter;
    private static final int spinRateTreshold = 2000;
    static final boolean isLinux = System.getProperty("os.name").equalsIgnoreCase("linux") && !System.getProperty("java.version").startsWith("1.7");

    public static final SelectorThread getSelector(int port) {
        return selectorThreads.get(port);
    }

    public static final Enumeration<SelectorThread> getSelectors() {
        return selectorThreads.elements();
    }

    public void enableSelectionKeys() {
        int size = this.keysToEnable.size();
        long currentTime = 0L;
        if (size > 0) {
            currentTime = System.currentTimeMillis();
        }
        for (int i = 0; i < size; ++i) {
            SelectionKey selectionKey = this.keysToEnable.poll();
            if (this.asyncExecution && !this.bannedKeys.isEmpty() && this.bannedKeys.remove(selectionKey)) continue;
            if (!selectionKey.isValid()) {
                this.cancelKey(selectionKey);
                continue;
            }
            if (!this.keepAlivePipeline.trap(selectionKey)) {
                Object attachment = selectionKey.attachment();
                selectionKey.attach(-1L);
                if (this.processorPipeline.expireKey(selectionKey)) {
                    this.cancelKey(selectionKey);
                    continue;
                }
                selectionKey.attach(attachment);
            }
            selectionKey.interestOps(selectionKey.interestOps() | 1);
            if (selectionKey.attachment() != null) continue;
            selectionKey.attach(currentTime);
        }
    }

    public void addBannedSelectionKey(SelectionKey key) {
        this.bannedKeys.offer(key);
    }

    public void registerKey(SelectionKey key) {
        if (key == null) {
            return;
        }
        if (this.keepAlivePipeline.dropConnection()) {
            this.cancelKey(key);
            return;
        }
        if (defaultAlgorithmInstalled) {
            key.attach(null);
        }
        if (this.enableNioLogging) {
            logger.log(Level.INFO, "Registering SocketChannel for keep alive " + key.channel());
        }
        this.keysToEnable.add(key);
        this.selector.wakeup();
    }

    public void initEndpoint() throws IOException, InstantiationException {
        SelectorThreadConfig.configure(this);
        this.initFileCacheFactory();
        this.initAlgorithm();
        this.initPipeline();
        this.initMonitoringLevel();
        this.setName("SelectorThread-" + this.port);
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.selector = Selector.open();
            this.serverSocket = this.serverSocketChannel.socket();
            this.serverSocket.setReuseAddress(this.reuseAddress);
            if (this.inet == null) {
                this.serverSocket.bind(new InetSocketAddress(this.port), this.ssBackLog);
            } else {
                this.serverSocket.bind(new InetSocketAddress(this.inet, this.port), this.ssBackLog);
            }
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.register(this.selector, 16);
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.port);
        }
        this.serverSocket.setSoTimeout(this.serverTimeout);
        if (this.multiSelectorsCount > 1) {
            this.readThreads = new MultiSelectorThread[this.multiSelectorsCount];
            this.initMultiSelectors();
        }
        this.initProcessorTask(this.maxProcessorWorkerThreads);
        this.initReadTask(this.minReadQueueLength);
        if (this.maxSelectors == -1) {
            this.maxSelectors = this.maxProcessorWorkerThreads;
        }
        SelectorFactory.setMaxSelectors(this.maxSelectors);
        this.initialized = true;
        logger.log(Level.FINE, "Initializing Grizzly Non-Blocking Mode");
    }

    protected Pipeline newPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        Class<?> className = null;
        Pipeline pipeline = null;
        try {
            className = this.classLoader == null ? Class.forName(this.pipelineClassName) : this.classLoader.loadClass(this.pipelineClassName);
            pipeline = (Pipeline)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Unable to load Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        catch (InstantiationException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.WARNING, "Unable to instantiate Pipeline: " + this.pipelineClassName);
            pipeline = new LinkedListPipeline();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "http-listener " + port + " uses pipeline: " + pipeline.getClass().getName());
        }
        pipeline.setMaxThreads(maxThreads);
        pipeline.setMinThreads(minThreads);
        pipeline.setName(name);
        pipeline.setPort(port);
        pipeline.setPriority(priority);
        pipeline.setQueueSizeInBytes(this.maxQueueSizeInBytes);
        pipeline.setThreadsIncrement(this.threadsIncrement);
        pipeline.setThreadsTimeout(this.threadsTimeout);
        return pipeline;
    }

    protected void initFileCacheFactory() {
        if (this.asyncExecution) {
            this.isFileCacheEnabled = false;
            this.isLargeFileCacheEnabled = false;
        }
        this.fileCacheFactory = FileCacheFactory.getFactory(this.port);
        FileCacheFactory.setIsEnabled(this.isFileCacheEnabled);
        this.fileCacheFactory.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCacheFactory.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCacheFactory.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCacheFactory.setMinEntrySize(this.minEntrySize);
        this.fileCacheFactory.setMaxEntrySize(this.maxEntrySize);
        this.fileCacheFactory.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCacheFactory.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
        this.fileCacheFactory.setHeaderBBSize(this.requestBufferSize);
    }

    protected void enablePipelineStats() {
        this.pipelineStat.start();
        this.processorPipeline.setPipelineStatistic(this.pipelineStat);
        this.pipelineStat.setProcessorPipeline(this.processorPipeline);
        if (this.keepAlivePipeline != null) {
            this.keepAlivePipeline.setKeepAliveStats(this.keepAliveStats);
        }
    }

    protected void disablePipelineStats() {
        this.pipelineStat.stop();
        this.processorPipeline.setPipelineStatistic(null);
        this.pipelineStat.setProcessorPipeline(null);
        if (this.keepAlivePipeline != null) {
            this.keepAlivePipeline.setKeepAliveStats(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAlgorithm() {
        try {
            try {
                this.algorithmClass = this.classLoader == null ? Class.forName(this.algorithmClassName) : this.classLoader.loadClass(this.algorithmClassName);
                logger.log(Level.FINE, "Using Algorithm: " + this.algorithmClassName);
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.FINE, "Unable to load Algorithm: " + this.algorithmClassName);
                Object var3_2 = null;
                if (this.algorithmClass == null) {
                    this.algorithmClass = NoParsingAlgorithm.class;
                }
            }
            Object var3_1 = null;
            if (this.algorithmClass == null) {
                this.algorithmClass = NoParsingAlgorithm.class;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.algorithmClass == null) {
                this.algorithmClass = NoParsingAlgorithm.class;
            }
            throw throwable;
        }
        defaultAlgorithmInstalled = this.algorithmClassName.equals(DEFAULT_ALGORITHM);
    }

    protected void initKeepAlivePipeline() {
        this.keepAlivePipeline = new KeepAlivePipeline();
        this.keepAlivePipeline.setMaxKeepAliveRequests(this.maxKeepAliveRequests);
        this.keepAlivePipeline.setKeepAliveTimeoutInSeconds(this.keepAliveTimeoutInSeconds);
        this.keepAlivePipeline.setPort(this.port);
        this.keepAlivePipeline.setThreadsTimeout(this.threadsTimeout);
        this.keepAliveStats.setMaxConnections(this.maxKeepAliveRequests);
        this.keepAliveStats.setSecondsTimeouts(this.keepAliveTimeoutInSeconds);
    }

    protected void initPipeline() {
        selectorThreads.put(this.port, this);
        this.initKeepAlivePipeline();
        this.processorPipeline = this.newPipeline(this.maxProcessorWorkerThreads, this.minWorkerThreads, "http", this.port, 10);
        this.processorPipeline.initPipeline();
        if (this.maxReadWorkerThreads == 0) {
            this.maxReadWorkerThreads = -1;
            logger.log(Level.WARNING, "http-listener " + this.port + " is security-enabled and needs at least 2 threads");
        }
        if (this.maxReadWorkerThreads > 0 && !this.asyncExecution) {
            this.readPipeline = this.newPipeline(this.maxReadWorkerThreads, this.minWorkerThreads, "read", this.port, 5);
            this.readPipeline.initPipeline();
        } else {
            this.readPipeline = this.maxReadWorkerThreads == 0 ? null : this.processorPipeline;
        }
    }

    protected void initReadTask(int size) {
        for (int i = 0; i < size; ++i) {
            ReadTask task = this.newReadTask();
            this.readTasks.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected ReadTask newReadTask() {
        block17: {
            streamAlgorithm = null;
            try {
                try {
                    streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
                }
                catch (InstantiationException ex) {
                    SelectorThread.logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClassName);
                    var4_3 = null;
                    if (streamAlgorithm == null) {
                        streamAlgorithm = new NoParsingAlgorithm();
                    }
                    break block17;
                }
                catch (IllegalAccessException ex) {
                    SelectorThread.logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClassName);
                    var4_4 = null;
                    if (streamAlgorithm == null) {
                        streamAlgorithm = new NoParsingAlgorithm();
                    }
                }
                var4_2 = null;
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
            }
            catch (Throwable var3_9) {
                var4_5 = null;
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
                throw var3_9;
            }
        }
        streamAlgorithm.setPort(this.port);
        task = null;
        if (!SelectorThread.defaultAlgorithmInstalled) {
            try {
                try {
                    task = (ReadTask)streamAlgorithm.getReadTask(this).newInstance();
                }
                catch (InstantiationException ex) {
                    SelectorThread.logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClassName);
                    var6_13 = null;
                    if (task != null) ** GOTO lbl63
                    task = new DefaultReadTask();
                }
                catch (IllegalAccessException ex) {
                    SelectorThread.logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClassName);
                    var6_14 = null;
                    if (task != null) ** GOTO lbl63
                    task = new DefaultReadTask();
                }
                var6_12 = null;
                if (task != null) ** GOTO lbl63
                task = new DefaultReadTask();
            }
            catch (Throwable var5_16) {
                var6_15 = null;
                if (task == null) {
                    task = new DefaultReadTask();
                }
                throw var5_16;
            }
        } else {
            task = this.maxReadWorkerThreads > 0 || this.asyncExecution != false ? new AsyncReadTask() : new DefaultReadTask();
        }
lbl63:
        // 7 sources

        task.setSelectorThread(this);
        task.setPipeline(this.readPipeline);
        task.setRecycle(this.recycleTasks);
        task.initialize(streamAlgorithm, this.useDirectByteBuffer, this.useByteBufferView);
        return task;
    }

    protected void initMultiSelectors() throws IOException, InstantiationException {
        for (int i = 0; i < this.readThreads.length; ++i) {
            this.readThreads[i] = new SelectorReadThread();
            SelectorReadThread cfr_ignored_0 = (SelectorReadThread)this.readThreads[i];
            SelectorReadThread.countName = i;
            this.configureReadThread((SelectorReadThread)this.readThreads[i]);
        }
        this.curReadThread = 0;
    }

    protected void configureReadThread(SelectorThread multiSelector) throws IOException, InstantiationException {
        multiSelector.setMaxThreads(this.maxProcessorWorkerThreads);
        multiSelector.setBufferSize(this.requestBufferSize);
        multiSelector.setMaxKeepAliveRequests(this.maxKeepAliveRequests);
        multiSelector.setKeepAliveTimeoutInSeconds(this.keepAliveTimeoutInSeconds);
        multiSelector.maxQueueSizeInBytes = this.maxQueueSizeInBytes;
        multiSelector.fileCacheFactory = this.fileCacheFactory;
        multiSelector.maxReadWorkerThreads = this.maxReadWorkerThreads;
        multiSelector.defaultResponseType = this.defaultResponseType;
        multiSelector.forcedRequestType = this.forcedRequestType;
        multiSelector.minReadQueueLength = this.minReadQueueLength;
        multiSelector.maxHttpHeaderSize = this.maxHttpHeaderSize;
        multiSelector.isMonitoringEnabled = this.isMonitoringEnabled();
        multiSelector.pipelineStat = this.pipelineStat;
        multiSelector.globalRequestProcessor = this.globalRequestProcessor;
        if (this.asyncExecution) {
            multiSelector.asyncExecution = this.asyncExecution;
            multiSelector.asyncHandler = this.asyncHandler;
        }
        multiSelector.threadsIncrement = this.threadsIncrement;
        multiSelector.setPort(this.port);
        multiSelector.setAdapter(this.adapter);
        multiSelector.processorPipeline = this.processorPipeline;
        multiSelector.readPipeline = this.readPipeline;
        multiSelector.readTasks = this.readTasks;
        multiSelector.processorTasks = this.processorTasks;
        multiSelector.keepAlivePipeline = this.keepAlivePipeline;
        multiSelector.domain = this.domain;
        multiSelector.bufferResponse = this.bufferResponse;
        multiSelector.initEndpoint();
        multiSelector.start();
    }

    private synchronized MultiSelectorThread getSelectorReadThread() {
        if (this.curReadThread == this.readThreads.length) {
            this.curReadThread = 0;
        }
        return this.readThreads[this.curReadThread++];
    }

    protected void initProcessorTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.processorTasks.offer(this.newProcessorTask(false));
        }
    }

    protected void rampUpProcessorTask() {
        Iterator iterator = this.processorTasks.iterator();
        while (iterator.hasNext()) {
            ((ProcessorTask)iterator.next()).initialize();
        }
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        DefaultProcessorTask task = new DefaultProcessorTask(initialize, this.bufferResponse);
        return this.configureProcessorTask(task);
    }

    protected ProcessorTask configureProcessorTask(DefaultProcessorTask task) {
        task.setAdapter(this.adapter);
        task.setMaxHttpHeaderSize(this.maxHttpHeaderSize);
        task.setBufferSize(this.requestBufferSize);
        task.setSelectorThread(this);
        task.setRecycle(this.recycleTasks);
        task.setDefaultResponseType(this.defaultResponseType);
        task.setForcedRequestType(this.forcedRequestType);
        task.setMaxPostSize(this.maxPostSize);
        task.setTimeout(this.uploadTimeout);
        task.setDisableUploadTimeout(this.disableUploadTimeout);
        if (this.keepAlivePipeline.dropConnection()) {
            task.setDropConnection(true);
        }
        if (this.asyncExecution) {
            task.setEnableAsyncExecution(this.asyncExecution);
            task.setAsyncHandler(this.asyncHandler);
        }
        task.setPipeline(this.processorPipeline);
        this.configureCompression(task);
        return task;
    }

    protected void reconfigureAsyncExecution() {
        for (ProcessorTask task : this.processorTasks) {
            if (!(task instanceof DefaultProcessorTask)) continue;
            ((DefaultProcessorTask)task).setEnableAsyncExecution(this.asyncExecution);
            ((DefaultProcessorTask)task).setAsyncHandler(this.asyncHandler);
        }
        this.readTasks.clear();
        this.initReadTask(this.minReadQueueLength);
    }

    public ProcessorTask getProcessorTask() {
        ProcessorTask processorTask = null;
        if (this.recycleTasks) {
            processorTask = this.processorTasks.poll();
        }
        if (processorTask == null) {
            processorTask = this.newProcessorTask(false);
        }
        if (this.isMonitoringEnabled()) {
            this.activeProcessorTasks.offer(processorTask);
        }
        return processorTask;
    }

    public ReadTask getReadTask(SelectionKey key) throws IOException {
        ReadTask task = null;
        if (this.recycleTasks) {
            task = this.readTasks.poll();
        }
        if (task == null) {
            task = this.newReadTask();
        }
        task.setSelectionKey(key);
        return task;
    }

    @Override
    public void run() {
        try {
            this.startEndpoint();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "selectorThread.errorOnRequest", ex);
        }
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.running = true;
        this.kaTimeout = this.keepAliveTimeoutInSeconds * 1000;
        this.rampUpProcessorTask();
        this.registerComponents();
        this.displayConfiguration();
        this.startPipelines();
        this.startListener();
    }

    protected void startPipelines() {
        if (this.readPipeline != null) {
            this.readPipeline.startPipeline();
        }
        this.processorPipeline.startPipeline();
    }

    protected void stopPipelines() {
        if (this.keepAlivePipeline != null) {
            this.keepAlivePipeline.stopPipeline();
        }
        if (this.readPipeline != null) {
            this.readPipeline.stopPipeline();
        }
        this.processorPipeline.stopPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startListener() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            while (this.running && this.selector.isOpen()) {
                this.doSelect();
            }
            try {
                this.closeActiveConnections();
                this.stopPipelines();
                this.stopSelectorReadThread();
                try {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "selectorThread.closeSocketException", ex);
                }
                try {
                    if (this.serverSocketChannel != null) {
                        this.serverSocketChannel.close();
                    }
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "selectorThread.closeSocketException", ex);
                }
                try {
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "selectorThread.closeSocketException", ex);
                }
                this.unregisterComponents();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "selectorThread.stopException", t);
            }
            return;
        }
    }

    public void resetSpinCounter() {
        this.emptySpinCounter = 0;
    }

    public int getSpinRate() {
        if (this.emptySpinCounter++ == 0) {
            this.lastSpinTimestamp = System.nanoTime();
        } else if (this.emptySpinCounter == 1000) {
            long deltatime = System.nanoTime() - this.lastSpinTimestamp;
            int contspinspersec = (int)(1000000000000L / deltatime);
            this.emptySpinCounter = 0;
            return contspinspersec;
        }
        return 0;
    }

    private void workaroundSelectorSpin() throws IOException {
        Selector newSelector = Selector.open();
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            try {
                key.channel().register(newSelector, key.interestOps(), key.attachment());
            }
            catch (Exception e) {}
        }
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selector = newSelector;
    }

    protected void doSelect() {
        block14: {
            SelectionKey key = null;
            try {
                long sr;
                int selectorState = 0;
                this.enableSelectionKeys();
                try {
                    selectorState = this.selector.select(selectorTimeout);
                }
                catch (CancelledKeyException ex) {
                    // empty catch block
                }
                if (!this.running) {
                    return;
                }
                Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                if (readyKeys.size() != 0 && isLinux) {
                    this.resetSpinCounter();
                } else if (isLinux && (sr = (long)this.getSpinRate()) > 2000L) {
                    this.workaroundSelectorSpin();
                }
                Iterator<SelectionKey> iterator = readyKeys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    iterator.remove();
                    if (key.isValid()) {
                        this.handleConnection(key);
                        continue;
                    }
                    this.cancelKey(key);
                }
                this.expireIdleKeys();
                if (selectorState <= 0) {
                    this.selector.selectedKeys().clear();
                    return;
                }
            }
            catch (Throwable t) {
                String msg = t.getMessage();
                if (msg != null && msg.equals("Too many open files")) {
                    logger.log(Level.SEVERE, "Running out of operating systems file descriptors. Cannot serve requests anymore.", t);
                }
                if (key != null && key.isValid()) {
                    logger.log(Level.SEVERE, "selectorThread.errorOnRequest", t);
                } else {
                    logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
                }
                if (key == null) break block14;
                key.attach(null);
                key.cancel();
            }
        }
    }

    protected void expireIdleKeys() {
        if (this.keepAliveTimeoutInSeconds <= 0 || !this.selector.isOpen()) {
            return;
        }
        long current = System.currentTimeMillis();
        if (current < this.nextKeysExpiration) {
            return;
        }
        this.nextKeysExpiration = current + (long)this.kaTimeout;
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> iterator = readyKeys.iterator();
        while (this.running && iterator.hasNext()) {
            SelectionKey key = iterator.next();
            Object attachment = key.attachment();
            if (attachment == null || !defaultAlgorithmInstalled && !(attachment instanceof Long)) continue;
            try {
                long expire = (Long)attachment;
                if (current - expire >= (long)this.kaTimeout) {
                    if (this.enableNioLogging) {
                        logger.log(Level.INFO, "Keep-Alive expired for SocketChannel " + key.channel());
                    }
                    this.cancelKey(key);
                    this.keepAliveStats.incrementCountTimeouts();
                    continue;
                }
                if (expire + (long)this.kaTimeout >= this.nextKeysExpiration) continue;
                this.nextKeysExpiration = expire + (long)this.kaTimeout;
            }
            catch (ClassCastException ex) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, "Invalid SelectionKey attachment", ex);
            }
        }
    }

    protected void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        ReadTask task = null;
        if ((key.readyOps() & 0x10) == 16) {
            this.handleAccept(key);
            return;
        }
        if ((key.readyOps() & 1) == 1) {
            task = this.handleRead(key);
        }
        if (((SocketChannel)key.channel()).isOpen()) {
            task.execute();
        } else {
            this.cancelKey(key);
        }
    }

    protected void handleAccept(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        if (this.enableNioLogging) {
            logger.log(Level.INFO, "Handling OP_ACCEPT on SocketChannel " + channel);
        }
        if (channel != null) {
            SelectionKey readKey = null;
            try {
                if (this.multiSelectorsCount > 1) {
                    MultiSelectorThread srt = this.getSelectorReadThread();
                    srt.addChannel(channel);
                } else {
                    channel.configureBlocking(false);
                    readKey = channel.register(this.selector, 1);
                    if (!channel.isOpen()) {
                        this.cancelKey(readKey);
                        return;
                    }
                    this.setSocketOptions(((SocketChannel)readKey.channel()).socket());
                    readKey.attach(System.currentTimeMillis());
                }
                if (this.isMonitoringEnabled()) {
                    this.pipelineStat.incrementOpenConnectionsCount(channel);
                    this.getRequestGroupInfo().increaseCountOpenConnections();
                    this.pipelineStat.incrementTotalAcceptCount();
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, "selectorThread.errorOnRequest", e);
                try {
                    if (readKey != null) {
                        this.cancelKey(key);
                    } else {
                        channel.close();
                    }
                }
                catch (IOException ee) {
                    logger.log(Level.FINE, "selectorThread.errorOnRequest", ee);
                }
            }
        }
    }

    protected ReadTask handleRead(SelectionKey key) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        if (this.enableNioLogging) {
            logger.log(Level.INFO, "Handling OP_READ on SocketChannel " + key.channel());
        }
        Object attach = key.attachment();
        if (!defaultAlgorithmInstalled && key.isValid() && attach != null && attach instanceof ReadTask) {
            key.attach(null);
            return (ReadTask)attach;
        }
        return this.getReadTask(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void cancelKey(SelectionKey key) {
        block26: {
            block23: {
                if (key == null) {
                    return;
                }
                this.keepAlivePipeline.untrap(key);
                if (!this.processorPipeline.expireKey(key)) {
                    return;
                }
                if (this.enableNioLogging) {
                    logger.log(Level.INFO, "Closing SocketChannel " + key.channel());
                }
                Socket socket = ((SocketChannel)key.channel()).socket();
                try {
                    if (!socket.isInputShutdown()) {
                        socket.shutdownInput();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    if (!socket.isOutputShutdown()) {
                        socket.shutdownOutput();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (socket.isClosed()) break block23;
                socket.close();
            }
            Object var5_6 = null;
            try {
                if (key.channel().isOpen()) {
                    key.channel().close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
            }
            if (this.isMonitoringEnabled() && this.pipelineStat.decrementOpenConnectionsCount(key.channel())) {
                this.getRequestGroupInfo().decreaseCountOpenConnections();
            }
            break block26;
            {
                catch (IOException iOException) {
                    Object var5_7 = null;
                    try {
                        if (key.channel().isOpen()) {
                            key.channel().close();
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
                    }
                    if (this.isMonitoringEnabled() && this.pipelineStat.decrementOpenConnectionsCount(key.channel())) {
                        this.getRequestGroupInfo().decreaseCountOpenConnections();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (key.channel().isOpen()) {
                        key.channel().close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
                }
                if (this.isMonitoringEnabled() && this.pipelineStat.decrementOpenConnectionsCount(key.channel())) {
                    this.getRequestGroupInfo().decreaseCountOpenConnections();
                }
                throw throwable;
            }
        }
        key.attach(null);
        key.cancel();
        key = null;
    }

    public void returnTask(Task task) {
        if (task != null) {
            if (task.getType() == 2) {
                if (this.isMonitoringEnabled()) {
                    this.activeProcessorTasks.remove((DefaultProcessorTask)task);
                }
                this.processorTasks.offer((DefaultProcessorTask)task);
            } else if (task.getType() == 1) {
                this.readTasks.offer((ReadTask)task);
            }
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    protected void clearTasks() {
        this.processorTasks.clear();
        this.readTasks.clear();
    }

    public boolean cancelThreadExecution(long cancelThreadID) {
        if (this.multiSelectorsCount > 1) {
            boolean cancelled = false;
            for (MultiSelectorThread readSelector : this.readThreads) {
                cancelled = ((SelectorReadThread)readSelector).cancelThreadExecution(cancelThreadID);
                if (!cancelled) continue;
                return true;
            }
            return false;
        }
        if (this.activeProcessorTasks.size() == 0) {
            return false;
        }
        for (ProcessorTask processorTask : this.activeProcessorTasks) {
            long threadID = processorTask.getWorkerThreadID();
            if (threadID != cancelThreadID) continue;
            processorTask.cancelTask("Request cancelled.", "500");
            logger.log(Level.WARNING, "Thread Request Cancelled: " + threadID);
            return processorTask.getPipeline().interruptThread(threadID);
        }
        return false;
    }

    private void stopSelectorReadThread() {
        if (this.readThreads != null) {
            for (int i = 0; i < this.readThreads.length; ++i) {
                this.readThreads[i].stopEndpoint();
            }
        }
    }

    private void closeActiveConnections() {
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        for (SelectionKey key : readyKeys) {
            if (key.channel() instanceof SocketChannel) {
                this.cancelKey(key);
                continue;
            }
            key.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpoint() {
        if (!this.running) {
            return;
        }
        this.running = false;
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.clearTasks();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxProcessorWorkerThreads = maxThreads == 1 ? 5 : maxThreads;
    }

    public int getMaxThreads() {
        return this.maxProcessorWorkerThreads;
    }

    public void setMaxSpareThreads(int maxThreads) {
    }

    public int getMaxSpareThreads() {
        return this.maxProcessorWorkerThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortLowLevel() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getCurrentBusyProcessorThreads() {
        int busy = 0;
        if (this.multiSelectorsCount > 1) {
            for (MultiSelectorThread readSelector : this.readThreads) {
                busy += ((SelectorReadThread)readSelector).getCurrentBusyProcessorThreads();
            }
        } else {
            busy = this.processorPipeline.getCurrentThreadsBusy();
        }
        return busy;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getServerSoTimeout() {
        return this.serverTimeout;
    }

    public void setServerSoTimeout(int i) {
        this.serverTimeout = i;
    }

    public int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.kaTimeout = timeout * 1000;
        this.keepAliveStats.setSecondsTimeouts(timeout);
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.keepAlivePipeline.setMaxThreads(threadCount);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void setSocketOptions(Socket socket) {
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    if (socket.getChannel() != null && !socket.getChannel().isOpen()) {
                                        return;
                                    }
                                    try {
                                        if (this.socketKeepAlive) {
                                            socket.setKeepAlive(this.socketKeepAlive);
                                        }
                                    }
                                    catch (SocketException ex) {
                                        if (!logger.isLoggable(Level.FINE)) break block22;
                                        logger.log(Level.FINE, "setKeepAlive exception ", ex);
                                    }
                                }
                                try {
                                    if (this.linger >= 0) {
                                        socket.setSoLinger(true, this.linger);
                                    }
                                }
                                catch (SocketException ex) {
                                    if (!logger.isLoggable(Level.FINE)) break block23;
                                    logger.log(Level.FINE, "setSoLinger exception ", ex);
                                }
                            }
                            try {
                                if (this.tcpNoDelay) {
                                    socket.setTcpNoDelay(this.tcpNoDelay);
                                }
                            }
                            catch (SocketException ex) {
                                if (!logger.isLoggable(Level.FINE)) break block24;
                                logger.log(Level.FINE, "setTcpNoDelay exception ", ex);
                            }
                        }
                        try {
                            if (this.maxReadWorkerThreads != 0) {
                                socket.setReuseAddress(this.reuseAddress);
                            }
                        }
                        catch (SocketException ex) {
                            if (!logger.isLoggable(Level.FINE)) break block25;
                            logger.log(Level.FINE, "setReuseAddress exception ", ex);
                        }
                    }
                    try {
                        if (this.oOBInline) {
                            socket.setOOBInline(this.oOBInline);
                        }
                    }
                    catch (SocketException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block26;
                        logger.log(Level.FINE, "setOOBInline exception ", ex);
                    }
                }
                try {
                    if (this.socketReceiveBufferSize > -1) {
                        socket.setReceiveBufferSize(this.socketReceiveBufferSize);
                    }
                }
                catch (SocketException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block27;
                    logger.log(Level.FINE, "setReceiveBufferSize exception ", ex);
                }
            }
            try {
                if (this.socketSendBufferSize > -1) {
                    socket.setSendBufferSize(this.socketSendBufferSize);
                }
            }
            catch (SocketException ex) {
                if (!logger.isLoggable(Level.FINE)) break block28;
                logger.log(Level.FINE, "setSendBufferSize exception ", ex);
            }
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    protected void registerComponents() {
        if (this.domain != null && this.jmxManagement != null) {
            try {
                this.globalRequestProcessorName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=http" + this.port);
                this.jmxManagement.registerComponent(this.globalRequestProcessor, this.globalRequestProcessorName, null);
                this.keepAliveMbeanName = new ObjectName(this.domain + ":type=PWCKeepAlive,name=http" + this.port);
                this.jmxManagement.registerComponent(this.keepAliveStats, this.keepAliveMbeanName, null);
                this.pwcConnectionQueueMbeanName = new ObjectName(this.domain + ":type=PWCConnectionQueue,name=http" + this.port);
                this.jmxManagement.registerComponent(this.pipelineStat, this.pwcConnectionQueueMbeanName, null);
                this.pwcFileCacheMbeanName = new ObjectName(this.domain + ":type=PWCFileCache,name=http" + this.port);
                this.jmxManagement.registerComponent(this.fileCacheFactory, this.pwcFileCacheMbeanName, null);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "selectorThread.mbeanRegistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    protected void unregisterComponents() {
        if (this.domain != null && this.jmxManagement != null) {
            try {
                if (this.globalRequestProcessorName != null) {
                    this.jmxManagement.unregisterComponent(this.globalRequestProcessorName);
                }
                if (this.keepAliveMbeanName != null) {
                    this.jmxManagement.unregisterComponent(this.keepAliveMbeanName);
                }
                if (this.pwcConnectionQueueMbeanName != null) {
                    this.jmxManagement.unregisterComponent(this.pwcConnectionQueueMbeanName);
                }
                if (this.pwcFileCacheMbeanName != null) {
                    this.jmxManagement.unregisterComponent(this.pwcFileCacheMbeanName);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "mbeanDeregistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    public void enableMonitoring() {
        this.isMonitoringEnabled = true;
        this.enablePipelineStats();
        if (this.readThreads != null) {
            for (int i = 0; i < this.readThreads.length; ++i) {
                ((SelectorReadThread)this.readThreads[i]).isMonitoringEnabled = true;
            }
        }
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public void disableMonitoring() {
        this.disablePipelineStats();
        if (this.readThreads != null) {
            for (int i = 0; i < this.readThreads.length; ++i) {
                ((SelectorReadThread)this.readThreads[i]).isMonitoringEnabled = false;
            }
        }
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public RequestGroupInfo getRequestGroupInfo() {
        return this.globalRequestProcessor;
    }

    public KeepAliveStats getKeepAliveStats() {
        return this.keepAliveStats;
    }

    protected void initMonitoringLevel() {
        this.pipelineStat = new PipelineStatistic(this.port);
        this.pipelineStat.setQueueSizeInBytes(this.maxQueueSizeInBytes);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setMinThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int getCountThreadsStats() {
        int ret = this.processorPipeline.getCurrentThreadCount();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getCurrentThreadCount();
        }
        return ret;
    }

    public int getCountThreadsIdleStats() {
        int ret = this.processorPipeline.getWaitingThread();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getWaitingThread();
        }
        return ret;
    }

    public int getCurrentThreadCountStats() {
        int ret = this.processorPipeline.getCurrentThreadCount();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getCurrentThreadCount();
        }
        return ret;
    }

    public int getCurrentThreadsBusyStats() {
        int ret = this.processorPipeline.getCurrentThreadsBusy();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getCurrentThreadsBusy();
        }
        return ret;
    }

    public int getMaxSpareThreadsStats() {
        int ret = this.processorPipeline.getMaxSpareThreads();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getMaxSpareThreads();
        }
        return ret;
    }

    public int getMinSpareThreadsStats() {
        int ret = this.processorPipeline.getMinSpareThreads();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getMinSpareThreads();
        }
        return ret;
    }

    public int getMaxThreadsStats() {
        int ret = this.processorPipeline.getMaxThreads();
        if (this.readPipeline != null && this.readPipeline != this.processorPipeline) {
            ret += this.readPipeline.getMaxThreads();
        }
        return ret;
    }

    public void removeCacheEntry(String contextPath) {
        ConcurrentHashMap cachedEntries = this.fileCacheFactory.getCache();
        if (cachedEntries == null) {
            return;
        }
        for (String cachedPath : cachedEntries.keySet()) {
            if (!cachedPath.startsWith(contextPath)) continue;
            ((FileCache.FileCacheEntry)cachedEntries.remove(cachedPath)).run();
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.isFileCacheEnabled;
    }

    public void setFileCacheIsEnabled(boolean isFileCacheEnabled) {
        this.isFileCacheEnabled = isFileCacheEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        if (this.running) {
            this.reconfigureAsyncExecution();
        }
    }

    public boolean getEnableAsyncExecution() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public static void setLogger(Logger l) {
        if (l != null) {
            logger = l;
        }
    }

    public static Logger logger() {
        return logger;
    }

    public static void setWebAppRootPath(String rf) {
        rootFolder = rf;
    }

    public static String getWebAppRootPath() {
        return rootFolder;
    }

    public int getMaxReadWorkerThreads() {
        return this.maxReadWorkerThreads;
    }

    public Pipeline getReadPipeline() {
        return this.readPipeline;
    }

    protected void configureCompression(DefaultProcessorTask processorTask) {
        processorTask.setCompression(this.compression);
        processorTask.addNoCompressionUserAgent(this.noCompressionUserAgents);
        this.parseComressableMimeTypes();
        processorTask.setCompressableMimeTypes(this.parsedCompressableMimeTypes);
        processorTask.setCompressionMinSize(this.compressionMinSize);
        processorTask.addRestrictedUserAgent(this.restrictedUserAgents);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void displayConfiguration() {
        if (!this.displayConfiguration) return;
        InputStream is = this.getClass().getResourceAsStream(VERSION_FILE);
        Properties properties = new Properties();
        try {
            try {
                properties.load(is);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't read the version file", ex);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't close version file", ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new RuntimeException("Can't close version file", ex);
        }
        is.close();
        String version = properties.getProperty("version");
        logger.log(Level.INFO, "\n Grizzly " + version + " running on " + System.getProperty("os.name") + "-" + System.getProperty("os.version") + " under JDK version: " + System.getProperty("java.version") + "-" + System.getProperty("java.vendor") + "\n\t port: " + this.port + "\n\t socket-tcp-no-delay-enabled: " + this.tcpNoDelay + "\n\t socket-keep-alive-enabled: " + this.socketKeepAlive + "\n\t socket-linger: " + this.linger + "\n\t socket-oob-inline-enabled: " + this.oOBInline + "\n\t default-write-timeout-millis: " + OutputWriter.getDefaultWriteTimeout() + "\n\t maxThreads: " + this.maxProcessorWorkerThreads + "\n\t ByteBuffer size: " + this.requestBufferSize + "\n\t useDirectByteBuffer: " + this.maxHttpHeaderSize + "\n\t maxKeepAliveRequests: " + this.maxKeepAliveRequests + "\n\t keepAliveTimeoutInSeconds: " + this.keepAliveTimeoutInSeconds + "\n\t Static File Cache enabled: " + this.isFileCacheEnabled + "\n\t Pipeline : " + this.pipelineClassName + "\n\t Round Robin Selector Algorithm enabled: " + (this.multiSelectorsCount > 1) + "\n\t Round Robin Selector pool size: " + this.multiSelectorsCount + "\n\t Asynchronous Request Processing enabled: " + this.asyncExecution);
    }

    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    public void setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
    }

    public void enableCometSupport(boolean enableComet) {
        if (enableComet) {
            this.asyncExecution = true;
            this.setBufferResponse(false);
            this.isFileCacheEnabled = false;
            this.isLargeFileCacheEnabled = false;
            this.asyncHandler = new DefaultAsyncHandler();
            this.asyncHandler.addAsyncFilter(new CometAsyncFilter());
            SelectorThread.logger().log(Level.INFO, "Enabling Grizzly ARP Comet support.");
        } else {
            this.asyncExecution = false;
        }
    }

    public void enableRcmSupport(boolean rcmSupport) {
        if (rcmSupport) {
            this.pipelineClassName = "com.sun.enterprise.web.ara.IsolationPipeline";
        }
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public void setServerSocketChannel(ServerSocketChannel serverSocketChannel) {
        this.serverSocketChannel = serverSocketChannel;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ObjectName getOname() {
        return this.oname;
    }

    public void setOname(ObjectName oname) {
        this.oname = oname;
    }

    public ObjectName getGlobalRequestProcessorName() {
        return this.globalRequestProcessorName;
    }

    public void setGlobalRequestProcessorName(ObjectName globalRequestProcessorName) {
        this.globalRequestProcessorName = globalRequestProcessorName;
    }

    public ObjectName getKeepAliveMbeanName() {
        return this.keepAliveMbeanName;
    }

    public void setKeepAliveMbeanName(ObjectName keepAliveMbeanName) {
        this.keepAliveMbeanName = keepAliveMbeanName;
    }

    public ObjectName getPwcConnectionQueueMbeanName() {
        return this.pwcConnectionQueueMbeanName;
    }

    public void setPwcConnectionQueueMbeanName(ObjectName pwcConnectionQueueMbeanName) {
        this.pwcConnectionQueueMbeanName = pwcConnectionQueueMbeanName;
    }

    public ObjectName getPwcFileCacheMbeanName() {
        return this.pwcFileCacheMbeanName;
    }

    public void setPwcFileCacheMbeanName(ObjectName pwcFileCacheMbeanName) {
        this.pwcFileCacheMbeanName = pwcFileCacheMbeanName;
    }

    public MBeanServer getMserver() {
        return this.mserver;
    }

    public void setMserver(MBeanServer mserver) {
        this.mserver = mserver;
    }

    public ObjectName getProcessorWorkerThreadName() {
        return this.processorWorkerThreadName;
    }

    public void setProcessorWorkerThreadName(ObjectName processorWorkerThreadName) {
        this.processorWorkerThreadName = processorWorkerThreadName;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    public void setSocketReceiveBufferSize(int socketReceiveBufferSize) {
        this.socketReceiveBufferSize = socketReceiveBufferSize;
    }

    public int getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    public void setSocketSendBufferSize(int socketSendBufferSize) {
        this.socketSendBufferSize = socketSendBufferSize;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String getCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    private void parseComressableMimeTypes() {
        if (this.compressableMimeTypes == null) {
            this.parsedCompressableMimeTypes = new String[0];
            return;
        }
        int hash = -1;
        hash = this.compressableMimeTypes.hashCode();
        if (hash == this.parsedComressableMimeTypesHash) {
            return;
        }
        ArrayList<String> compressableMimeTypeList = new ArrayList<String>(4);
        StringTokenizer st = new StringTokenizer(this.compressableMimeTypes, ",");
        while (st.hasMoreTokens()) {
            compressableMimeTypeList.add(st.nextToken().trim());
        }
        String[] tmpParsedCompressableMimeTypes = new String[compressableMimeTypeList.size()];
        compressableMimeTypeList.toArray(tmpParsedCompressableMimeTypes);
        this.parsedCompressableMimeTypes = tmpParsedCompressableMimeTypes;
        this.parsedComressableMimeTypesHash = hash;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public boolean isBufferResponse() {
        return this.bufferResponse;
    }

    public int getMinReadQueueLength() {
        return this.minReadQueueLength;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.minReadQueueLength = minReadQueueLength;
    }

    public int getMinProcessorQueueLength() {
        return this.minProcessorQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.minProcessorQueueLength = minProcessorQueueLength;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public int getSelectorReadThreadsCount() {
        return this.multiSelectorsCount;
    }

    public void setSelectorReadThreadsCount(int multiSelectorsCount) {
        this.multiSelectorsCount = multiSelectorsCount;
    }

    public void setReadPipeline(Pipeline readPipeline) {
        this.readPipeline = readPipeline;
    }

    public Pipeline getProcessorPipeline() {
        return this.processorPipeline;
    }

    public void setProcessorPipeline(Pipeline processorPipeline) {
        this.processorPipeline = processorPipeline;
    }

    public PipelineStatistic getPipelineStat() {
        return this.pipelineStat;
    }

    public void setPipelineStat(PipelineStatistic pipelineStat) {
        this.pipelineStat = pipelineStat;
    }

    public String getPipelineClassName() {
        return this.pipelineClassName;
    }

    public void setPipelineClassName(String pipelineClassName) {
        this.pipelineClassName = pipelineClassName;
    }

    public int getMaxSelectors() {
        return this.maxSelectors;
    }

    public void setMaxSelectors(int maxSelectors) {
        this.maxSelectors = maxSelectors;
    }

    public int getMaxProcessorWorkerThreads() {
        return this.maxProcessorWorkerThreads;
    }

    public void setMaxProcessorWorkerThreads(int maxProcessorWorkerThreads) {
        this.maxProcessorWorkerThreads = maxProcessorWorkerThreads;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.maxReadWorkerThreads = maxReadWorkerThreads;
    }

    public int getMinWorkerThreads() {
        return this.minWorkerThreads;
    }

    public void setMinWorkerThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }

    public int getThreadsIncrement() {
        return this.threadsIncrement;
    }

    public void setThreadsIncrement(int threadsIncrement) {
        this.threadsIncrement = threadsIncrement;
    }

    public int getThreadsTimeout() {
        return this.threadsTimeout;
    }

    public void setThreadsTimeout(int threadsTimeout) {
        this.threadsTimeout = threadsTimeout;
    }

    public boolean isUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
    }

    public RequestGroupInfo getGlobalRequestProcessor() {
        return this.globalRequestProcessor;
    }

    public void setGlobalRequestProcessor(RequestGroupInfo globalRequestProcessor) {
        this.globalRequestProcessor = globalRequestProcessor;
    }

    public void setKeepAliveStats(KeepAliveStats keepAliveStats) {
        this.keepAliveStats = keepAliveStats;
    }

    public boolean isDisplayConfiguration() {
        return this.displayConfiguration;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    public boolean isIsMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public void setIsMonitoringEnabled(boolean isMonitoringEnabled) {
        this.isMonitoringEnabled = isMonitoringEnabled;
    }

    public int getCurrentConnectionNumber() {
        return this.currentConnectionNumber;
    }

    public void setCurrentConnectionNumber(int currentConnectionNumber) {
        this.currentConnectionNumber = currentConnectionNumber;
    }

    public void setIsWaiting(boolean isWaiting) {
        this.isWaiting = isWaiting;
    }

    public boolean isUseByteBufferView() {
        return this.useByteBufferView;
    }

    public void setUseByteBufferView(boolean useByteBufferView) {
        this.useByteBufferView = useByteBufferView;
    }

    public int getKaTimeout() {
        return this.kaTimeout;
    }

    public void setKaTimeout(int kaTimeout) {
        this.kaTimeout = kaTimeout;
    }

    public boolean isRecycleTasks() {
        return this.recycleTasks;
    }

    public void setRecycleTasks(boolean recycleTasks) {
        this.recycleTasks = recycleTasks;
    }

    public static int getSelectorTimeout() {
        return selectorTimeout;
    }

    public static void setSelectorTimeout(int aSelectorTimeout) {
        selectorTimeout = aSelectorTimeout;
    }

    public int getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setMaxQueueSizeInBytes(int maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public Class getAlgorithmClass() {
        return this.algorithmClass;
    }

    public void setAlgorithmClass(Class algorithmClass) {
        this.algorithmClass = algorithmClass;
    }

    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }

    public void setAlgorithmClassName(String algorithmClassName) {
        this.algorithmClassName = algorithmClassName;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public long getNextKeysExpiration() {
        return this.nextKeysExpiration;
    }

    public void setNextKeysExpiration(long nextKeysExpiration) {
        this.nextKeysExpiration = nextKeysExpiration;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public static String getRootFolder() {
        return rootFolder;
    }

    public static void setRootFolder(String aRootFolder) {
        rootFolder = aRootFolder;
    }

    public Queue<SelectionKey> getKeysToEnable() {
        return this.keysToEnable;
    }

    public void setKeysToEnable(Queue<SelectionKey> keysToEnable) {
        this.keysToEnable = keysToEnable;
    }

    public Queue<ProcessorTask> getProcessorTasks() {
        return this.processorTasks;
    }

    public void setProcessorTasks(Queue<ProcessorTask> processorTasks) {
        this.processorTasks = processorTasks;
    }

    public Queue<ReadTask> getReadTasks() {
        return this.readTasks;
    }

    public void setReadTasks(Queue<ReadTask> readTasks) {
        this.readTasks = readTasks;
    }

    public Queue<ProcessorTask> getActiveProcessorTasks() {
        return this.activeProcessorTasks;
    }

    public void setActiveProcessorTasks(Queue<ProcessorTask> activeProcessorTasks) {
        this.activeProcessorTasks = activeProcessorTasks;
    }

    public int getCurReadThread() {
        return this.curReadThread;
    }

    public void setCurReadThread(int curReadThread) {
        this.curReadThread = curReadThread;
    }

    public static Logger getLogger() {
        return logger;
    }

    public Management getManagement() {
        return this.jmxManagement;
    }

    public void setManagement(Management jmxManagement) {
        this.jmxManagement = jmxManagement;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isEnableNioLogging() {
        return this.enableNioLogging;
    }

    public void setEnableNioLogging(boolean enableNioLogging) {
        this.enableNioLogging = enableNioLogging;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public KeepAlivePipeline getKeepAlivePipeline() {
        return this.keepAlivePipeline;
    }

    public void setKeepAlivePipeline(KeepAlivePipeline keepAlivePipeline) {
        this.keepAlivePipeline = keepAlivePipeline;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setUploadTimeout(int uploadTimeout) {
        this.uploadTimeout = uploadTimeout;
    }

    public int getTimeout() {
        return this.uploadTimeout;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }
}

