/*
 * Copyright 2012 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

/**
 * Enumeration of Practice Setting Type codes.
 */
public enum PracticeSettingTypeCodes {

  /**
   * Acupuncture service code.
   */
  ACUPUNCTURE_SERVICE("ANZSIC", "8539-1", "Acupuncture service"),

  /**
   * Adoption service code.
   */
  ADOPTION_SERVICE("ANZSIC", "8790-1", "Adoption service"),

  /**
   * Adult day care centre operation code.
   */
  ADULT_DAY_CARE_CENTRE_OPERATION("ANZSIC", "8790-2", "Adult day care centre operation"),

  /**
   * Aerial ambulance service code.
   */
  AERIAL_AMBULANCE_SERVICE("ANZSIC", "8591-1", "Aerial ambulance service"),

  /**
   * Aged care assistance service code.
   */
  AGED_CARE_ASSISTANCE_SERVICE("ANZSIC", "8790-3", "Aged care assistance service"),

  /**
   * Alcoholics anonymous operation code.
   */
  ALCOHOLICS_ANONYMOUS_OPERATION("ANZSIC", "8790-4", "Alcoholics anonymous operation"),

  /**
   * Allergy specialist service code.
   */
  ALLERGY_SPECIALIST_SERVICE("ANZSIC", "8512-1", "Allergy specialist service"),

  /**
   * Ambulance service code.
   */
  AMBULANCE_SERVICE("ANZSIC", "8591-2", "Ambulance service"),

  /**
   * Anaesthetist service code.
   */
  ANAESTHETIST_SERVICE("ANZSIC", "8512-2", "Anaesthetist service"),

  /**
   * Application hosting code.
   */
  APPLICATION_HOSTING("ANZSIC", "5921-1", "Application hosting"),

  /**
   * Application service provision code.
   */
  APPLICATION_SERVICE_PROVISION("ANZSIC", "5921-2", "Application service provision"),

  /**
   * Aromatherapy service code.
   */
  AROMATHERAPY_SERVICE("ANZSIC", "8539-2", "Aromatherapy service"),

  /**
   * Audio and visual media streaming service code.
   */
  AUDIO_AND_VISUAL_MEDIA_STREAMING_SERVICE("ANZSIC", "5921-3", "Audio and visual media streaming service"),

  /**
   * Audiology service code.
   */
  AUDIOLOGY_SERVICE("ANZSIC", "8539-3", "Audiology service"),

  /**
   * Audio and visual media streaming service code.
   */
  AUTOMATED_DATA_PROCESSING_SERVICE("ANZSIC", "5921-4", "Automated data processing service"),

  /**
   * Before and/or after school care service code.
   */
  BEFORE_AND_OR_AFTER_SCHOOL_CARE_SERVICE("ANZSIC", "8710-1", "Before and/or after school care service"),

  /**
   * Billing and record-keeping service code.
   */
  BILLING_AND_RECORD_KEEPING_SERVICE("ANZSIC", "7291-1", "Billing and record-keeping service"),

  /**
   * Blood bank operation code.
   */
  BLOOD_BANK_OPERATION("ANZSIC", "8599-1", "Blood bank operation"),

  /**
   * Business administrative service code.
   */
  BUSINESS_ADMINISTRATIVE_SERVICE("ANZSIC", "7291-2", "Business administrative service"),

  /**
   * Charitable hostels for the aged code.
   */
  CHARITABLE_HOSTELS_FOR_THE_AGED("ANZSIC", "8601-5", "Charitable hostels for the aged"),

  /**
   * Child care service code.
   */
  CHILD_CARE_SERVICE("ANZSIC", "8710-2", "Child care service"),

  /**
   * Childminding service code.
   */
  CHILDMINDING_SERVICE("ANZSIC", "8710-3", "Childminding service"),

  /**
   * Children's Hospital code.
   */
  CHILDRENS_HOSPITAL("ANZSIC", "8401-1", "Children's Hospital"),

  /**
   * Children's nursery operation (except preschool education) code.
   */
  CHILDRENS_NURSERY_OPERATION("ANZSIC", "8710-4", "Children's nursery operation (except preschool education)"),

  /**
   * Children's play programs code.
   */
  CHILDRENS_PLAY_PROGRAMS("ANZSIC", "8710-6", "Children's play programs"),

  /**
   * Chiropractic code.
   */
  CHIROPRACTIC("ANZSIC", "8534-1", "Chiropractic"),

  /**
   * Clerical service code.
   */
  CLERICAL_SERVICE("ANZSIC", "7291-3", "Clerical service"),

  /**
   * Clinical psychology service code.
   */
  CLINICAL_PSYCHOLOGY_SERVICE("ANZSIC", "8539-4", "Clinical psychology service"),

  /**
   * Colleges of education operation code.
   */
  COLLEGES_OF_EDUCATION_OPERATION("ANZSIC", "8102-1", "Colleges of education operation"),

  /**
   * Community Health Care code.
   */
  COMMUNITY_HEALTH_CARE("ANZSIC", "8511-5", "Community Health Care"),

  /**
   * Community Health Facility code.
   */
  COMMUNITY_HEALTH_FACILITY("ANZSIC", "8599-4", "Community Health Facility"),

  /**
   * Community health facility - mental code.
   */
  COMMUNITY_HEALTH_FACILITY_MENTAL("ANZSIC", "8599-8", "Community health facility - mental"),

  /**
   * Community health facility - other code.
   */
  COMMUNITY_HEALTH_FACILITY_OTHER("ANZSIC", "8599-9", "Community health facility - other"),

  /**
   * Community health facility - substance abuse code.
   */
  COMMUNITY_HEALTH_FACILITY_SUBSTANCE_ABUSE("ANZSIC", "8599-7", "Community health facility - substance abuse"),

  /**
   * Community Pharmacy code.
   */
  COMMUNITY_PHARMACY("ANZSIC", "4271-2", "Community Pharmacy"),

  /**
   * Computer data storage and retrieval service (except library service) code.
   */
  COMPUTER_DATA_STORAGE_AND_RETRIEVAL_SERVICE("ANZSIC", "5922-1", "Computer data storage and retrieval service (except library service)"),

  /**
   * Computer hardware consulting service code.
   */
  COMPUTER_HARDWARE_CONSULTING_SERVICE("ANZSIC", "7000-1", "Computer hardware consulting service"),

  /**
   * Computer input preparation service code.
   */
  COMPUTER_INPUT_PREPARATION_SERVICE("ANZSIC", "5921-5", "Computer input preparation service"),

  /**
   * Computer programming service code.
   */
  COMPUTER_PROGRAMMING_SERVICE("ANZSIC", "7000-2", "Computer programming service"),

  /**
   * Computer software consulting service code.
   */
  COMPUTER_SOFTWARE_CONSULTING_SERVICE("ANZSIC", "7000-3", "Computer software consulting service"),

  /**
   * Computer time leasing or renting code.
   */
  COMPUTER_TIME_LEASING_OR_RENTING("ANZSIC", "5921-6", "Computer time leasing or renting"),

  /**
   * Computer time sharing service code.
   */
  COMPUTER_TIME_SHARING_SERVICE("ANZSIC", "5921-7", "Computer time sharing service"),

  /**
   * Conservative dental service code.
   */
  CONSERVATIVE_DENTAL_SERVICE("ANZSIC", "8531-1", "Conservative dental service"),

  /**
   * Contact lens dispensing code.
   */
  CONTACT_LENS_DISPENSING("ANZSIC", "8532-1", "Contact lens dispensing"),

  /**
   * Corporate head office management code.
   */
  CORPORATE_HEAD_OFFICE_MANAGEMENT("ANZSIC", "6961-1", "Corporate head office management"),

  /**
   * Data capture imaging service code.
   */
  DATA_CAPTURE_IMAGING_SERVICE("ANZSIC", "5921-8", "Data capture imaging service"),

  /**
   * Data entry service (electronic) code.
   */
  DATA_ENTRY_SERVICE("ANZSIC", "5921-9", "Data entry service (electronic)"),

  /**
   * Data processing computer service code.
   */
  DATA_PROCESSING_COMPUTER_SERVICE("ANZSIC", "5921-10", "Data processing computer service"),

  /**
   * Day Hospital nec code.
   */
  DAY_HOSPITAL_NEC("ANZSIC", "8401-2", "Day Hospital nec"),

  /**
   * Defence Force Hospital code.
   */
  DEFENCE_FORCE_HOSPITAL("ANZSIC", "8401-18", "Defence Force Hospital"),

  /**
   * Dental hospital (out-patient) code.
   */
  DENTAL_HOSPITAL("ANZSIC", "8531-2", "Dental hospital (out-patient)"),

  /**
   * Dental hygiene service code.
   */
  DENTAL_HYGIENE_SERVICE("ANZSIC", "8539-5", "Dental hygiene service"),

  /**
   * Dental insurance provision code.
   */
  DENTAL_INSURANCE_PROVISION("ANZSIC", "6321-1", "Dental insurance provision"),

  /**
   * Dental practice service code.
   */
  DENTAL_PRACTICE_SERVICE("ANZSIC", "8531-3", "Dental practice service"),

  /**
   * Dental practitioner service code.
   */
  DENTAL_PRACTITIONER_SERVICE("ANZSIC", "8531-4", "Dental practitioner service"),

  /**
   * Dental surgery service code.
   */
  DENTAL_SURGERY_SERVICE("ANZSIC", "8531-5", "Dental surgery service"),

  /**
   * Dermatology Service code.
   */
  DERMATOLOGY_SERVICE("ANZSIC", "8512-3", "Dermatology Service"),

  /**
   * Diagnostic imaging service code.
   */
  DIAGNOSTIC_IMAGING_SERVICE("ANZSIC", "8520-1", "Diagnostic imaging service"),

  /**
   * Dietician service code.
   */
  DIETICIAN_SERVICE("ANZSIC", "8539-6", "Dietician service"),

  /**
   * Disabilities assistance service code.
   */
  DISABILITIES_ASSISTANCE_SERVICE("ANZSIC", "8790-5", "Disabilities assistance service"),

  /**
   * Disk and diskette conversion and recertification service code.
   */
  DISK_AND_DISKETTE_CONVERSION_AND_RECERTIFICATION_SERVICE("ANZSIC", "5921-11", "Disk and diskette conversion and recertification service"),

  /**
   * Divisions of General Practice code.
   */
  DIVISIONS_OF_GENERAL_PRACTICE("ANZSIC", "7511-1", "Divisions of General Practice"),

  /**
   * Ear, nose and throat hospital code.
   */
  EAR_NOSE_AND_THROAT_HOSPITAL("ANZSIC", "8401-3", "Ear, nose and throat hospital"),

  /**
   * Ear, nose and throat specialist service code.
   */
  EAR_NOSE_AND_THROAT_SPECIALIST_SERVICE("ANZSIC", "8512-4", "Ear, nose and throat specialist service"),

  /**
   * Electronic data processing service code.
   */
  ELECTRONIC_DATA_PROCESSING_SERVICE("ANZSIC", "5921-12", "Electronic data processing service"),

  /**
   * Electronic information storage and retrieval service (except library service) code.
   */
  ELECTRONIC_INFORMATION_STORAGE_AND_RETRIEVAL_SERVICE("ANZSIC", "5922-2",
    "Electronic information storage and retrieval service (except library service)"),

  /**
   * Emergency Department Services code.
   */
  EMERGENCY_DEPARTMENT_SERVICES("ANZSIC", "8512-19", "Emergency Department Services"),

  /**
   * Endodontic service code.
   */
  ENDODONTIC_SERVICE("ANZSIC", "8531-6", "Endodontic service"),

  /**
   * Extended Allied Health services code.
   */
  EXTENDED_ALLIED_HEALTH_SERVICES("ANZSIC", "8539-18", "Extended Allied Health services"),

  /**
   * Eye Hospital code.
   */
  EYE_HOSPITAL("ANZSIC", "8401-4", "Eye Hospital"),

  /**
   * Eye testing (optometrist) code.
   */
  EYE_TESTING("ANZSIC", "8532-2", "Eye testing (optometrist)"),

  /**
   * Family day care service code.
   */
  FAMILY_DAY_CARE_SERVICE("ANZSIC", "8710-5", "Family day care service"),

  /**
   * Flying doctor service code.
   */
  FLYING_DOCTOR_SERVICE("ANZSIC", "8511-1", "Flying doctor service"),

  /**
   * Funeral benefit provision code.
   */
  FUNERAL_BENEFIT_PROVISION("ANZSIC", "6321-2", "Funeral benefit provision"),

  /**
   * General Health Administration code.
   */
  GENERAL_HEALTH_ADMINISTRATION("ANZSIC", "7561-1", "General Health Administration"),

  /**
   * General Hospital code.
   */
  GENERAL_HOSPITAL("ANZSIC", "8401-5", "General Hospital"),

  /**
   * General medical practitioner service code.
   */
  GENERAL_MEDICAL_PRACTITIONER_SERVICE("ANZSIC", "8511-2", "General medical practitioner service"),

  /**
   * General practice medical clinic service code.
   */
  GENERAL_PRACTICE_MEDICAL_CLINIC_SERVICE("ANZSIC", "8511-3", "General practice medical clinic service"),

  /**
   * Government nursing home for the aged code.
   */
  GOVERNMENT_NURSING_HOME_FOR_THE_AGED("ANZSIC", "8601-2", "Government nursing home for the aged"),

  /**
   * Government nursing home for young disabled code.
   */
  GOVERNMENT_NURSING_HOME_FOR_YOUNG_DISABLED("ANZSIC", "8609-3", "Government nursing home for young disabled"),

  /**
   * Gynaecology services code.
   */
  GYNAECOLOGY_SERVICES("ANZSIC", "8512-5", "Gynaecology services"),

  /**
   * Hair transplant service (by registered medical practitioner) code.
   */
  HAIR_TRANSPLANT_SERVICE("ANZSIC", "8512-6", "Hair transplant service (by registered medical practitioner)"),

  /**
   * Health and Fitness Centres and Gymnasia Operation code.
   */
  HEALTH_AND_FITNESS_CENTRES_AND_GYMNASIA_OPERATION("ANZSIC", "9111-1", "Health and Fitness Centres and Gymnasia Operation"),

  /**
   * Health assessment service code.
   */
  HEALTH_ASSESSMENT_SERVICE("ANZSIC", "8599-2", "Health assessment service"),

  /**
   * Health insurance provision code.
   */
  HEALTH_INSURANCE_PROVISION("ANZSIC", "6321-3", "Health insurance provision"),

  /**
   * Healthcare service nec code.
   */
  HEALTHCARE_SERVICE_NEC("ANZSIC", "8599-3", "Healthcare service nec"),

  /**
   * Hearing aid dispensing code.
   */
  HEARING_AID_DISPENSING("ANZSIC", "8539-7", "Hearing aid dispensing"),

  /**
   * Herbalist service code.
   */
  HERBALIST_SERVICE("ANZSIC", "8539-8", "Herbalist service"),

  /**
   * Homoeopathic service code.
   */
  HOMOEOPATHIC_SERVICE("ANZSIC", "8539-9", "Homoeopathic service"),

  /**
   * Hospital (except psychiatric or veterinary hospitals) code.
   */
  HOSPITAL("ANZSIC", "8401-6", "Hospital (except psychiatric or veterinary hospitals)"),

  /**
   * Hydropathic service code.
   */
  HYDROPATHIC_SERVICE("ANZSIC", "8539-10", "Hydropathic service"),

  /**
   * Infectious diseases hospital (including human quarantine stations) code.
   */
  INFECTIOUS_DISEASES_HOSPITAL("ANZSIC", "8401-7", "Infectious diseases hospital (including human quarantine stations)"),

  /**
   * Internet access provision code.
   */
  INTERNET_ACCESS_PROVISION("ANZSIC", "5910-1", "Internet access provision"),

  /**
   * Internet access service, on-line code.
   */
  INTERNET_ACCESS_SERVICE_ONLINE("ANZSIC", "5910-2", "Internet access service, on-line"),

  /**
   * Internet and web design consulting service code.
   */
  INTERNET_AND_WEB_DESIGN_CONSULTING_SERVICE("ANZSIC", "7000-4", "Internet and web design consulting service"),

  /**
   * Internet search portal operation code.
   */
  INTERNET_SEARCH_PORTAL_OPERATION("ANZSIC", "5910-3", "Internet search portal operation"),

  /**
   * Internet search web site operation code.
   */
  INTERNET_SEARCH_WEB_SITE_OPERATION("ANZSIC", "5910-4", "Internet search web site operation"),

  /**
   * Internet service provision (ISP) code.
   */
  INTERNET_SERVICE_PROVISION("ANZSIC", "5910-5", "Internet service provision (ISP)"),

  /**
   * Interpretation service code.
   */
  INTERPRETATION_SERVICE("ANZSIC", "6999-1", "Interpretation service"),

  /**
   * Local Government Healthcare Administration code.
   */
  LOCAL_GOVERNMENT_HEALTHCARE_ADMINISTRATION("ANZSIC", "7531-1", "Local Government Healthcare Administration"),

  /**
   * Local government hostel for the aged code.
   */
  LOCAL_GOVERNMENT_HOSTEL_FOR_THE_AGED("ANZSIC", "8601-6", "Local government hostel for the aged"),

  /**
   * Marriage guidance service code.
   */
  MARRIAGE_GUIDANCE_SERVICE("ANZSIC", "8790-6", "Marriage guidance service"),

  /**
   * Maternity Hospital code.
   */
  MATERNITY_HOSPITAL("ANZSIC", "8401-8", "Maternity Hospital"),

  /**
   * Medical laboratory service code.
   */
  MEDICAL_LABORATORY_SERVICE("ANZSIC", "8520-2", "Medical laboratory service"),

  /**
   * Medical research service code.
   */
  MEDICAL_RESEARCH_SERVICE("ANZSIC", "6910-1", "Medical research service"),

  /**
   * Microfiche or microfilm recording and imaging service code.
   */
  MICROFICHE_OR_MICROFILM_RECORDING_AND_IMAGING_SERVICE("ANZSIC", "5921-13", "Microfiche or microfilm recording and imaging service"),

  /**
   * Midwifery service code.
   */
  MIDWIFERY_SERVICE("ANZSIC", "8539-11", "Midwifery service"),

  /**
   * Naturopathic service code.
   */
  NATUROPATHIC_SERVICE("ANZSIC", "8539-12", "Naturopathic service"),

  /**
   * Neurology service code.
   */
  NEUROLOGY_SERVICE("ANZSIC", "8512-7", "Neurology service"),

  /**
   * Nursing service code.
   */
  NURSING_SERVICE("ANZSIC", "8539-13", "Nursing service"),

  /**
   * Obstetrics service code.
   */
  OBSTETRICS_SERVICE("ANZSIC", "8512-8", "Obstetrics service"),

  /**
   * Obstretic Hospital code.
   */
  OBSTRETIC_HOSPITAL("ANZSIC", "8401-9", "Obstretic Hospital"),

  /**
   * Occupational therapy service code.
   */
  OCCUPATIONAL_THERAPY_SERVICE("ANZSIC", "8539-14", "Occupational therapy service"),

  /**
   * Office administrative service n.e.c. code.
   */
  OFFICE_ADMINISTRATIVE_SERVICE_NEC("ANZSIC", "7291-4", "Office administrative service n.e.c."),

  /**
   * Operation of soup kitchen (including mobile) code.
   */
  OPERATION_OF_SOUP_KITCHEN("ANZSIC", "8790-7", "Operation of soup kitchen (including mobile)"),

  /**
   * Ophthalmology service code.
   */
  OPHTHALMOLOGY_SERVICE("ANZSIC", "8512-9", "Ophthalmology service"),

  /**
   * Optical dispensing code.
   */
  OPTICAL_DISPENSING("ANZSIC", "8532-3", "Optical dispensing"),

  /**
   * Optical scanning service code.
   */
  OPTICAL_SCANNING_SERVICE("ANZSIC", "5921-14", "Optical scanning service"),

  /**
   * Optician service code.
   */
  OPTICIAN_SERVICE("ANZSIC", "8532-4", "Optician service"),

  /**
   * Oral pathology service code.
   */
  ORAL_PATHOLOGY_SERVICE("ANZSIC", "8531-7", "Oral pathology service"),

  /**
   * Oral surgery service code.
   */
  ORAL_SURGERY_SERVICE("ANZSIC", "8531-8", "Oral surgery service"),

  /**
   * Orthodontic service code.
   */
  ORTHODONTIC_SERVICE("ANZSIC", "8531-9", "Orthodontic service"),

  /**
   * Orthopaedic service code.
   */
  ORTHOPAEDIC_SERVICE("ANZSIC", "8512-10", "Orthopaedic service"),

  /**
   * Orthoptic service code.
   */
  ORTHOPTIC_SERVICE("ANZSIC", "8532-5", "Orthoptic service"),

  /**
   * Osteopathic Services code.
   */
  OSTEOPATHIC_SERVICES("ANZSIC", "8534-2", "Osteopathic Services"),

  /**
   * Other charitable hostel code.
   */
  OTHER_CHARITABLE_HOSTEL("ANZSIC", "8609-4", "Other charitable hostel"),

  /**
   * Other Commonwealth Hospital code.
   */
  OTHER_COMMONWEALTH_HOSPITAL("ANZSIC", "8401-19", "Other Commonwealth Hospital"),

  /**
   * Other Local government hostel code.
   */
  OTHER_LOCAL_GOVERNMENT_HOSTEL("ANZSIC", "8609-6", "Other Local government hostel"),

  /**
   * Other State government hostel code.
   */
  OTHER_STATE_GOVERNMENT_HOSTEL("ANZSIC", "8609-5", "Other State government hostel"),

  /**
   * Paediatric service code.
   */
  PAEDIATRIC_SERVICE("ANZSIC", "8512-11", "Paediatric service"),

  /**
   * Pathology laboratory service code.
   */
  PATHOLOGY_LABORATORY_SERVICE("ANZSIC", "8520-3", "Pathology laboratory service"),

  /**
   * Payroll processing code.
   */
  PAYROLL_PROCESSING("ANZSIC", "7291-5", "Payroll processing"),

  /**
   * Pedodontics service code.
   */
  PEDODONTICS_SERVICE("ANZSIC", "8531-10", "Pedodontics service"),

  /**
   * Periodontic service code.
   */
  PERIODONTIC_SERVICE("ANZSIC", "8531-11", "Periodontic service"),

  /**
   * Pharmacy, retail, operation code.
   */
  PHARMACY_RETAIL_OPERATION("ANZSIC", "4271-1", "Pharmacy, retail, operation"),

  /**
   * Physiotherapy Services code.
   */
  PHYSIOTHERAPY_SERVICES("ANZSIC", "8533-1", "Physiotherapy Services"),

  /**
   * Podiatry service code.
   */
  PODIATRY_SERVICE("ANZSIC", "8539-15", "Podiatry service"),

  /**
   * Portal web search operation code.
   */
  PORTAL_WEB_SEARCH_OPERATION("ANZSIC", "5910-6", "Portal web search operation"),

  /**
   * Postgraduate school, university operation code.
   */
  POSTGRADUATE_SCHOOL_UNIVERSITY_OPERATION("ANZSIC", "8102-2", "Postgraduate school, university operation"),

  /**
   * Private (non-profit) Community Health Centre code.
   */
  PRIVATE_COMMUNITY_HEALTH_CENTRE("ANZSIC", "8599-6", "Private (non-profit) Community Health Centre"),

  /**
   * Private acute care Hospital code.
   */
  PRIVATE_ACUTE_CARE_HOSPITAL("ANZSIC", "8401-16", "Private acute care Hospital"),

  /**
   * Private alcohol and drug treatment centre code.
   */
  PRIVATE_ALCOHOL_AND_DRUG_TREATMENT_CENTRE("ANZSIC", "8609-8", "Private alcohol and drug treatment centre"),

  /**
   * Private charitable nursing home for the aged code.
   */
  PRIVATE_CHARITABLE_NURSING_HOME_FOR_THE_AGED("ANZSIC", "8601-3", "Private charitable nursing home for the aged"),

  /**
   * Private charitable nursing home for young disabled code.
   */
  PRIVATE_CHARITABLE_NURSING_HOME_FOR_YOUNG_DISABLED("ANZSIC", "8609-1", "Private charitable nursing home for young disabled"),

  /**
   * Private day centre/hospital code.
   */
  PRIVATE_DAY_CENTRE_HOSPITAL("ANZSIC", "8401-13", "Private day centre/hospital."),

  /**
   * Private freestanding day surgery centre code.
   */
  PRIVATE_FREESTANDING_DAY_SURGERY_CENTRE("ANZSIC", "8401-14", "Private freestanding day surgery centre."),

  /**
   * Private Mental Health Hospital code.
   */
  PRIVATE_MENTAL_HEALTH_HOSPITAL("ANZSIC", "8402-2", "Private Mental Health Hospital"),

  /**
   * Private profit nursing home for the aged code.
   */
  PRIVATE_PROFIT_NURSING_HOME_FOR_THE_AGED("ANZSIC", "8601-1", "Private profit nursing home for the aged"),

  /**
   * Private profit nursing home for young disabled code.
   */
  PRIVATE_PROFIT_NURSING_HOME_FOR_YOUNG_DISABLED("ANZSIC", "8609-2", "Private profit nursing home for young disabled"),

  /**
   * Professional, scientific and technical services n.e.c. code.
   */
  PROFESSIONAL_SCIENTIFIC_AND_TECHNICAL_SERVICES_NEC("ANZSIC", "6999-2", "Professional, scientific and technical services n.e.c."),

  /**
   * Prosthodontics service code.
   */
  PROSTHODONTICS_SERVICE("ANZSIC", "8531-12", "Prosthodontics service"),

  /**
   * Provision and administration of public health program code.
   */
  PROVISION_AND_ADMINISTRATION_OF_PUBLIC_HEALTH_PROGRAM("ANZSIC", "7562-1", "Provision and administration of public health program"),

  /**
   * Psychiatry service code.
   */
  PSYCHIATRY_SERVICE("ANZSIC", "8512-12", "Psychiatry service"),

  /**
   * Public acute care Hospital code.
   */
  PUBLIC_ACUTE_CARE_HOSPITAL("ANZSIC", "8401-15", "Public acute care Hospital"),

  /**
   * Public alcohol and drug treatment centre code.
   */
  PUBLIC_ALCOHOL_AND_DRUG_TREATMENT_CENTRE("ANZSIC", "8609-7", "Public alcohol and drug treatment centre"),

  /**
   * Public Community Health Centre code.
   */
  PUBLIC_COMMUNITY_HEALTH_CENTRE("ANZSIC", "8599-5", "Public Community Health Centre"),

  /**
   * Public day centre/hospital code.
   */
  PUBLIC_DAY_CENTRE_HOSPITAL("ANZSIC", "8401-11", "Public day centre/hospital"),

  /**
   * Public freestanding day surgery centre code.
   */
  PUBLIC_FREESTANDING_DAY_SURGERY_CENTRE("ANZSIC", "8401-12", "Public freestanding day surgery centre."),

  /**
   * Public Mental Health Hospital code.
   */
  PUBLIC_MENTAL_HEALTH_HOSPITAL("ANZSIC", "8402-1", "Public Mental Health Hospital"),

  /**
   * Reception service code.
   */
  RECEPTION_SERVICE("ANZSIC", "7291-6", "Reception service"),

  /**
   * Research school, university operation code.
   */
  RESEARCH_SCHOOL_UNIVERSITY_OPERATION("ANZSIC", "8102-3", "Research school, university operation"),

  /**
   * Rheumatology service code.
   */
  RHEUMATOLOGY_SERVICE("ANZSIC", "8512-13", "Rheumatology service"),

  /**
   * Rural general medical practice service code.
   */
  RURAL_GENERAL_MEDICAL_PRACTICE_SERVICE("ANZSIC", "8511-4", "Rural general medical practice service"),

  /**
   * Social science research service code.
   */
  SOCIAL_SCIENCE_RESEARCH_SERVICE("ANZSIC", "6910-2", "Social science research service"),

  /**
   * Software development (customised) service (except publishing) code.
   */
  SOFTWARE_DEVELOPMENT_SERVICE("ANZSIC", "7000-5", "Software development (customised) service (except publishing)"),

  /**
   * Software installation service code.
   */
  SOFTWARE_INSTALLATION_SERVICE("ANZSIC", "7000-6", "Software installation service"),

  /**
   * Specialist institute or college code.
   */
  SPECIALIST_INSTITUTE_OR_COLLEGE("ANZSIC", "8102-4", "Specialist institute or college"),

  /**
   * Specialist medical clinic service code.
   */
  SPECIALIST_MEDICAL_CLINIC_SERVICE("ANZSIC", "8512-14", "Specialist medical clinic service"),

  /**
   * Specialist medical practitioner service nec code.
   */
  SPECIALIST_MEDICAL_PRACTITIONER_SERVICE_NEC("ANZSIC", "8512-15", "Specialist medical practitioner service nec"),

  /**
   * Specialist surgical service code.
   */
  SPECIALIST_SURGICAL_SERVICE("ANZSIC", "8512-16", "Specialist surgical service"),

  /**
   * Spectacles dispensing code.
   */
  SPECTACLES_DISPENSING("ANZSIC", "8532-6", "Spectacles dispensing"),

  /**
   * Speech pathology service code.
   */
  SPEECH_PATHOLOGY_SERVICE("ANZSIC", "8539-16", "Speech pathology service"),

  /**
   * State Government Healthcare Administration code.
   */
  STATE_GOVERNMENT_HEALTHCARE_ADMINISTRATION("ANZSIC", "7521-1", "State Government Healthcare Administration"),

  /**
   * State government hostel for the aged code.
   */
  STATE_GOVERNMENT_HOSTEL_FOR_THE_AGED("ANZSIC", "8601-4", "State government hostel for the aged"),

  /**
   * Subacute Hospitals code.
   */
  SUBACUTE_HOSPITALS("ANZSIC", "8401-20", "Subacute Hospitals"),

  /**
   * Systems analysis service code.
   */
  SYSTEMS_ANALYSIS_SERVICE("ANZSIC", "7000-7", "Systems analysis service"),

  /**
   * Teachers' college operation code.
   */
  TEACHERS_COLLEGE_OPERATION("ANZSIC", "8102-5", "Teachers' college operation"),

  /**
   * Telephone answering service code.
   */
  TELEPHONE_ANSWERING_SERVICE("ANZSIC", "7294-1", "Telephone answering service"),

  /**
   * Telephone call centre operation code.
   */
  TELEPHONE_CALL_CENTRE_OPERATION("ANZSIC", "7294-2", "Telephone call centre operation"),

  /**
   * Therapeutic massage service code.
   */
  THERAPEUTIC_MASSAGE_SERVICE("ANZSIC", "8539-17", "Therapeutic massage service"),

  /**
   * Thoracic specialist service code.
   */
  THORACIC_SPECIALIST_SERVICE("ANZSIC", "8512-17", "Thoracic specialist service"),

  /**
   * Translation service code.
   */
  TRANSLATION_SERVICE("ANZSIC", "6999-3", "Translation service"),

  /**
   * Transport code.
   */
  TRANSPORT("ANZSIC", "4623-1", "Transport"),

  /**
   * Undergraduate school, university operation code.
   */
  UNDERGRADUATE_SCHOOL_UNIVERSITY_OPERATION("ANZSIC", "8102-6", "Undergraduate school, university operation"),

  /**
   * University operation code.
   */
  UNIVERSITY_OPERATION("ANZSIC", "8102-7", "University operation"),

  /**
   * Urology service code.
   */
  UROLOGY_SERVICE("ANZSIC", "8512-18", "Urology service"),

  /**
   * Veterans Affairs Hospital code.
   */
  VETERANS_AFFAIRS_HOSPITAL("ANZSIC", "8401-17", "Veterans Affairs Hospital"),

  /**
   * Voice mailbox service code.
   */
  VOICE_MAILBOX_SERVICE("ANZSIC", "7294-3", "Voice mailbox service"),

  /**
   * Web hosting code.
   */
  WEB_HOSTING("ANZSIC", "5921-15", "Web hosting"),

  /**
   * Web search portal operation code.
   */
  WEB_SEARCH_PORTAL_OPERATION("ANZSIC", "5910-7", "Web search portal operation"),

  /**
   * Welfare counselling service code.
   */
  WELFARE_COUNSELLING_SERVICE("ANZSIC", "8790-8", "Welfare counselling service"),

  /**
   * Women's Hospital code.
   */
  WOMENS_HOSPITAL("ANZSIC", "8401-10", "Women's Hospital"),

  /**
   * X-ray clinic service code.
   */
  XRAY_CLINIC_SERVICE("ANZSIC", "8520-4", "X-ray clinic service"),

  /**
   * Youth welfare service code.
   */
  YOUTH_WELFARE_SERVICE("ANZSIC", "8790-9", "Youth welfare service"),

  /**
   * TBD code.
   */
  TBD("ANZSIC", "TBD", "TBD");

  private String codingSystem;
  private String conceptCode;
  private String conceptName;

  PracticeSettingTypeCodes(String codingSystem, String conceptCode, String conceptName) {
    this.codingSystem = codingSystem;
    this.conceptCode = conceptCode;
    this.conceptName = conceptName;
  }

  /**
   * Retrieve concept code.
   *
   * @return Concept code string.
   */
  private String getConceptCode() {
    return conceptCode;
  }

  public CodedValue getCodedValue() {
    return new CodedValue(codingSystem, conceptCode, conceptName);
  }

  /**
   * Retrieves a {@link au.gov.nehta.vendorlibrary.pcehr.clients.common.type.PracticeSettingTypeCodes} based on a supplied concept code.
   *
   * @param conceptCode Concept to search for.
   * @return Corresponding {@link au.gov.nehta.vendorlibrary.pcehr.clients.common.type.PracticeSettingTypeCodes} or null.
   */
  public static PracticeSettingTypeCodes findByConceptCode(String conceptCode) {
    for (PracticeSettingTypeCodes v : values()) {
      if (v.getConceptCode().equals(conceptCode)) {
        return v;
      }
    }
    return null;
  }
}
