/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSequence
implements Sequence {
    protected final SequenceData data;
    private final DeliveryQueue deliveryQueue;
    private final TimeSynchronizer timeSynchronizer;

    AbstractSequence(@NotNull SequenceData data, @NotNull DeliveryQueueBuilder deliveryQueueBuilder, @NotNull TimeSynchronizer timeSynchronizer) {
        assert (data != null);
        assert (deliveryQueueBuilder != null);
        assert (timeSynchronizer != null);
        this.data = data;
        this.timeSynchronizer = timeSynchronizer;
        deliveryQueueBuilder.sequence(this);
        this.deliveryQueue = deliveryQueueBuilder.build();
    }

    @Override
    public String getId() {
        return this.data.getSequenceId();
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.data.getBoundSecurityTokenReferenceId();
    }

    @Override
    public long getLastMessageNumber() {
        return this.data.getLastMessageNumber();
    }

    @Override
    public List<Sequence.AckRange> getAcknowledgedMessageNumbers() {
        List<Long> values = this.data.getLastMessageNumberWithUnackedMessageNumbers();
        long lastMessageNumber = values.remove(0);
        List<Long> unackedMessageNumbers = values;
        if (lastMessageNumber == 0L) {
            return Collections.emptyList();
        }
        if (unackedMessageNumbers.isEmpty()) {
            return Arrays.asList(new Sequence.AckRange(1L, lastMessageNumber));
        }
        LinkedList<Sequence.AckRange> result = new LinkedList<Sequence.AckRange>();
        long lastBottomAckRange = 1L;
        for (long lastUnacked : unackedMessageNumbers) {
            if (lastBottomAckRange < lastUnacked) {
                result.add(new Sequence.AckRange(lastBottomAckRange, lastUnacked - 1L));
            }
            lastBottomAckRange = lastUnacked + 1L;
        }
        if (lastBottomAckRange <= lastMessageNumber) {
            result.add(new Sequence.AckRange(lastBottomAckRange, lastMessageNumber));
        }
        return result;
    }

    @Override
    public boolean hasUnacknowledgedMessages() {
        return !this.data.getUnackedMessageNumbers().isEmpty();
    }

    @Override
    public Sequence.State getState() {
        return this.data.getState();
    }

    @Override
    public void setAckRequestedFlag() {
        this.data.setAckRequestedFlag(true);
    }

    @Override
    public void clearAckRequestedFlag() {
        this.data.setAckRequestedFlag(false);
    }

    @Override
    public boolean isAckRequested() {
        return this.data.getAckRequestedFlag();
    }

    @Override
    public boolean isFailedOver(long messageNumber) {
        return this.data.isFailedOver(messageNumber);
    }

    @Override
    public void updateLastAcknowledgementRequestTime() {
        this.data.setLastAcknowledgementRequestTime(this.timeSynchronizer.currentTimeInMillis());
    }

    @Override
    public long getLastActivityTime() {
        return this.data.getLastActivityTime();
    }

    @Override
    public boolean isStandaloneAcknowledgementRequestSchedulable(long delayPeriod) {
        return this.timeSynchronizer.currentTimeInMillis() - this.data.getLastAcknowledgementRequestTime() > delayPeriod && this.hasUnacknowledgedMessages();
    }

    @Override
    public void close() {
        this.data.setState(Sequence.State.CLOSED);
        this.deliveryQueue.close();
    }

    @Override
    public boolean isClosed() {
        Sequence.State currentStatus = this.data.getState();
        return currentStatus == Sequence.State.CLOSING || currentStatus == Sequence.State.CLOSED || currentStatus == Sequence.State.TERMINATING;
    }

    @Override
    public boolean isExpired() {
        return this.data.getExpirationTime() == -1L ? false : this.timeSynchronizer.currentTimeInMillis() > this.data.getExpirationTime();
    }

    @Override
    public void preDestroy() {
        this.data.setState(Sequence.State.TERMINATING);
    }

    public SequenceData getData() {
        return this.data;
    }

    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        return this.data.retrieveMessage(correlationId);
    }

    @Override
    public DeliveryQueue getDeliveryQueue() {
        return this.deliveryQueue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSequence other = (AbstractSequence)obj;
        return !(this.data.getSequenceId() == null ? other.data.getSequenceId() != null : !this.data.getSequenceId().equals(other.data.getSequenceId()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.data.getSequenceId() != null ? this.data.getSequenceId().hashCode() : 0);
        return hash;
    }
}

