/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.InternationalStringType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.LocalizedString;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.Slot;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueList;
import org.apache.commons.lang.Validate;

public final class XDSFactory {
    private XDSFactory() {
    }

    public static Slot createSlot(String string, String ... stringArray) {
        Validate.notEmpty((String)string, (String)"'slotName' must be specified.");
        Validate.isTrue((stringArray.length > 0 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        Slot slot = new Slot();
        slot.setName(string);
        ValueList valueList = new ValueList();
        for (String string2 : stringArray) {
            valueList.getValues().add(string2);
        }
        slot.setValueList(valueList);
        return slot;
    }

    public static Slot createSingleValuedSlot(String string, String ... stringArray) {
        Validate.notEmpty((String)string, (String)"'slotName' must be specified.");
        Validate.isTrue((stringArray.length == 1 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        Slot slot = new Slot();
        slot.setName(string);
        ValueList valueList = new ValueList();
        valueList.getValues().add("'" + stringArray[0] + "'");
        slot.setValueList(valueList);
        return slot;
    }

    public static Slot createQuerySlot(String string, String ... stringArray) {
        Validate.notEmpty((String)string, (String)"'slotName' must be specified.");
        Validate.isTrue((stringArray.length > 0 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        Slot slot = new Slot();
        slot.setName(string);
        ValueList valueList = new ValueList();
        for (String string2 : stringArray) {
            valueList.getValues().add("('" + string2 + "')");
        }
        slot.setValueList(valueList);
        return slot;
    }

    public static List<Slot> createQuerySlots(String string, CodedValue ... codedValueArray) {
        Validate.notEmpty((String)string, (String)"'slotName' must be specified.");
        Validate.isTrue((codedValueArray.length > 0 ? 1 : 0) != 0, (String)"'values' must contain at least one value.");
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        if (codedValueArray.length > 0) {
            Slot slot = new Slot();
            slot.setName(string);
            ValueList valueList = new ValueList();
            for (CodedValue codedValue : codedValueArray) {
                valueList.getValues().add("('" + codedValue.getValue() + "^^" + codedValue.getCodeSystem() + "')");
            }
            slot.setValueList(valueList);
            arrayList.add(slot);
        }
        return arrayList;
    }

    public static Slot createQuerySlot(String string, Collection<String> collection) {
        return XDSFactory.createQuerySlot(string, collection.toArray(new String[collection.size()]));
    }

    public static List<Slot> createQuerySlots(String string, Collection<CodedValue> collection) {
        return XDSFactory.createQuerySlots(string, collection.toArray(new CodedValue[collection.size()]));
    }

    public static InternationalStringType createInternationalString(String string) {
        Validate.notEmpty((String)string, (String)"'value' must be specified.");
        LocalizedString localizedString = new LocalizedString();
        localizedString.setValue(string);
        InternationalStringType internationalStringType = new InternationalStringType();
        internationalStringType.getLocalizedStrings().add(localizedString);
        return internationalStringType;
    }

    public static ClassificationType createClassification(String string, String string2, String string3, int n) {
        Validate.notEmpty((String)string, (String)"'classificationScheme' must be specified.");
        Validate.notEmpty((String)string2, (String)"'classifiedObject' must be specified.");
        Validate.isTrue((n > 0 ? 1 : 0) != 0, (String)"'idNum' must be a positive integer.");
        ClassificationType classificationType = new ClassificationType();
        classificationType.setNodeRepresentation(string3);
        classificationType.setClassificationScheme(string);
        classificationType.setClassifiedObject(string2);
        classificationType.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification");
        classificationType.setId(XDSFactory.toClassificationIdString(n));
        return classificationType;
    }

    public static ExternalIdentifierType createExternalIdentifier(String string, String string2, String string3, String string4, int n) {
        ExternalIdentifierType externalIdentifierType = new ExternalIdentifierType();
        externalIdentifierType.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier");
        externalIdentifierType.setIdentificationScheme(string);
        externalIdentifierType.setRegistryObject(string2);
        externalIdentifierType.setName(XDSFactory.createInternationalString(string3));
        externalIdentifierType.setValue(string4);
        externalIdentifierType.setId(XDSFactory.toExternalIdentifierIdString(n));
        return externalIdentifierType;
    }

    public static String toClassificationIdString(int n) {
        return String.format("cl%02d", n);
    }

    public static String toExternalIdentifierIdString(int n) {
        return String.format("ei%02d", n);
    }

    public static String toAssociationIdentifierString(int n) {
        return String.format("as%02d", n);
    }
}

