/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static String serialiseSoapXml(SOAPMessage sOAPMessage) {
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        try {
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            return XmlUtils.serialiseToString((Node)sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String serialiseToString(Node node) throws IOException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            DOMSource dOMSource = new DOMSource(node);
            XmlUtils.getTransformer().transform(dOMSource, streamResult);
            stringWriter.flush();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = null;
            return string;
        }
        catch (TransformerException transformerException) {
            String string = null;
            return string;
        }
        finally {
            stringWriter.close();
        }
        return stringWriter.toString();
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }
}

