/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.SAXParseException2;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.tools.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.xjc.util.DOMUtils;
import com.sun.xml.bind.v2.util.EditDistance;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.JAXWSUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Internalizer {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();
    private final DOMForest forest;
    private final ErrorReceiver errorReceiver;

    public Internalizer(DOMForest forest, WsimportOptions options, ErrorReceiver errorReceiver) {
        this.forest = forest;
        this.errorReceiver = errorReceiver;
    }

    public void transform() {
        for (Element jaxwsBinding : this.forest.outerMostBindings) {
            this.internalize(jaxwsBinding, jaxwsBinding);
        }
    }

    private void validate(Element bindings) {
        NamedNodeMap atts = bindings.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if (a.getNamespaceURI() == null && !a.getLocalName().equals("node") && !a.getLocalName().equals("wsdlLocation")) continue;
        }
    }

    private void internalize(Element bindings, Node inheritedTarget) {
        Element type;
        Element element;
        Node target = inheritedTarget;
        this.validate(bindings);
        if (this.isTopLevelBinding(bindings)) {
            String wsdlLocation;
            if (bindings.getAttributeNode("wsdlLocation") != null) {
                wsdlLocation = bindings.getAttribute("wsdlLocation");
                try {
                    wsdlLocation = new URL(new URL(this.forest.getSystemId(bindings.getOwnerDocument())), wsdlLocation).toExternalForm();
                }
                catch (MalformedURLException e) {
                    wsdlLocation = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(wsdlLocation));
                }
            } else {
                wsdlLocation = this.forest.getFirstRootDocument();
            }
            if ((target = this.forest.get(wsdlLocation)) == null) {
                this.reportError(bindings, WsdlMessages.INTERNALIZER_INCORRECT_SCHEMA_REFERENCE(wsdlLocation, EditDistance.findNearest(wsdlLocation, this.forest.listSystemIDs())));
                return;
            }
        }
        if ((element = DOMUtil.getFirstElementChild(target)) != null && element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") && element.getLocalName().equals("definitions") && (type = DOMUtils.getFirstChildElement(element, "http://schemas.xmlsoap.org/wsdl/", "types")) != null) {
            for (Element schemaElement : DOMUtils.getChildElements(type, "http://www.w3.org/2001/XMLSchema", "schema")) {
                if (!schemaElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", "jaxb")) {
                    schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
                }
                if (schemaElement.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "version")) continue;
                schemaElement.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "2.0");
            }
        }
        NodeList targetNodes = null;
        boolean hasNode = true;
        boolean isToplevelBinding = this.isTopLevelBinding(bindings);
        if ((this.isJAXWSBindings(bindings) || this.isJAXBBindings(bindings)) && bindings.getAttributeNode("node") != null) {
            targetNodes = this.evaluateXPathMultiNode(bindings, target, bindings.getAttribute("node"), new NamespaceContextImpl(bindings));
        } else if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") == null && !isToplevelBinding) {
            hasNode = false;
        } else if (this.isGlobalBinding(bindings) && !this.isWSDLDefinition(target) && this.isTopLevelBinding(bindings.getParentNode())) {
            targetNodes = this.getWSDLDefintionNode(bindings, target);
        }
        if (targetNodes == null && hasNode && !isToplevelBinding) {
            return;
        }
        if (hasNode && targetNodes != null) {
            for (int i = 0; i < targetNodes.getLength(); ++i) {
                Element[] children;
                this.insertBinding(bindings, targetNodes.item(i));
                for (Element child : children = Internalizer.getChildElements(bindings)) {
                    if (!"bindings".equals(child.getLocalName())) continue;
                    this.internalize(child, targetNodes.item(i));
                }
            }
        }
        if (targetNodes == null) {
            Element[] children;
            for (Element child : children = Internalizer.getChildElements(bindings)) {
                this.internalize(child, target);
            }
        }
    }

    private void insertBinding(@NotNull Element bindings, @NotNull Node target) {
        if ("bindings".equals(bindings.getLocalName())) {
            Element[] children;
            for (Element item : children = DOMUtils.getChildElements(bindings)) {
                if ("bindings".equals(item.getLocalName())) continue;
                this.moveUnder(item, (Element)target);
            }
        } else {
            this.moveUnder(bindings, (Element)target);
        }
    }

    private NodeList getWSDLDefintionNode(Node bindings, Node target) {
        return this.evaluateXPathMultiNode(bindings, target, "wsdl:definitions", new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }

            @Override
            public String getPrefix(String nsURI) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private boolean isWSDLDefinition(Node target) {
        if (target == null) {
            return false;
        }
        String localName = target.getLocalName();
        String nsURI = target.getNamespaceURI();
        return Internalizer.fixNull(localName).equals("definitions") && Internalizer.fixNull(nsURI).equals("http://schemas.xmlsoap.org/wsdl/");
    }

    private boolean isTopLevelBinding(Node node) {
        return node.getOwnerDocument().getDocumentElement() == node;
    }

    private boolean isJAXWSBindings(Node bindings) {
        return bindings.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && bindings.getLocalName().equals("bindings");
    }

    private boolean isJAXBBindings(Node bindings) {
        return bindings.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb") && bindings.getLocalName().equals("bindings");
    }

    private boolean isGlobalBinding(Node bindings) {
        if (bindings.getNamespaceURI() == null) {
            this.errorReceiver.warning(this.forest.locatorTable.getStartLocation((Element)bindings), WsdlMessages.INVALID_CUSTOMIZATION_NAMESPACE(bindings.getLocalName()));
            return false;
        }
        return bindings.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && (bindings.getLocalName().equals("package") || bindings.getLocalName().equals("enableAsyncMapping") || bindings.getLocalName().equals("enableAdditionalSOAPHeaderMapping") || bindings.getLocalName().equals("enableWrapperStyle") || bindings.getLocalName().equals("enableMIMEContent"));
    }

    private static Element[] getChildElements(Element parent) {
        ArrayList<Element> a = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (!(item instanceof Element) || !"http://java.sun.com/xml/ns/jaxws".equals(item.getNamespaceURI()) && !"http://java.sun.com/xml/ns/jaxb".equals(item.getNamespaceURI())) continue;
            a.add((Element)item);
        }
        return a.toArray(new Element[a.size()]);
    }

    private NodeList evaluateXPathMultiNode(Node bindings, Node target, String expression, NamespaceContext namespaceContext) {
        NodeList nlst;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nlst = (NodeList)this.xpath.evaluate(expression, target, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            this.reportError((Element)bindings, WsdlMessages.INTERNALIZER_X_PATH_EVALUATION_ERROR(e.getMessage()), e);
            return null;
        }
        if (nlst.getLength() == 0) {
            this.reportError((Element)bindings, WsdlMessages.INTERNALIZER_X_PATH_EVALUATES_TO_NO_TARGET(expression));
            return null;
        }
        return nlst;
    }

    private boolean isJAXBBindingElement(Element e) {
        return Internalizer.fixNull(e.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxb");
    }

    private boolean isJAXWSBindingElement(Element e) {
        return Internalizer.fixNull(e.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxws");
    }

    private void moveUnder(Element decl, Element target) {
        if (this.isJAXBBindingElement(decl)) {
            if (!target.hasAttributeNS("http://www.w3.org/2000/xmlns/", "jaxb")) {
                target.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
            }
            if (!target.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "version")) {
                target.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "2.0");
            }
            if (target.getLocalName().equals("schema") && target.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !target.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes")) {
                target.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:extensionBindingPrefixes", "xjc");
                target.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xjc", "http://java.sun.com/xml/ns/jaxb/xjc");
            }
            target = this.refineSchemaTarget(target);
            this.copyInscopeNSAttributes(decl);
        } else if (this.isJAXWSBindingElement(decl)) {
            if (!target.hasAttributeNS("http://www.w3.org/2000/xmlns/", "JAXWS")) {
                target.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:JAXWS", "http://java.sun.com/xml/ns/jaxws");
            }
            target = this.refineWSDLTarget(target);
            this.copyInscopeNSAttributes(decl);
        } else {
            return;
        }
        if (target.getOwnerDocument() != decl.getOwnerDocument()) {
            decl = (Element)target.getOwnerDocument().importNode(decl, true);
        }
        target.appendChild(decl);
    }

    private void copyInscopeNSAttributes(Element e) {
        Element p = e;
        HashSet<String> inscopes = new HashSet<String>();
        while (true) {
            NamedNodeMap atts = p.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                String prefix;
                Attr a = (Attr)atts.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) || !inscopes.add(prefix = a.getName().indexOf(58) == -1 ? "" : a.getLocalName()) || p == e) continue;
                e.setAttributeNodeNS((Attr)a.cloneNode(true));
            }
            if (p.getParentNode() instanceof Document) break;
            p = (Element)p.getParentNode();
        }
        if (!inscopes.contains("")) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
    }

    public Element refineSchemaTarget(Element target) {
        Element appinfo;
        Element annotation2 = DOMUtils.getFirstChildElement(target, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotation2 == null) {
            annotation2 = this.insertXMLSchemaElement(target, "annotation");
        }
        if ((appinfo = DOMUtils.getFirstChildElement(annotation2, "http://www.w3.org/2001/XMLSchema", "appinfo")) == null) {
            appinfo = this.insertXMLSchemaElement(annotation2, "appinfo");
        }
        return appinfo;
    }

    public Element refineWSDLTarget(Element target) {
        Element JAXWSBindings = DOMUtils.getFirstChildElement(target, "http://java.sun.com/xml/ns/jaxws", "bindings");
        if (JAXWSBindings == null) {
            JAXWSBindings = this.insertJAXWSBindingsElement(target, "bindings");
        }
        return JAXWSBindings;
    }

    private Element insertXMLSchemaElement(Element parent, String localName) {
        String qname2 = parent.getTagName();
        int idx = qname2.indexOf(58);
        qname2 = idx == -1 ? localName : qname2.substring(0, idx + 1) + localName;
        Element child = parent.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", qname2);
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 0) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, children.item(0));
        }
        return child;
    }

    private Element insertJAXWSBindingsElement(Element parent, String localName) {
        String qname2 = "JAXWS:" + localName;
        Element child = parent.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxws", qname2);
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 0) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, children.item(0));
        }
        return child;
    }

    @NotNull
    static String fixNull(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private void reportError(Element errorSource, String formattedMsg) {
        this.reportError(errorSource, formattedMsg, null);
    }

    private void reportError(Element errorSource, String formattedMsg, Exception nestedException) {
        SAXParseException2 e = new SAXParseException2(formattedMsg, this.forest.locatorTable.getStartLocation(errorSource), nestedException);
        this.errorReceiver.error(e);
    }
}

