/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp.impl;

import au.gov.nehta.xsp.XspException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public final class CertificateUtils {
    public static String getSubjectName(X509Certificate certificate) {
        Principal subject;
        String subjectName = null;
        if (certificate != null && (subject = certificate.getSubjectDN()) != null) {
            subjectName = subject.getName();
        }
        return subjectName;
    }

    public static void checkJCEpolicyIsUnlimited() throws XspException {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") < 256) {
                throw new XspException("JCE policy limits cryptography strength: cannot perform AES-256");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new XspException("AES encryption not supported");
        }
        try {
            if (Cipher.getMaxAllowedKeyLength("RSA") < 1024) {
                throw new XspException("JCE policy limits cryptography strength: cannot perform RSA with key size >= 1024");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new XspException("RSA encryption not supported");
        }
    }

    private CertificateUtils() {
    }

    static {
        try {
            CertificateUtils.checkJCEpolicyIsUnlimited();
        }
        catch (XspException e) {
            System.err.println("[WARNING] " + e.getMessage());
        }
    }
}

