/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteBufferInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger(ByteBufferInputStream.class.getName());
    private static int defaultReadTimeout = 15000;
    protected ByteBuffer byteBuffer;
    protected SelectionKey key = null;
    protected int readTimeout = defaultReadTimeout;
    protected int readTry = 2;

    public ByteBufferInputStream() {
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int available() {
        return this.byteBuffer.remaining();
    }

    public void close() {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
        }
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.get() & 0xFF : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
            if (eof <= 0) {
                return -1;
            }
        }
        if (length > this.byteBuffer.remaining()) {
            length = this.byteBuffer.remaining();
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }

    public int read(ByteBuffer bb) throws IOException {
        this.byteBuffer = bb;
        int eof = 0;
        for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
        }
        if (eof <= 0) {
            return -1;
        }
        return this.byteBuffer.limit();
    }

    public void recycle() {
        this.byteBuffer = null;
        this.key = null;
        this.readTimeout = defaultReadTimeout;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doRead() throws IOException {
        if (this.key == null) {
            return -1;
        }
        this.byteBuffer.clear();
        try {
            int n = ByteBufferInputStream.readBlocking((SocketChannel)this.key.channel(), this.byteBuffer, this.readTimeout);
            return n;
        }
        finally {
            this.byteBuffer.flip();
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int rt) {
        this.readTimeout = rt;
    }

    public static int getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public static void setDefaultReadTimeout(int aDefaultReadTimeout) {
        defaultReadTimeout = aDefaultReadTimeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readBlocking(SocketChannel socketChannel, ByteBuffer byteBuffer, int readTimeout) throws IOException {
        int count = 1;
        int byteRead = 0;
        Selector readSelector = null;
        SelectionKey tmpKey = null;
        Exception exception = null;
        try {
            try {}
            catch (Exception e) {
                exception = e;
                if (!(e instanceof IOException)) throw new IOException(e.getClass().getName() + ": " + e.getMessage());
                throw (IOException)e;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            if (readSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(readSelector);
            }
            if (!logger.isLoggable(Level.FINE)) throw throwable;
            logger.log(Level.FINE, "InputStream.read [channel=" + socketChannel + ", bytesRead=" + byteRead + ", timeout=" + readTimeout + ", exception=" + exception + "]");
            if (byteRead <= 0) throw throwable;
            if (!logger.isLoggable(Level.FINEST)) throw throwable;
            logger.log(Level.FINEST, "InputStream.read-content [channel=" + socketChannel + " content=" + new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() - byteRead, byteRead) + "]");
            throw throwable;
        }
        while (count > 0) {
            count = socketChannel.read(byteBuffer);
            if (count > -1) {
                byteRead += count;
                continue;
            }
            if (count != -1 || byteRead != 0) continue;
            byteRead = -1;
        }
        if (byteRead == 0) {
            readSelector = SelectorFactory.getSelector();
            if (readSelector == null) {
                int n2 = 0;
                Object var11_11 = null;
                if (tmpKey != null) {
                    tmpKey.cancel();
                }
                if (readSelector != null) {
                    SelectorFactory.selectNowAndReturnSelector(readSelector);
                }
                if (!logger.isLoggable(Level.FINE)) return n2;
                logger.log(Level.FINE, "InputStream.read [channel=" + socketChannel + ", bytesRead=" + byteRead + ", timeout=" + readTimeout + ", exception=" + exception + "]");
                if (byteRead <= 0) return n2;
                if (!logger.isLoggable(Level.FINEST)) return n2;
                logger.log(Level.FINEST, "InputStream.read-content [channel=" + socketChannel + " content=" + new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() - byteRead, byteRead) + "]");
                return n2;
            }
            count = 1;
            tmpKey = socketChannel.register(readSelector, 1);
            tmpKey.interestOps(tmpKey.interestOps() | 1);
            int code = readSelector.select(readTimeout);
            tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
            if (code == 0) {
                int n = 0;
                Object var11_12 = null;
                if (tmpKey != null) {
                    tmpKey.cancel();
                }
                if (readSelector != null) {
                    SelectorFactory.selectNowAndReturnSelector(readSelector);
                }
                if (!logger.isLoggable(Level.FINE)) return n;
                logger.log(Level.FINE, "InputStream.read [channel=" + socketChannel + ", bytesRead=" + byteRead + ", timeout=" + readTimeout + ", exception=" + exception + "]");
                if (byteRead <= 0) return n;
                if (!logger.isLoggable(Level.FINEST)) return n;
                logger.log(Level.FINEST, "InputStream.read-content [channel=" + socketChannel + " content=" + new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() - byteRead, byteRead) + "]");
                return n;
            }
            while (count > 0) {
                count = socketChannel.read(byteBuffer);
                if (count > -1) {
                    byteRead += count;
                    continue;
                }
                if (count != -1 || byteRead != 0) continue;
                byteRead = -1;
            }
        }
        Object var11_13 = null;
        if (tmpKey != null) {
            tmpKey.cancel();
        }
        if (readSelector != null) {
            SelectorFactory.selectNowAndReturnSelector(readSelector);
        }
        if (!logger.isLoggable(Level.FINE)) return byteRead;
        logger.log(Level.FINE, "InputStream.read [channel=" + socketChannel + ", bytesRead=" + byteRead + ", timeout=" + readTimeout + ", exception=" + exception + "]");
        if (byteRead <= 0) return byteRead;
        if (!logger.isLoggable(Level.FINEST)) return byteRead;
        logger.log(Level.FINEST, "InputStream.read-content [channel=" + socketChannel + " content=" + new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() - byteRead, byteRead) + "]");
        return byteRead;
    }
}

