/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.vendorlibrary.common.JAXBUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtil {
    private static final Logger LOG = Logger.getLogger(DOMUtil.class.getName());

    private DOMUtil() {
    }

    public static Element getDocumentElementFromXML(String string) {
        Document document = DOMUtil.getDocumentFromXML(string);
        Element element = null;
        if (document != null) {
            element = document.getDocumentElement();
        }
        return element;
    }

    public static Document getDocumentFromXML(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            if (document != null) {
                return document;
            }
        }
        catch (SAXException sAXException) {
            LOG.log(Level.SEVERE, null, sAXException);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, null, iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.log(Level.SEVERE, null, parserConfigurationException);
        }
        return null;
    }

    public static <T> Element getDocumentElementFromInstance(Class clazz, String string, String string2, T t) throws JAXBException {
        String string3 = JAXBUtil.marshaller(clazz, string, string2, t);
        ArgumentUtils.checkNotNull((Object)string3, (String)"xmlSource");
        return DOMUtil.getDocumentElementFromXML(string3);
    }

    public static <T> Document getDocumentFromInstance(Class clazz, String string, String string2, T t) throws JAXBException {
        String string3 = JAXBUtil.marshaller(clazz, string, string2, t);
        ArgumentUtils.checkNotNull((Object)string3, (String)"xmlSource");
        return DOMUtil.getDocumentFromXML(string3);
    }

    public static String serialiseToString(Document document) throws TransformerException, IOException {
        return DomUtils.serialiseToString((Document)document);
    }
}

