/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.xsp.EncryptedContainerProfileService;
import au.gov.nehta.xsp.KeyMismatchException;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public final class EncryptedContainerProfileUtil {
    private EncryptedContainerProfileUtil() {
    }

    public static Document getEncryptedPayload(Document document, X509Certificate x509Certificate) {
        ArgumentUtils.checkNotNull((Object)document, (String)"signedDocument");
        ArgumentUtils.checkNotNull((Object)x509Certificate, (String)"encryptingCert");
        Document document2 = null;
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(x509Certificate);
            document2 = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().create(document, arrayList);
        }
        catch (XspException xspException) {
            xspException.printStackTrace();
        }
        return document2;
    }

    public static Document getEncryptedPayload(Document document, SecretKey secretKey, List<X509Certificate> list) {
        ArgumentUtils.checkNotNull((Object)document, (String)"signedDocument");
        ArgumentUtils.checkNotNull((Object)secretKey, (String)"sessionKey");
        ArgumentUtils.checkNotNull(list, (String)"encryptingCertificates");
        Document document2 = null;
        try {
            document2 = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().create(document, secretKey, list);
        }
        catch (XspException xspException) {
            xspException.printStackTrace();
        }
        return document2;
    }

    public static Document getEncryptedPayload(Document document, SecretKey secretKey, X509Certificate x509Certificate) {
        ArgumentUtils.checkNotNull((Object)x509Certificate, (String)"encryptingCert");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        return EncryptedContainerProfileUtil.getEncryptedPayload(document, secretKey, arrayList);
    }

    public static Document getDecryptedPayload(Document document, X500PrivateCredential x500PrivateCredential) throws XspException {
        ArgumentUtils.checkNotNull((Object)document, (String)"encryptedPayload");
        ArgumentUtils.checkNotNull((Object)x500PrivateCredential, (String)"decryptingPrivateCredential");
        Document document2 = null;
        try {
            document2 = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().getData(document, x500PrivateCredential);
        }
        catch (KeyMismatchException keyMismatchException) {
            throw new XspException((Throwable)keyMismatchException);
        }
        return document2;
    }

    public static Document getDecryptedPayload(Document document, SecretKey secretKey) throws XspException {
        ArgumentUtils.checkNotNull((Object)document, (String)"encryptedPayload");
        ArgumentUtils.checkNotNull((Object)secretKey, (String)"sessionKey");
        Document document2 = null;
        try {
            document2 = EncryptedContainerProfileUtil.getEncryptedContainerProfileService().getData(document, secretKey);
        }
        catch (KeyMismatchException keyMismatchException) {
            throw new XspException((Throwable)keyMismatchException);
        }
        return document2;
    }

    private static EncryptedContainerProfileService getEncryptedContainerProfileService() throws XspException {
        return XspFactory.getInstance().getEncryptedContainerProfileService(XspVersion.V_2010);
    }
}

