/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.ws;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class TimeUtility {
    public static final String DATE_FORMAT_NOW = "yyyyMMdd HH:mm:ss";
    public static final String DATE_FORMAT_NOW_REGX = "^([0-9]{4})([0-1][0-9])([0-3][0-9])\\s([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$";
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT_REGX = "^(19|20)\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])$";
    public static final String COMPACT_DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    public static final int DATE_TIME_LENGTH = "yyyyMMddHHmmss".length();
    private static final Logger LOGGER = Logger.getLogger(TimeUtility.class.getName());

    private TimeUtility() {
    }

    public static XMLGregorianCalendar getXMLGregorianDateTime(String string) {
        try {
            if (string.matches(DATE_FORMAT_NOW_REGX)) {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
                String string2 = simpleDateFormat.toPattern();
                Date date = simpleDateFormat.parse(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n = calendar.get(1);
                int n2 = calendar.get(2);
                int n3 = calendar.get(5);
                int n4 = calendar.get(11);
                int n5 = calendar.get(12);
                int n6 = calendar.get(13);
                xMLGregorianCalendar.setDay(n3);
                xMLGregorianCalendar.setYear(n);
                xMLGregorianCalendar.setMonth(n2);
                xMLGregorianCalendar.setHour(n4);
                xMLGregorianCalendar.setMinute(n5);
                xMLGregorianCalendar.setSecond(n6);
                return xMLGregorianCalendar;
            }
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new IllegalArgumentException("Incorrect date format" + string + ". Must be set in " + DATE_FORMAT + " format", datatypeConfigurationException);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Incorrect date format" + string + ". Must be set in " + DATE_FORMAT + " format", parseException);
        }
        throw new IllegalArgumentException("Incorrect date format" + string + ". Must be set in " + DATE_FORMAT + " format");
    }

    public static XMLGregorianCalendar getXMLGregorianDate(String string) {
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            if (string.matches(DATE_FORMAT_REGX)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
                Calendar calendar = Calendar.getInstance();
                Date date = simpleDateFormat.parse(string);
                calendar.setTime(date);
                int n = calendar.get(1);
                int n2 = calendar.get(2);
                int n3 = calendar.get(5);
                xMLGregorianCalendar.setDay(n3);
                xMLGregorianCalendar.setYear(n);
                xMLGregorianCalendar.setMonth(n2 + 1);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
                return xMLGregorianCalendar;
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Incorrect date format" + string + ". Must be set in " + DATE_FORMAT + " format", parseException);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new IllegalArgumentException("Incorrect date format" + string + ". Must be set in " + DATE_FORMAT + " format", datatypeConfigurationException);
        }
        throw new IllegalArgumentException("Incorrect date format " + string + ". Must be set in " + DATE_FORMAT + " format");
    }

    public static String now() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static Date nowDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static String getDateAsYYYYMMDD(Date date) {
        String string = null;
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            string = new String(simpleDateFormat.format(date));
        }
        return string;
    }

    public static XMLGregorianCalendar nowXMLGregorianCalendar() {
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            return xMLGregorianCalendar;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            LOGGER.log(Level.SEVERE, null, datatypeConfigurationException);
            return null;
        }
    }
}

