/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.ConformanceLevels;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentTypeCodes;

public enum FormatCodes {
    SHARED_HEALTH_SUMMARY_3A("1.2.36.1.2001.1006.1.16565.3", DocumentTypeCodes.SHARED_HEALTH_SUMMARY, ConformanceLevels.THREE_A),
    EVENT_SUMMARY_3A("1.2.36.1.2001.1006.1.16473.6", DocumentTypeCodes.EVENT_SUMMARY, ConformanceLevels.THREE_A),
    CONSUMER_ENTERED_NOTES_3A("1.2.36.1.2001.1006.1.16681.2", DocumentTypeCodes.CONSUMER_ENTERED_NOTES, ConformanceLevels.THREE_A),
    CONSUMER_ENTERED_HEALTH_SUMMARY_3A("1.2.36.1.2001.1006.1.16685.2", DocumentTypeCodes.CONSUMER_ENTERED_HEALTH_SUMMARY, ConformanceLevels.THREE_A),
    ADVANCED_CARE_DIRECTIVE_CUSTODIAN_RECORD_3A("1.2.36.1.2001.1006.1.16696.2", DocumentTypeCodes.ADVANCED_CARE_DIRECTIVE_CUSTODIAN_RECORD, ConformanceLevels.THREE_A),
    SPECIALIST_LETTER_1A("1.2.36.1.2001.1006.1.16615.12", DocumentTypeCodes.SPECIALIST_LETTER, ConformanceLevels.ONE_A),
    SPECIALIST_LETTER_1B("1.2.36.1.2001.1006.1.16615.9", DocumentTypeCodes.SPECIALIST_LETTER, ConformanceLevels.ONE_B),
    SPECIALIST_LETTER_2("1.2.36.1.2001.1006.1.16615.10", DocumentTypeCodes.SPECIALIST_LETTER, ConformanceLevels.TWO),
    SPECIALIST_LETTER_3A("1.2.36.1.2001.1006.1.16615.11", DocumentTypeCodes.SPECIALIST_LETTER, ConformanceLevels.THREE_A),
    EREFERRAL_1A("1.2.36.1.2001.1006.1.21000.12", DocumentTypeCodes.EREFERRAL, ConformanceLevels.ONE_A),
    EREFERRAL_1B("1.2.36.1.2001.1006.1.21000.9", DocumentTypeCodes.EREFERRAL, ConformanceLevels.ONE_B),
    EREFERRAL_2("1.2.36.1.2001.1006.1.21000.10", DocumentTypeCodes.EREFERRAL, ConformanceLevels.TWO),
    EREFERRAL_3A("1.2.36.1.2001.1006.1.21000.11", DocumentTypeCodes.EREFERRAL, ConformanceLevels.THREE_A),
    DISCHARGE_SUMMARY_1A("1.2.36.1.2001.1006.1.20000.12", DocumentTypeCodes.DISCHARGE_SUMMARY, ConformanceLevels.ONE_A),
    DISCHARGE_SUMMARY_1B("1.2.36.1.2001.1006.1.20000.9", DocumentTypeCodes.DISCHARGE_SUMMARY, ConformanceLevels.ONE_B),
    DISCHARGE_SUMMARY_2("1.2.36.1.2001.1006.1.20000.10", DocumentTypeCodes.DISCHARGE_SUMMARY, ConformanceLevels.TWO),
    DISCHARGE_SUMMARY_3A("1.2.36.1.2001.1006.1.20000.11", DocumentTypeCodes.DISCHARGE_SUMMARY, ConformanceLevels.THREE_A),
    PCEHR_PRESCRIPTION("1.2.36.1.2001.1006.1.170.1", DocumentTypeCodes.PCEHR_PRESCRIPTION, ConformanceLevels.THREE_A),
    PCEHR_DISPENSE_RECORD("1.2.36.1.2001.1006.1.171.1", DocumentTypeCodes.PCEHR_DISPENSE_RECORD, ConformanceLevels.THREE_A),
    MEDICARE_DVA_BENEFITS_RECORD_3A("1.2.36.1.2001.1006.1.16644.5", DocumentTypeCodes.MEDICARE_DVA_BENEFITS_REPORT, ConformanceLevels.THREE_A),
    PHARMACEUTICAL_BENEFITS_REPORT_3A("1.2.36.1.2001.1006.1.16650.5", DocumentTypeCodes.PHARMACEUTICAL_BENEFITS_REPORT, ConformanceLevels.THREE_A),
    AUSTRALIAN_CHILDHOOD_IMMUNISATION_REGISTER_3A("1.2.36.1.2001.1006.1.16659.5", DocumentTypeCodes.AUSTRALIAN_CHILDHOOD_IMMUNISATION_REGISTER, ConformanceLevels.THREE_A),
    AUSTRALIAN_ORGAN_DONOR_REGISTER_3A("1.2.36.1.2001.1006.1.16671.5", DocumentTypeCodes.AUSTRALIAN_ORGAN_DONOR_REGISTER, ConformanceLevels.THREE_A);

    private static final String DEFAULT_FORMAT_CODING_SYSTEM = "PCEHR_FormatCodes";
    private static final String CONFORMANCE_LABEL = "Conformance Level";
    private String codingSystem;
    private String templateId;
    private DocumentTypeCodes documentTypeCode;
    private ConformanceLevels conformanceLevel;

    private FormatCodes(String string2, String string3, DocumentTypeCodes documentTypeCodes, ConformanceLevels conformanceLevels) {
        this.codingSystem = string2;
        this.templateId = string3;
        this.documentTypeCode = documentTypeCodes;
        this.conformanceLevel = conformanceLevels;
    }

    private FormatCodes(String string2, DocumentTypeCodes documentTypeCodes, ConformanceLevels conformanceLevels) {
        this(DEFAULT_FORMAT_CODING_SYSTEM, string2, documentTypeCodes, conformanceLevels);
    }

    private String getTemplateId() {
        return this.templateId;
    }

    public CodedValue getCodedValue() {
        String string = this.conformanceLevel.equals((Object)ConformanceLevels.UNDEFINED) ? this.documentTypeCode.getTypeCodeDisplayName() : String.format("%s - %s %s", this.documentTypeCode.getTypeCodeDisplayName(), CONFORMANCE_LABEL, this.conformanceLevel.getLevel());
        return new CodedValue(this.codingSystem, this.templateId, string);
    }

    public static FormatCodes findByTemplateId(String string) {
        for (FormatCodes formatCodes : FormatCodes.values()) {
            if (!formatCodes.templateId.equals(string)) continue;
            return formatCodes;
        }
        return null;
    }
}

