/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.documentexchange;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.CommonHeaderValidator;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.xsp.CertificateValidator;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRepositoryPortType;
import ihe.iti.xds_b._2007.DocumentRepositoryService;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequest;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Holder;
import org.apache.commons.lang.Validate;

public final class GetDocumentClient
extends Client<DocumentRepositoryPortType> {
    public GetDocumentClient(SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String string, boolean bl) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sSLSocketFactory, x509Certificate, privateKey, string, bl);
        this.setMTOMEnabled();
    }

    public GetDocumentClient(SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, CertificateValidator certificateValidator, PrivateKey privateKey, String string, boolean bl) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sSLSocketFactory, x509Certificate, certificateValidator, privateKey, string, bl);
        this.setMTOMEnabled();
    }

    public RetrieveDocumentSetResponse retrieveDocument(PCEHRHeader pCEHRHeader, RetrieveDocumentSetRequest.DocumentRequest documentRequest) {
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)documentRequest, (String)"'docRequest' must be specified.");
        Validate.notEmpty((String)documentRequest.getDocumentUniqueId(), (String)"'docRequest.documentUniqueId' must be specified.");
        Validate.notEmpty((String)documentRequest.getRepositoryUniqueId(), (String)"'docRequest.getRepositoryUniqueId' must be specified.");
        CommonHeaderValidator.validate(pCEHRHeader, true);
        RetrieveDocumentSetRequest retrieveDocumentSetRequest = new RetrieveDocumentSetRequest();
        retrieveDocumentSetRequest.getDocumentRequests().add(documentRequest);
        Holder holder = null;
        return ((DocumentRepositoryPortType)this.getPort()).documentRepositoryRetrieveDocumentSet(DateUtils.generateTimestamp(), holder, pCEHRHeader, retrieveDocumentSetRequest);
    }
}

