/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message;

import com.sun.xml.bind.api.Bridge;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.MessageWritable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.message.saaj.SAAJFactory;
import com.sun.xml.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.ws.message.XMLReaderImpl;
import com.sun.xml.ws.message.saaj.SAAJMessage;
import com.sun.xml.ws.spi.db.XMLBridge;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public abstract class AbstractMessageImpl
extends Message {
    protected final SOAPVersion soapVersion;
    protected static final AttributesImpl EMPTY_ATTS = new AttributesImpl();
    protected static final LocatorImpl NULL_LOCATOR = new LocatorImpl();

    protected AbstractMessageImpl(SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public SOAPVersion getSOAPVersion() {
        return this.soapVersion;
    }

    protected AbstractMessageImpl(AbstractMessageImpl that) {
        this.soapVersion = that.soapVersion;
    }

    @Override
    public Source readEnvelopeAsSource() {
        return new SAXSource(new XMLReaderImpl(this), XMLReaderImpl.THE_SOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.readPayloadAsSource());
            return (T)object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        return bridge.unmarshal(this.readPayloadAsSource(), (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
    }

    @Override
    public <T> T readPayloadAsJAXB(XMLBridge<T> bridge) throws JAXBException {
        return bridge.unmarshal(this.readPayloadAsSource(), (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
    }

    @Override
    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        String soapNsUri = this.soapVersion.nsUri;
        w.writeStartDocument();
        w.writeStartElement("S", "Envelope", soapNsUri);
        w.writeNamespace("S", soapNsUri);
        if (this.hasHeaders()) {
            w.writeStartElement("S", "Header", soapNsUri);
            HeaderList headers = this.getHeaders();
            int len = headers.size();
            for (int i = 0; i < len; ++i) {
                headers.get(i).writeTo(w);
            }
            w.writeEndElement();
        }
        w.writeStartElement("S", "Body", soapNsUri);
        this.writePayloadTo(w);
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String soapNsUri = this.soapVersion.nsUri;
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        contentHandler.startPrefixMapping("S", soapNsUri);
        contentHandler.startElement(soapNsUri, "Envelope", "S:Envelope", EMPTY_ATTS);
        if (this.hasHeaders()) {
            contentHandler.startElement(soapNsUri, "Header", "S:Header", EMPTY_ATTS);
            HeaderList headers = this.getHeaders();
            int len = headers.size();
            for (int i = 0; i < len; ++i) {
                headers.get(i).writeTo(contentHandler, errorHandler);
            }
            contentHandler.endElement(soapNsUri, "Header", "S:Header");
        }
        contentHandler.startElement(soapNsUri, "Body", "S:Body", EMPTY_ATTS);
        this.writePayloadTo(contentHandler, errorHandler, true);
        contentHandler.endElement(soapNsUri, "Body", "S:Body");
        contentHandler.endElement(soapNsUri, "Envelope", "S:Envelope");
    }

    protected abstract void writePayloadTo(ContentHandler var1, ErrorHandler var2, boolean var3) throws SAXException;

    public Message toSAAJ(Packet p, Boolean inbound) throws SOAPException {
        SAAJMessage message = SAAJFactory.read(p);
        if (message instanceof MessageWritable) {
            ((MessageWritable)((Object)message)).setMTOMConfiguration(p.getMtomFeature());
        }
        if (inbound != null) {
            this.transportHeaders(p, inbound, message.readAsSOAPMessage());
        }
        return message;
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        return SAAJFactory.read(this.soapVersion, this);
    }

    @Override
    public SOAPMessage readAsSOAPMessage(Packet packet, boolean inbound) throws SOAPException {
        SOAPMessage msg = SAAJFactory.read(this.soapVersion, this, packet);
        this.transportHeaders(packet, inbound, msg);
        return msg;
    }

    private void transportHeaders(Packet packet, boolean inbound, SOAPMessage msg) throws SOAPException {
        Map<String, List<String>> headers = AbstractMessageImpl.getTransportHeaders(packet, inbound);
        if (headers != null) {
            AbstractMessageImpl.addSOAPMimeHeaders(msg.getMimeHeaders(), headers);
        }
        if (msg.saveRequired()) {
            msg.saveChanges();
        }
    }

    @Override
    public MessageHeaders getMessageHeaders() {
        return this.getHeaders();
    }
}

