/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

public class Author {
    public static final String XCN_FORMAT_STRING = "^%s^%s^^^%s^^^&1.2.36.1.2001.1003.0.%s&ISO";
    private String familyName = "";
    private String givenName = "";
    private String prefix = "";
    private String hpii = "";

    public Author(String string, String string2, String string3, String string4) {
        this.familyName = string;
        this.givenName = string2;
        this.prefix = string3;
        this.hpii = string4;
    }

    public Author(String string) {
        String[] stringArray = string.split("\\^");
        if (stringArray.length != 9 || !string.endsWith("&ISO")) {
            throw new IllegalArgumentException("XCN not in a valid format");
        }
        this.familyName = stringArray[1];
        this.givenName = stringArray[2];
        this.prefix = stringArray[5];
        String[] stringArray2 = stringArray[8].split("&");
        if (stringArray2.length != 3) {
            throw new IllegalArgumentException("XCN not in a valid format");
        }
        this.hpii = stringArray2[1];
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String string) {
        this.familyName = string;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String string) {
        this.givenName = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getHpii() {
        return this.hpii;
    }

    public void setHpii(String string) {
        this.hpii = string;
    }

    public String toXCNFormatString() {
        return String.format(XCN_FORMAT_STRING, this.familyName, this.givenName, this.prefix, this.hpii);
    }
}

