/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;

public enum DocumentTypeCodes {
    SHARED_HEALTH_SUMMARY("LOINC", "2.16.840.1.113883.6.1", "60591-5", "Patient Summary", "Shared Health Summary"),
    EREFERRAL("LOINC", "2.16.840.1.113883.6.1", "57133-1", "Referral Note", "e-Referral"),
    SPECIALIST_LETTER("LOINC", "2.16.840.1.113883.6.1", "51852-2", "Letter", "Specialist Letter"),
    DISCHARGE_SUMMARY("LOINC", "2.16.840.1.113883.6.1", "18842-5", "Discharge Summarization Note", "Discharge Summary"),
    EVENT_SUMMARY("LOINC", "2.16.840.1.113883.6.1", "34133-9", "Summarization of episode note", "Event Summary"),
    PHARMACEUTICAL_BENEFITS_REPORT("NCTIS", "1.2.36.1.2001.1001.101", "100.16650", "Pharmaceutical Benefits Report", "Pharmaceutical Benefits Report"),
    AUSTRALIAN_ORGAN_DONOR_REGISTER("NCTIS", "1.2.36.1.2001.1001.101", "100.16671", "Australian Organ Donor Register", "Australian Organ Donor Register"),
    AUSTRALIAN_CHILDHOOD_IMMUNISATION_REGISTER("NCTIS", "1.2.36.1.2001.1001.101", "100.16659", "Australian Childhood Immunisation Register", "Australian Childhood Immunisation Register"),
    MEDICARE_DVA_BENEFITS_REPORT("NCTIS", "1.2.36.1.2001.1001.101", "100.16644", "Medicare/DVA Benefits Report", "Medicare/DVA Benefits Report"),
    CONSUMER_ENTERED_NOTES("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16681", "Consumer Entered Notes", "Personal Health Note"),
    CONSUMER_ENTERED_HEALTH_SUMMARY("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16685", "Consumer Entered Health Summary", "Personal Health Summary"),
    ADVANCED_CARE_DIRECTIVE_CUSTODIAN_RECORD("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16696", "Advance Care Directive Custodian Record", "Advance Care Directive Custodian Record"),
    PCEHR_PRESCRIPTION("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16764", "PCEHR Prescription Record", "eHealth Prescription Record"),
    PCEHR_DISPENSE_RECORD("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16765", "PCEHR Dispense Record", "eHealth Dispense Record"),
    PATHTOLOGY_REPORT("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.32001", "Pathology Report", "Pathology Report"),
    DIAGNOSTIC_IMAGE_REPORT("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16957", "Diagnostic Imaging Report", "Diagnostic Imaging Report"),
    ADVANCED_CARE_DIRECTIVE("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16975", "Advance Care Information", "Advance Care Information"),
    HEALTH_CHECK_ASSESMENT("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16920", "Health Check Assessment", "Health Check Assessment"),
    CHILD_PARENT_QUESTIONNAIRE("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16919", "Child Parent Questionnaire", "Child Parent Questionnaire"),
    CONSUMER_ENTERED_ACHIEVEMENTS("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16812", "Consumer Entered Achievements", "Consumer Entered Achievements"),
    BIRTH_DETAILS("NCTIS Data Components", "1.2.36.1.2001.1001.101", "100.16812", "Birth Details", "Birth Details");

    private String codingSystem;
    private String codingSystemOid;
    private String code;
    private String classCodeDisplayName;
    private String typeCodeDisplayName;

    private DocumentTypeCodes(String string2, String string3, String string4, String string5, String string6) {
        this.codingSystem = string2;
        this.codingSystemOid = string3;
        this.code = string4;
        this.classCodeDisplayName = string5;
        this.typeCodeDisplayName = string6;
    }

    public CodedValue getCodingSystem() {
        return new CodedValue(this.codingSystem, this.codingSystemOid, this.code, this.classCodeDisplayName);
    }

    private String getCode() {
        return this.code;
    }

    public static DocumentTypeCodes findByConceptCode(String string) {
        for (DocumentTypeCodes documentTypeCodes : DocumentTypeCodes.values()) {
            if (!documentTypeCodes.getCode().equals(string)) continue;
            return documentTypeCodes;
        }
        return null;
    }

    public String getTypeCodeDisplayName() {
        return this.typeCodeDisplayName;
    }
}

