/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CX;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentTypeCodes;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.HD;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.XCN;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.XON;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.OIDUtil;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XPathUtils;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class MetadataUtils {
    private static final String DIAGNOSTIC_IMAGE = "100.16957";
    private static final String PATHOLOGY_DOCUMENT_CODE = "100.32001";
    private static final String DISPENSE_DOCUMENT_CODE = "100.16765";
    private static final String PRESCRIPTION_DOCUMENT_CODE = "100.16764";
    private static final String DEFAULT_LANGUAGE_CODE = "en-AU";
    private static final int YMD_DATE_FORMAT = 8;
    private static final int YMDHM_DATE_FORMAT = 12;
    private static final int YMDHMS_DATE_FORMAT = 14;
    private static final int TIMEZONE_FORMAT = 5;
    private static final int YMDHM_WITH_TIMEZONE_FORMAT = 17;
    private static final int YMDHMS_WITH_TIMEZONE_FORMAT = 19;

    private MetadataUtils() {
    }

    public static byte[] calculateSha1Hash(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("sha1");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Unexpected digest method encountered.", noSuchAlgorithmException);
        }
    }

    public static DocumentMetadata toDocumentMetadata(PCEHRHeader pCEHRHeader, byte[] byArray) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        return MetadataUtils.toDocumentMetadata(pCEHRHeader, document);
    }

    public static DocumentMetadata toDocumentMetadata(PCEHRHeader pCEHRHeader, Document document) throws XPathExpressionException {
        Object object;
        DocumentMetadata documentMetadata = new DocumentMetadata();
        String string = XPathUtils.evaluateXPath("/ClinicalDocument/id/@root", document);
        UUID uUID = null;
        try {
            uUID = UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (uUID != null) {
            documentMetadata.setUniqueId(OIDUtil.convertUUIDToOIDIntegerPair(string));
        } else {
            documentMetadata.setUniqueId(string);
        }
        documentMetadata.setCreationTime(DateUtils.toUtcDate(XPathUtils.evaluateXPath("/ClinicalDocument/effectiveTime/@value", document)));
        String string2 = XPathUtils.evaluateXPath("/ClinicalDocument/languageCode/@code", document);
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT_LANGUAGE_CODE;
        }
        documentMetadata.setLanguageCode(string2);
        documentMetadata.setPatientId(MetadataUtils.getPatientId(document));
        documentMetadata.setSourcePatientId(MetadataUtils.getPatientId(document));
        MetadataUtils.setStartStopTime(document, documentMetadata);
        String string3 = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEmployment/employerOrganization/asOrganizationPartOf/wholeOrganization/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-O']/@root", document);
        String string4 = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEmployment/employerOrganization/asOrganizationPartOf/wholeOrganization/name", document);
        if (MetadataUtils.isEmpty(string3)) {
            string3 = XPathUtils.evaluateXPath("/ClinicalDocument/custodian/assignedCustodian/representedCustodianOrganization/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-O']/@root", document);
            string4 = XPathUtils.evaluateXPath("/ClinicalDocument/custodian/assignedCustodian/representedCustodianOrganization/name", document);
            if (MetadataUtils.isEmpty(string3)) {
                string3 = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/location/healthCareFacility/serviceProviderOrganization/asOrganizationPartOf/wholeOrganization/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-O']/@root", document);
                string4 = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/location/healthCareFacility/serviceProviderOrganization/asOrganizationPartOf/wholeOrganization/name", document);
            }
        }
        XON.Builder builder = new XON.Builder();
        builder.organisationName(string4);
        builder.organisationIdentifier(string3);
        documentMetadata.setAuthorInstitution(builder.build());
        documentMetadata.setAuthorSpecialty(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/code/@displayName", document));
        XCN.Builder builder2 = new XCN.Builder();
        builder2.familyName(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/name/family", document));
        builder2.givenName(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/name/given[1]", document));
        builder2.prefix(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/name/prefix", document));
        String string5 = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-I']/@root", document);
        HD.Builder builder3 = new HD.Builder();
        if (MetadataUtils.isNotEmpty(string5)) {
            builder3.identifier(string5).identifierType("ISO");
        } else {
            object = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='PAI-D']/@root", document);
            if (MetadataUtils.isNotEmpty(object)) {
                builder3.identifier((String)object).identifierType("ISO");
            } else {
                String string6 = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id/@root", document);
                String string7 = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id/@extension", document);
                builder3.namespace(string6 + "^").identifier(string7).identifierType("ISO");
            }
        }
        builder2.assigningAuthority(builder3.build());
        documentMetadata.setAuthorPerson(builder2.build());
        object = MetadataUtils.getDocumentTypeCode(document);
        documentMetadata.setDocumentClass(MetadataUtils.getDocumentClass((DocumentTypeCodes)((Object)object)));
        documentMetadata.setDocumentType(MetadataUtils.getDocumentType((DocumentTypeCodes)((Object)object)));
        return documentMetadata;
    }

    private static void setStartStopTime(Document document, DocumentMetadata documentMetadata) throws XPathExpressionException {
        String string = XPathUtils.evaluateXPath("/ClinicalDocument/code/@code", document);
        if (PRESCRIPTION_DOCUMENT_CODE.equals(string)) {
            String string2 = XPathUtils.evaluateXPath("/ClinicalDocument/author/time/@value", document);
            if (MetadataUtils.isNotEmpty(string2)) {
                String string3 = DateUtils.toUtcDate(string2);
                documentMetadata.setServiceStartTime(string3);
                documentMetadata.setServiceStopTime(string3);
            } else {
                MetadataUtils.addGenericStartTime(document, documentMetadata);
                MetadataUtils.addGenricStopTime(documentMetadata, document);
            }
        } else if (DISPENSE_DOCUMENT_CODE.equals(string)) {
            String string4 = XPathUtils.evaluateXPath("/ClinicalDocument/component/structuredBody/component/section[code/@code='102.16210' and code/@codeSystem='1.2.36.1.2001.1001.101']/entry/substanceAdministration/entryRelationship/supply/effectiveTime/@value", document);
            if (MetadataUtils.isNotEmpty(string4)) {
                String string5 = DateUtils.toUtcDate(string4);
                documentMetadata.setServiceStartTime(string5);
                documentMetadata.setServiceStopTime(string5);
            } else {
                MetadataUtils.addGenericStartTime(document, documentMetadata);
                MetadataUtils.addGenricStopTime(documentMetadata, document);
            }
        } else if (PATHOLOGY_DOCUMENT_CODE.equals(string)) {
            String string6 = XPathUtils.evaluateXPath("/ClinicalDocument/component/structuredBody/component/section[code/@code='101.20018']/component/section[code/@code='102.16144']/entry/observation/entryRelationship/observation[code/@code='102.16156']/effectiveTime/@value", document);
            if (MetadataUtils.isNotEmpty(string6)) {
                String string7 = DateUtils.toUtcDate(string6);
                documentMetadata.setServiceStartTime(string7);
                documentMetadata.setServiceStopTime(string7);
            } else {
                MetadataUtils.addGenericStartTime(document, documentMetadata);
                MetadataUtils.addGenricStopTime(documentMetadata, document);
            }
        } else if (DIAGNOSTIC_IMAGE.equals(string)) {
            String string8 = XPathUtils.evaluateXPath("/ClinicalDocument/component/structuredBody/component/section/component/section/entry/observation/entryRelationship/act[code/@code='102.16511']/entryRelationship/observation/effectiveTime/@value", document);
            if (MetadataUtils.isNotEmpty(string8)) {
                String string9 = DateUtils.toUtcDate(string8);
                documentMetadata.setServiceStartTime(string9);
                documentMetadata.setServiceStopTime(string9);
            } else {
                MetadataUtils.addGenericStartTime(document, documentMetadata);
                MetadataUtils.addGenricStopTime(documentMetadata, document);
            }
        } else {
            MetadataUtils.addGenericStartTime(document, documentMetadata);
            MetadataUtils.addGenricStopTime(documentMetadata, document);
        }
    }

    private static void addGenricStopTime(DocumentMetadata documentMetadata, Document document) throws XPathExpressionException {
        String string = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/high/@value", document);
        String string2 = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/@value", document);
        if (MetadataUtils.isNotEmpty(string)) {
            documentMetadata.setServiceStopTime(DateUtils.toUtcDate(string));
        } else if (MetadataUtils.isNotEmpty(string2)) {
            documentMetadata.setServiceStopTime(DateUtils.toUtcDate(string2));
        } else {
            documentMetadata.setServiceStopTime(documentMetadata.getCreationTime());
        }
    }

    private static void addGenericStartTime(Document document, DocumentMetadata documentMetadata) throws XPathExpressionException {
        documentMetadata.setServiceStartTime(MetadataUtils.getGenericStartTime(document, documentMetadata));
    }

    private static String getGenericStartTime(Document document, DocumentMetadata documentMetadata) throws XPathExpressionException {
        String string = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/low/@value", document);
        String string2 = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/@value", document);
        if (MetadataUtils.isNotEmpty(string)) {
            return DateUtils.toUtcDate(string);
        }
        if (MetadataUtils.isNotEmpty(string2)) {
            return DateUtils.toUtcDate(string2);
        }
        return documentMetadata.getCreationTime();
    }

    private static CX getPatientId(Document document) throws XPathExpressionException {
        CX.Builder builder = new CX.Builder();
        String string = XPathUtils.evaluateXPath("/ClinicalDocument/recordTarget/patientRole/patient/asEntityIdentifier/id[@assigningAuthorityName='IHI']/@root", document);
        String[] stringArray = StringUtils.split((String)string, (String)".");
        builder.identifier(stringArray[stringArray.length - 1]);
        builder.assigningAuthority(new HD.Builder().identifier(StringUtils.substringBeforeLast((String)string, (String)".")).identifierType("ISO").build());
        return builder.build();
    }

    private static CodedValue getDocumentClass(DocumentTypeCodes documentTypeCodes) {
        CodedValue codedValue = documentTypeCodes.getCodingSystem();
        return new CodedValue(codedValue.getCodeSystem(), codedValue.getValue(), codedValue.getDisplayName());
    }

    private static CodedValue getDocumentType(DocumentTypeCodes documentTypeCodes) {
        CodedValue codedValue = documentTypeCodes.getCodingSystem();
        return new CodedValue(codedValue.getCodeSystem(), codedValue.getValue(), documentTypeCodes.getTypeCodeDisplayName());
    }

    private static DocumentTypeCodes getDocumentTypeCode(Document document) throws XPathExpressionException {
        String string = XPathUtils.evaluateXPath("/ClinicalDocument/code/@code", document);
        return DocumentTypeCodes.findByConceptCode(string);
    }

    public static Date parseDate(String string) {
        String string2 = string.length() == 8 ? "yyyyMMdd" : (string.length() == 12 ? "yyyyMMddHHmm" : (string.length() == 14 ? "yyyyMMddHHmmss" : (string.length() == 17 ? "yyyyMMddHHmmz" : (string.length() == 19 ? "yyyyMMddHHmmssz" : ""))));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        try {
            Date date = simpleDateFormat.parse(string);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Value [" + string + "] did not contain a valid date/time.", parseException);
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }
}

