/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.lang.Validate;

public final class OIDUtil {
    static final int HEX_RADIX = 16;
    static final String OID_PREFIX = "2.25";
    private static final String UUID_PREFIX = "urn:uuid:";
    private static final String REPLACEMENT = "";
    private static final String SEPERATOR = "-";

    private OIDUtil() {
    }

    public static String convertUUIDToOIDIntegerPair(String string) {
        return OIDUtil.convertUUIDToOIDIntegerPair(OID_PREFIX, string);
    }

    public static String convertUUIDToOIDIntegerPair(String string, String string2) {
        Validate.notEmpty((String)string);
        Validate.notEmpty((String)string2);
        OIDUtil.validateUUID(string2.replace(UUID_PREFIX, REPLACEMENT));
        String string3 = OIDUtil.cleanUuid(string2);
        BigInteger bigInteger = new BigInteger(String.valueOf(0));
        for (int i = 0; i < string3.length(); ++i) {
            bigInteger = bigInteger.multiply(new BigInteger(String.valueOf(16))).add(new BigInteger(String.valueOf(Integer.parseInt(String.valueOf(string3.charAt(i)), 16))));
        }
        return string + '.' + bigInteger;
    }

    private static void validateUUID(String string) {
        UUID.fromString(string);
    }

    private static String cleanUuid(String string) {
        return string.replace(UUID_PREFIX, REPLACEMENT).replace(SEPERATOR, REPLACEMENT);
    }
}

