/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.Author;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentQueryParams;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentStatus;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.SubmissionMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.MetadataUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSFactory;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.Holder;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.ResponseOption;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AdhocQueryType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AssociationType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.InternationalStringType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.LocalizedString;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryObjectList;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.RegistryPackageType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.Slot;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.FastDateFormat;

public final class XDSMapper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int EIGHT_DATE_FORMAT = 8;
    private static final int TWELVE_DATE_FORMAT = 12;
    private static final FastDateFormat DATETIME_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");

    private XDSMapper() {
    }

    public static SubmitObjectsRequest toSubmitObjectsRequest(PCEHRHeader pCEHRHeader, SubmissionMetadata submissionMetadata, DocumentMetadata documentMetadata, String string) {
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)submissionMetadata, (String)"'submissionMetadata' must be specified.");
        Validate.notNull((Object)documentMetadata, (String)"'documentMetadata' must be specified.");
        SubmitObjectsRequest submitObjectsRequest = new SubmitObjectsRequest();
        RegistryObjectList registryObjectList = new RegistryObjectList();
        submitObjectsRequest.setRegistryObjectList(registryObjectList);
        Holder holder = new Holder((Object)0);
        Holder holder2 = new Holder((Object)0);
        Holder holder3 = new Holder((Object)0);
        ExtrinsicObjectType extrinsicObjectType = XDSMapper.toXDSDocumentEntry(pCEHRHeader, documentMetadata, (Holder<Integer>)holder, (Holder<Integer>)holder3);
        registryObjectList.getIdentifiables().add(new ObjectFactory().createExtrinsicObject(extrinsicObjectType));
        RegistryPackageType registryPackageType = XDSMapper.toXDSSubmissionSet(submissionMetadata, documentMetadata, (Holder<Integer>)holder, (Holder<Integer>)holder3);
        registryObjectList.getIdentifiables().add(new ObjectFactory().createRegistryPackage(registryPackageType));
        ClassificationType classificationType = new ClassificationType();
        classificationType.setClassifiedObject(submissionMetadata.getEntryUuid());
        classificationType.setClassificationNode("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        classificationType.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification");
        Holder holder4 = holder;
        holder4.value = (Integer)holder4.value + 1;
        classificationType.setId(XDSFactory.toClassificationIdString((Integer)holder4.value));
        registryObjectList.getIdentifiables().add(new ObjectFactory().createClassification(classificationType));
        holder4 = new AssociationType1();
        Holder holder5 = holder2;
        holder5.value = (Integer)holder5.value + 1;
        holder4.setId(XDSFactory.toAssociationIdentifierString((Integer)holder5.value));
        holder4.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
        holder4.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Association");
        holder4.setSourceObject(registryPackageType.getId());
        holder4.setTargetObject(extrinsicObjectType.getId());
        holder4.getSlots().add(XDSFactory.createSlot("SubmissionSetStatus", "Original"));
        registryObjectList.getIdentifiables().add(new ObjectFactory().createAssociation((AssociationType1)holder4));
        if (StringUtils.isNotBlank((String)string)) {
            holder4 = new AssociationType1();
            holder5 = holder2;
            holder5.value = (Integer)holder5.value + 1;
            holder4.setId(XDSFactory.toAssociationIdentifierString((Integer)holder5.value));
            holder4.setAssociationType("urn:ihe:iti:2007:AssociationType:RPLC");
            holder4.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Association");
            holder4.setSourceObject(extrinsicObjectType.getId());
            holder4.setTargetObject(string);
            holder4.setName(XDSFactory.createInternationalString("Replace Document"));
            registryObjectList.getIdentifiables().add(new ObjectFactory().createAssociation((AssociationType1)holder4));
        }
        return submitObjectsRequest;
    }

    public static ExtrinsicObjectType toXDSDocumentEntry(PCEHRHeader pCEHRHeader, DocumentMetadata documentMetadata, Holder<Integer> holder, Holder<Integer> holder2) {
        ClassificationType classificationType;
        Object object2;
        byte[] byArray;
        ExtrinsicObjectType extrinsicObjectType = new ExtrinsicObjectType();
        extrinsicObjectType.setId(documentMetadata.getEntryUuid());
        extrinsicObjectType.setObjectType("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1");
        extrinsicObjectType.setMimeType("application/zip");
        if (documentMetadata.getCreationTime() != null) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("creationTime", documentMetadata.getCreationTime()));
        }
        extrinsicObjectType.getSlots().add(XDSFactory.createSlot("languageCode", documentMetadata.getLanguageCode()));
        if (documentMetadata.getRepositoryUniqueId() != null) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("repositoryUniqueId", documentMetadata.getRepositoryUniqueId()));
        }
        if (documentMetadata.getServiceStartTime() != null) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("serviceStartTime", documentMetadata.getServiceStartTime()));
        }
        if (documentMetadata.getServiceStopTime() != null) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("serviceStopTime", documentMetadata.getServiceStopTime()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getSourcePatientId().toString())) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("sourcePatientId", documentMetadata.getSourcePatientId().toString()));
        }
        if ((byArray = documentMetadata.getDocumentHash()) != null && byArray.length > 0) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("hash", Base64.encodeBase64String((byte[])byArray)));
        }
        if (documentMetadata.getDocumentSize() != null) {
            extrinsicObjectType.getSlots().add(XDSFactory.createSlot("size", documentMetadata.getDocumentSize().toString()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString()) || StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
            object2 = holder;
            ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d", documentMetadata.getEntryUuid(), "", (Integer)((Holder)object2).value);
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
                classificationType.getSlots().add(XDSFactory.createSlot("authorInstitution", documentMetadata.getAuthorInstitution().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString())) {
                classificationType.getSlots().add(XDSFactory.createSlot("authorPerson", documentMetadata.getAuthorPerson().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorSpecialty())) {
                classificationType.getSlots().add(XDSFactory.createSlot("authorSpecialty", documentMetadata.getAuthorSpecialty()));
            }
            extrinsicObjectType.getClassifications().add(classificationType);
        }
        if (documentMetadata.getDocumentClass() != null) {
            object2 = holder;
            ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a", documentMetadata.getEntryUuid(), documentMetadata.getDocumentClass().getValue(), (Integer)((Holder)object2).value);
            classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getDocumentClass().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getDocumentClass().getDisplayName())) {
                classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentType().getDisplayName()));
            }
            extrinsicObjectType.getClassifications().add(classificationType);
        }
        object2 = holder;
        ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
        classificationType = XDSFactory.createClassification("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", documentMetadata.getEntryUuid(), "1.3.6.1.4.1.21367.2006.7.101", (Integer)((Holder)object2).value);
        classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getConfidentialityCode().getCodedValue().getCodeSystem()));
        classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getConfidentialityCode().getCodedValue().getDisplayName()));
        extrinsicObjectType.getClassifications().add(classificationType);
        if (documentMetadata.getFormatCode() != null) {
            object2 = holder;
            ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", documentMetadata.getEntryUuid(), documentMetadata.getFormatCode().getValue(), (Integer)((Holder)object2).value);
            classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getFormatCode().getCodeSystem()));
            classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getFormatCode().getDisplayName()));
            extrinsicObjectType.getClassifications().add(classificationType);
        }
        if (documentMetadata.getHealthcareFacilityType() != null) {
            object2 = holder;
            ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1", documentMetadata.getEntryUuid(), documentMetadata.getHealthcareFacilityType().getValue(), (Integer)((Holder)object2).value);
            classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getHealthcareFacilityType().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getHealthcareFacilityType().getDisplayName())) {
                classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getHealthcareFacilityType().getDisplayName()));
            }
            extrinsicObjectType.getClassifications().add(classificationType);
        }
        if (documentMetadata.getPracticeSetting() != null) {
            object2 = holder;
            ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead", documentMetadata.getEntryUuid(), documentMetadata.getPracticeSetting().getValue(), (Integer)((Holder)object2).value);
            classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getPracticeSetting().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getPracticeSetting().getDisplayName())) {
                classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getPracticeSetting().getDisplayName()));
            }
            extrinsicObjectType.getClassifications().add(classificationType);
        }
        if (StringUtils.isNotBlank((String)pCEHRHeader.getIhiNumber())) {
            Holder<Integer> object3 = holder2;
            object3.value = (Integer)object3.value + 1;
            object2 = XDSFactory.createExternalIdentifier("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", documentMetadata.getEntryUuid(), "XDSDocumentEntry.patientId", documentMetadata.getPatientId().toString(), (Integer)object3.value);
            extrinsicObjectType.getExternalIdentifiers().add(object2);
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getEntryUuid())) {
            Holder<Integer> holder3 = holder2;
            holder3.value = (Integer)holder3.value + 1;
            object2 = XDSFactory.createExternalIdentifier("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab", documentMetadata.getEntryUuid(), "XDSDocumentEntry.uniqueId", documentMetadata.getUniqueId(), (Integer)holder3.value);
            extrinsicObjectType.getExternalIdentifiers().add(object2);
        }
        if (documentMetadata.hasKeywords()) {
            for (String string : documentMetadata.getKeywords()) {
                Holder<Integer> holder4 = holder;
                holder4.value = (Integer)holder4.value + 1;
                classificationType = XDSFactory.createClassification("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4", documentMetadata.getEntryUuid(), string, (Integer)holder4.value);
                classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", "NA"));
                classificationType.setName(XDSFactory.createInternationalString(string));
                extrinsicObjectType.getClassifications().add(classificationType);
            }
        }
        if (documentMetadata.getDocumentClass() != null) {
            object2 = holder;
            ((Holder)object2).value = (Integer)((Holder)object2).value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983", documentMetadata.getEntryUuid(), documentMetadata.getDocumentType().getValue(), (Integer)((Holder)object2).value);
            classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getDocumentClass().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getDocumentType().getDisplayName())) {
                classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentType().getDisplayName()));
            }
            extrinsicObjectType.getClassifications().add(classificationType);
        }
        return extrinsicObjectType;
    }

    public static RegistryPackageType toXDSSubmissionSet(SubmissionMetadata submissionMetadata, DocumentMetadata documentMetadata, Holder<Integer> holder, Holder<Integer> holder2) {
        ClassificationType classificationType;
        Holder<Integer> holder3;
        RegistryPackageType registryPackageType = new RegistryPackageType();
        registryPackageType.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:RegistryPackage");
        registryPackageType.setId(submissionMetadata.getEntryUuid());
        if (submissionMetadata.getSubmissionTime() != null) {
            registryPackageType.getSlots().add(XDSFactory.createSlot("submissionTime", XDSMapper.toDateTimeString(submissionMetadata.getSubmissionTime())));
        }
        if (StringUtils.isNotBlank((String)submissionMetadata.getComments())) {
            registryPackageType.setDescription(XDSFactory.createInternationalString(submissionMetadata.getComments()));
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString()) || StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
            holder3 = holder;
            holder3.value = (Integer)holder3.value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d", submissionMetadata.getEntryUuid(), "", (Integer)holder3.value);
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
                classificationType.getSlots().add(XDSFactory.createSlot("authorInstitution", documentMetadata.getAuthorInstitution().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorPerson().toString())) {
                classificationType.getSlots().add(XDSFactory.createSlot("authorPerson", documentMetadata.getAuthorPerson().toString()));
            }
            if (StringUtils.isNotBlank((String)documentMetadata.getAuthorSpecialty())) {
                classificationType.getSlots().add(XDSFactory.createSlot("authorSpecialty", documentMetadata.getAuthorSpecialty()));
            }
            registryPackageType.getClassifications().add(classificationType);
        }
        if (documentMetadata.getDocumentType() != null) {
            holder3 = holder;
            holder3.value = (Integer)holder3.value + 1;
            classificationType = XDSFactory.createClassification("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500", submissionMetadata.getEntryUuid(), documentMetadata.getDocumentClass().getValue(), (Integer)holder3.value);
            classificationType.getSlots().add(XDSFactory.createSlot("codingScheme", documentMetadata.getDocumentClass().getCodeSystem()));
            if (StringUtils.isNotBlank((String)documentMetadata.getDocumentClass().getDisplayName())) {
                classificationType.setName(XDSFactory.createInternationalString(documentMetadata.getDocumentType().getDisplayName()));
            }
            registryPackageType.getClassifications().add(classificationType);
        }
        holder3 = holder2;
        holder3.value = (Integer)holder3.value + 1;
        classificationType = XDSFactory.createExternalIdentifier("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8", submissionMetadata.getEntryUuid(), "XDSSubmissionSet.uniqueId", documentMetadata.getUniqueId(), (Integer)holder3.value);
        registryPackageType.getExternalIdentifiers().add(classificationType);
        if (StringUtils.isNotBlank((String)documentMetadata.getAuthorInstitution().toString())) {
            holder3 = holder2;
            holder3.value = (Integer)holder3.value + 1;
            classificationType = XDSFactory.createExternalIdentifier("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832", submissionMetadata.getEntryUuid(), "XDSSubmissionSet.sourceId", documentMetadata.getAuthorInstitution().getOrganisationIdentifier(), (Integer)holder3.value);
            registryPackageType.getExternalIdentifiers().add(classificationType);
        }
        if (StringUtils.isNotBlank((String)documentMetadata.getPatientId().toString())) {
            holder3 = holder2;
            holder3.value = (Integer)holder3.value + 1;
            classificationType = XDSFactory.createExternalIdentifier("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446", submissionMetadata.getEntryUuid(), "XDSSubmissionSet.patientId", documentMetadata.getPatientId().toString(), (Integer)holder3.value);
            registryPackageType.getExternalIdentifiers().add(classificationType);
        }
        return registryPackageType;
    }

    public static AdhocQueryRequest toAdhocQueryRequest(PCEHRHeader pCEHRHeader, String string, DocumentQueryParams documentQueryParams) {
        AbstractCollection abstractCollection;
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)documentQueryParams, (String)"'queryParams' must be specified.");
        Validate.notNull((Object)string, (String)"'queryId' must be specified.");
        AdhocQueryRequest adhocQueryRequest = new AdhocQueryRequest();
        ResponseOption responseOption = new ResponseOption();
        responseOption.setReturnComposedObjects(Boolean.TRUE);
        responseOption.setReturnType("LeafClass");
        adhocQueryRequest.setResponseOption(responseOption);
        AdhocQueryType adhocQueryType = new AdhocQueryType();
        adhocQueryType.setId(string);
        adhocQueryRequest.setAdhocQuery(adhocQueryType);
        if (StringUtils.isNotBlank((String)pCEHRHeader.getIhiNumber())) {
            adhocQueryType.getSlots().add(XDSFactory.createSingleValuedSlot("$XDSDocumentEntryPatientId", String.format("%s%s", pCEHRHeader.getIhiNumber(), "^^^&1.2.36.1.2001.1003.0&ISO")));
        }
        if (documentQueryParams.hasAuthorIndividuals()) {
            abstractCollection = new ArrayList<String>();
            for (Author object : documentQueryParams.getAuthorIndividuals()) {
                abstractCollection.add((String)object.toXCNFormatString());
            }
            adhocQueryType.getSlots().add(XDSFactory.createQuerySlot("$XDSDocumentEntryAuthorPerson", abstractCollection));
        }
        if (documentQueryParams.hasDocumentTypes()) {
            adhocQueryType.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryTypeCode", documentQueryParams.getDocumentTypes()));
        }
        if (documentQueryParams.hasDocumentClasses()) {
            adhocQueryType.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryClassCode", documentQueryParams.getDocumentClasses()));
        }
        if (documentQueryParams.hasTemplateIds()) {
            adhocQueryType.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryFormatCode", documentQueryParams.getTemplateIds()));
        }
        if (documentQueryParams.getDocumentCreationTimeFrom() != null) {
            adhocQueryType.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryCreationTimeFrom", documentQueryParams.getDocumentCreationTimeFrom()));
        }
        if (documentQueryParams.getDocumentCreationTimeTo() != null) {
            adhocQueryType.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryCreationTimeTo", documentQueryParams.getDocumentCreationTimeTo()));
        }
        if (documentQueryParams.getServiceStartTimeFrom() != null) {
            adhocQueryType.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStartTimeFrom", documentQueryParams.getServiceStartTimeFrom()));
        }
        if (documentQueryParams.getServiceStartTimeTo() != null) {
            adhocQueryType.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStartTimeTo", documentQueryParams.getServiceStartTimeTo()));
        }
        if (documentQueryParams.getServiceStopTimeFrom() != null) {
            adhocQueryType.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStopTimeFrom", documentQueryParams.getServiceStopTimeFrom()));
        }
        if (documentQueryParams.getServiceStopTimeTo() != null) {
            adhocQueryType.getSlots().add(XDSFactory.createSlot("$XDSDocumentEntryServiceStopTimeTo", documentQueryParams.getServiceStopTimeTo()));
        }
        if (documentQueryParams.hasHealthcareFacilityTypes()) {
            adhocQueryType.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryHealthcareFacilityTypeCode", documentQueryParams.getHealthcareFacilityTypes()));
        }
        if (documentQueryParams.hasClinicalSpecialties()) {
            adhocQueryType.getSlots().addAll(XDSFactory.createQuerySlots("$XDSDocumentEntryPracticeSettingCode", documentQueryParams.getClinicalSpecialties()));
        }
        if (documentQueryParams.hasKeywords()) {
            adhocQueryType.getSlots().add(XDSFactory.createQuerySlot("$XDSDocumentEntryEventCodeList", documentQueryParams.getKeywords()));
        }
        if (documentQueryParams.hasStatuses()) {
            abstractCollection = new HashSet();
            for (DocumentStatus documentStatus : documentQueryParams.getStatuses()) {
                abstractCollection.add((String)documentStatus.getCode());
            }
            adhocQueryType.getSlots().add(XDSFactory.createQuerySlot("$XDSDocumentEntryStatus", abstractCollection));
        }
        return adhocQueryRequest;
    }

    public static DocumentQueryParams getDocumentQueryParams(PCEHRHeader pCEHRHeader, AdhocQueryRequest adhocQueryRequest) {
        List<String> list;
        List<CodedValue> list2;
        List<CodedValue> list3;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Object object2;
        Object object3;
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' must be specified.");
        Validate.notNull((Object)adhocQueryRequest, (String)"'queryRequest' must be specified.");
        Validate.notNull((Object)adhocQueryRequest.getAdhocQuery(), (String)"'queryRequest.adhocQuery' must be specified.");
        DocumentQueryParams documentQueryParams = new DocumentQueryParams();
        AdhocQueryType adhocQueryType = adhocQueryRequest.getAdhocQuery();
        String string6 = XDSMapper.getQuerySlotValue(adhocQueryType.getSlots(), "$XDSDocumentEntryPatientId");
        Validate.notEmpty((String)string6, (String)String.format("'%s' must be specified in the AdhocQuery.", "$XDSDocumentEntryPatientId"));
        if (!StringUtils.equals((String)pCEHRHeader.getIhiNumber(), (String)string6)) {
            throw new IllegalArgumentException(String.format("The PCEHRHeader.IHINumber [%s] does not equal the %s parameter in the AdhocQuery [%s].", pCEHRHeader.getIhiNumber(), "$XDSDocumentEntryPatientId", string6));
        }
        List<String> list4 = XDSMapper.getQuerySlotValues(adhocQueryType.getSlots(), "$XDSDocumentEntryAuthorPerson");
        if (!list4.isEmpty()) {
            object3 = list4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = new Author((String)object2);
                documentQueryParams.getAuthorIndividuals().add((Author)object);
            }
        }
        if (!(object3 = XDSMapper.getQuerySlotCodedValues(adhocQueryType.getSlots(), "$XDSDocumentEntryClassCode")).isEmpty()) {
            documentQueryParams.getDocumentTypes().addAll((Collection<CodedValue>)object3);
        }
        if (!(object2 = XDSMapper.getQuerySlotCodedValues(adhocQueryType.getSlots(), "$XDSDocumentEntryFormatCode")).isEmpty()) {
            documentQueryParams.getTemplateIds().addAll((Collection<CodedValue>)object2);
        }
        if ((object = XDSMapper.getQuerySlotDateTimeValue(adhocQueryType.getSlots(), "$XDSDocumentEntryCreationTimeFrom")) != null) {
            documentQueryParams.setDocumentCreationTimeFrom((String)object);
        }
        if ((string5 = XDSMapper.getQuerySlotDateTimeValue(adhocQueryType.getSlots(), "$XDSDocumentEntryCreationTimeTo")) != null) {
            documentQueryParams.setDocumentCreationTimeTo(string5);
        }
        if ((string4 = XDSMapper.getQuerySlotDateTimeValue(adhocQueryType.getSlots(), "$XDSDocumentEntryServiceStartTimeFrom")) != null) {
            documentQueryParams.setServiceStartTimeFrom(string4);
        }
        if ((string3 = XDSMapper.getQuerySlotDateTimeValue(adhocQueryType.getSlots(), "$XDSDocumentEntryServiceStartTimeTo")) != null) {
            documentQueryParams.setServiceStartTimeTo(string3);
        }
        if ((string2 = XDSMapper.getQuerySlotDateTimeValue(adhocQueryType.getSlots(), "$XDSDocumentEntryServiceStopTimeFrom")) != null) {
            documentQueryParams.setServiceStopTimeFrom(string2);
        }
        if ((string = XDSMapper.getQuerySlotDateTimeValue(adhocQueryType.getSlots(), "$XDSDocumentEntryServiceStopTimeTo")) != null) {
            documentQueryParams.setServiceStopTimeTo(string);
        }
        if (!(list3 = XDSMapper.getQuerySlotCodedValues(adhocQueryType.getSlots(), "$XDSDocumentEntryHealthcareFacilityTypeCode")).isEmpty()) {
            documentQueryParams.getHealthcareFacilityTypes().addAll(list3);
        }
        if (!(list2 = XDSMapper.getQuerySlotCodedValues(adhocQueryType.getSlots(), "$XDSDocumentEntryPracticeSettingCode")).isEmpty()) {
            documentQueryParams.getClinicalSpecialties().addAll(list2);
        }
        if (!(list = XDSMapper.getQuerySlotValues(adhocQueryType.getSlots(), "$XDSDocumentEntryEventCodeList")).isEmpty()) {
            documentQueryParams.getKeywords().addAll(list);
        }
        List<String> list5 = XDSMapper.getQuerySlotValues(adhocQueryType.getSlots(), "$XDSDocumentEntryStatus");
        Validate.notEmpty(list5, (String)"'$XDSDocumentEntryStatus' must be specified in the AdhocQuery.");
        for (String string7 : list5) {
            documentQueryParams.getStatuses().add(DocumentStatus.fromCode(string7));
        }
        return documentQueryParams;
    }

    public static List<SubmissionMetadata> getSubmissionMetadata(RegistryObjectList registryObjectList) {
        Validate.notNull((Object)registryObjectList, (String)"'registryObjectList' must be specified.");
        ArrayList<SubmissionMetadata> arrayList = new ArrayList<SubmissionMetadata>();
        for (JAXBElement jAXBElement : registryObjectList.getIdentifiables()) {
            if (!(jAXBElement.getValue() instanceof RegistryPackageType)) continue;
            RegistryPackageType registryPackageType = (RegistryPackageType)jAXBElement.getValue();
            arrayList.add(XDSMapper.getSubmissionMetadata(registryPackageType));
        }
        return arrayList;
    }

    public static SubmissionMetadata getSubmissionMetadata(RegistryPackageType registryPackageType) {
        SubmissionMetadata submissionMetadata = new SubmissionMetadata();
        submissionMetadata.setSubmissionTime(XDSMapper.getSlotDate(registryPackageType.getSlots(), "submissionTime"));
        submissionMetadata.setComments(XDSMapper.getString(registryPackageType.getDescription()));
        return submissionMetadata;
    }

    private static ClassificationType getClassfication(List<ClassificationType> list, String string) {
        for (ClassificationType classificationType : list) {
            if (!StringUtils.equals((String)classificationType.getClassificationScheme(), (String)string)) continue;
            return classificationType;
        }
        return null;
    }

    private static Slot getSlot(List<Slot> list, String string) {
        for (Slot slot : list) {
            if (!StringUtils.equals((String)slot.getName(), (String)string)) continue;
            return slot;
        }
        return null;
    }

    private static String getSlotValue(List<Slot> list, String string) {
        Slot slot = XDSMapper.getSlot(list, string);
        if (slot != null) {
            return XDSMapper.getSlotValue(slot);
        }
        return null;
    }

    private static String getSlotValue(Slot slot) {
        if (slot.getValueList() != null && !slot.getValueList().getValues().isEmpty()) {
            return (String)slot.getValueList().getValues().get(0);
        }
        return null;
    }

    private static List<String> getQuerySlotValues(Slot slot) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : slot.getValueList().getValues()) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            if (string.startsWith("('")) {
                string = string.substring(2);
            }
            if (string.endsWith("')")) {
                string = string.substring(0, string.length() - 2);
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private static List<String> getQuerySlotValues(List<Slot> list, String string) {
        Slot slot = XDSMapper.getSlot(list, string);
        if (slot != null) {
            return XDSMapper.getQuerySlotValues(slot);
        }
        return Collections.emptyList();
    }

    private static List<CodedValue> getQuerySlotCodedValues(List<Slot> list, String string) {
        Slot slot = XDSMapper.getSlot(list, string);
        Slot slot2 = XDSMapper.getSlot(list, string + "Scheme");
        List<CodedValue> list2 = Collections.emptyList();
        if (slot != null) {
            List<String> list3 = XDSMapper.getQuerySlotValues(slot);
            List<Object> list4 = Collections.emptyList();
            if (slot2 != null) {
                list4 = XDSMapper.getQuerySlotValues(slot2);
            }
            list2 = new ArrayList<CodedValue>(list3.size());
            for (int i = 0; i < list3.size(); ++i) {
                if (list4.size() >= i + 1) {
                    list2.add(new CodedValue((String)list4.get(i), list3.get(i), null));
                    continue;
                }
                list2.add(new CodedValue(null, list3.get(i), null));
            }
        }
        return list2;
    }

    private static String getQuerySlotValue(List<Slot> list, String string) {
        List<String> list2 = XDSMapper.getQuerySlotValues(list, string);
        if (!list2.isEmpty()) {
            return list2.get(0);
        }
        return null;
    }

    private static String getQuerySlotDateTimeValue(List<Slot> list, String string) {
        String string2 = XDSMapper.getQuerySlotValue(list, string);
        if (StringUtils.isNotBlank((String)string2)) {
            return DateUtils.toUtcDate(string2);
        }
        return null;
    }

    private static Date getSlotDate(List<Slot> list, String string) {
        String string2 = XDSMapper.getSlotValue(list, string);
        if (string2 != null) {
            return MetadataUtils.parseDate(string2);
        }
        return null;
    }

    private static String getString(InternationalStringType internationalStringType) {
        StringBuilder stringBuilder = new StringBuilder();
        if (internationalStringType != null) {
            for (LocalizedString localizedString : internationalStringType.getLocalizedStrings()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(LINE_SEPARATOR);
                }
                stringBuilder.append(localizedString.getValue());
            }
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    private static String toDateTimeString(Date date) {
        return DATETIME_FORMATTER.format(date);
    }
}

